/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.debug;

import com.ibm.xltxe.rnm1.xtq.debug.ElementEvent;
import com.ibm.xltxe.rnm1.xtq.debug.FunctionEvent;
import com.ibm.xltxe.rnm1.xtq.debug.TemplateEvent;
import com.ibm.xltxe.rnm1.xtq.debug.TraceEvent;
import com.ibm.xltxe.rnm1.xtq.debug.TraceListener;
import com.ibm.xltxe.rnm1.xtq.debug.TransformationEvent;
import com.ibm.xltxe.rnm1.xtq.debug.VariableEvent;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMsg;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.exec.SourceLocation;

public abstract class DisplayTraceListener
implements TraceListener {
    @Override
    public void trace(TraceEvent traceEvent) {
        switch (traceEvent.getEventType()) {
            case 0: {
                TransformationEvent transformationEvent = (TransformationEvent)traceEvent;
                this.display(new RuntimeMsg("DBG_TRACE_TRANSFORMATION_START_EVENT", new Object[]{transformationEvent.getStylesheetURI(), transformationEvent.getInputURI()}).getFormattedMessage());
                break;
            }
            case 1: {
                TransformationEvent transformationEvent = (TransformationEvent)traceEvent;
                this.display(new RuntimeMsg("DBG_TRACE_TRANSFORMATION_END_EVENT", new Object[]{transformationEvent.getStylesheetURI(), transformationEvent.getInputURI()}).getFormattedMessage());
                break;
            }
            case 2: {
                TemplateEvent templateEvent = (TemplateEvent)traceEvent;
                Object[] objectArray = new Object[8];
                objectArray[0] = this.getTemplateAttributesString(templateEvent);
                this.addSourceLocationMessageParams(templateEvent.getTemplateSourceLocation(), 1, objectArray);
                this.display(new RuntimeMsg("DBG_TRACE_TEMPLATE_ENTRY_EVENT", objectArray).getFormattedMessage());
                break;
            }
            case 3: {
                TemplateEvent templateEvent = (TemplateEvent)traceEvent;
                Object[] objectArray = new Object[8];
                objectArray[0] = this.getTemplateAttributesString(templateEvent);
                this.addSourceLocationMessageParams(templateEvent.getTemplateSourceLocation(), 1, objectArray);
                this.display(new RuntimeMsg("DBG_TRACE_TEMPLATE_EXIT_EVENT", objectArray).getFormattedMessage());
                break;
            }
            case 4: {
                FunctionEvent functionEvent = (FunctionEvent)traceEvent;
                Object[] objectArray = new Object[8];
                objectArray[0] = functionEvent.getFunctionName();
                this.addSourceLocationMessageParams(functionEvent.getFunctionSourceLocation(), 1, objectArray);
                this.display(new RuntimeMsg("DBG_TRACE_FUNCTION_ENTRY_EVENT", objectArray).getFormattedMessage());
                break;
            }
            case 5: {
                FunctionEvent functionEvent = (FunctionEvent)traceEvent;
                Object[] objectArray = new Object[8];
                objectArray[0] = functionEvent.getFunctionName();
                this.addSourceLocationMessageParams(functionEvent.getFunctionSourceLocation(), 1, objectArray);
                this.display(new RuntimeMsg("DBG_TRACE_FUNCTION_EXIT_EVENT", objectArray).getFormattedMessage());
                break;
            }
            case 6: {
                ElementEvent elementEvent = (ElementEvent)traceEvent;
                Object[] objectArray = new Object[8];
                objectArray[0] = elementEvent.getElementName();
                this.addSourceLocationMessageParams(elementEvent.getElementSourceLocation(), 1, objectArray);
                this.display(new RuntimeMsg("DBG_TRACE_ELEMENT_START_EVENT", objectArray).getFormattedMessage());
                break;
            }
            case 7: {
                ElementEvent elementEvent = (ElementEvent)traceEvent;
                Object[] objectArray = new Object[8];
                objectArray[0] = elementEvent.getElementName();
                this.addSourceLocationMessageParams(elementEvent.getElementSourceLocation(), 1, objectArray);
                this.display(new RuntimeMsg("DBG_TRACE_ELEMENT_END_EVENT", objectArray).getFormattedMessage());
                break;
            }
            case 8: {
                VariableEvent variableEvent = (VariableEvent)traceEvent;
                String string2 = variableEvent.getVariableName();
                Cursor cursor2 = variableEvent.getVariableValue();
                this.display(new RuntimeMsg("DBG_TRACE_TARGET_OUTPUT_END_EVENT", new Object[]{string2, variableEvent.isParam(), variableEvent.isGlobal(), cursor2.itemTypeName().toString(), cursor2.itemStringValue()}).getFormattedMessage());
                break;
            }
            case 9: {
                Object[] objectArray = new Object[3];
                this.display(new RuntimeMsg("DBG_TRACE_SELECTION_EVENT", objectArray).getFormattedMessage());
                break;
            }
            case 10: {
                this.display(new RuntimeMsg("DBG_TRACE_TARGET_OUTPUT_START_EVENT", new Object[]{""}).getFormattedMessage());
                break;
            }
            case 11: {
                this.display(new RuntimeMsg("DBG_TRACE_TARGET_OUTPUT_END_EVENT", new Object[]{""}).getFormattedMessage());
                break;
            }
            case 12: {
                this.display(new RuntimeMsg("DBG_TRACE_GENERATE_OUTPUT_EVENT", new Object[]{0, ""}).getFormattedMessage());
                break;
            }
            case 13: {
                this.display(new RuntimeMsg("DBG_TRACE_JAVA_EXTENSION_START_EVENT", new Object[]{"", ""}).getFormattedMessage());
                break;
            }
            case 14: {
                this.display(new RuntimeMsg("DBG_TRACE_JAVA_EXTENSION_END_EVENT", new Object[]{"", ""}).getFormattedMessage());
            }
        }
    }

    private String getTemplateAttributesString(TemplateEvent templateEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (templateEvent.getTemplateName() != null) {
            stringBuilder.append("\t\tname = " + templateEvent.getTemplateName() + "\n");
        }
        if (templateEvent.getTemplateMatch() != null) {
            stringBuilder.append("\t\tmatch = " + templateEvent.getTemplateMatch() + "\n");
        }
        if (templateEvent.getTemplateMode() != null) {
            stringBuilder.append("\t\tmode = " + templateEvent.getTemplateMode() + "\n");
        }
        if (templateEvent.getTemplatePriority() != null) {
            stringBuilder.append("\t\tpriority = " + templateEvent.getTemplatePriority() + "\n");
        }
        if (templateEvent.getTemplateAs() != null) {
            stringBuilder.append("\t\tas = " + templateEvent.getTemplateAs() + "\n");
        }
        return stringBuilder.toString();
    }

    private void addSourceLocationMessageParams(SourceLocation sourceLocation, int n2, Object[] objectArray) {
        objectArray[n2++] = sourceLocation.getSystemId();
        objectArray[n2++] = sourceLocation.getStartLine();
        objectArray[n2++] = sourceLocation.getStartColumn();
        objectArray[n2++] = sourceLocation.getEndLine();
        objectArray[n2++] = sourceLocation.getEndColumn();
        objectArray[n2++] = sourceLocation.getStartOffset();
        objectArray[n2] = sourceLocation.getEndOffset();
    }

    abstract void display(String var1);
}

