/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.icu.text.Normalizer;
import com.ibm.xltxe.rnm1.xtq.common.utils.UnicodeNormalizer;

public final class UnicodeNormalizerFactory {
    static final Class m_icu = UnicodeNormalizerFactory.init();

    private static Class init() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.ibm.icu.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        return clazz;
    }

    private static boolean icuIsOnTheClassPath() {
        return m_icu != null;
    }

    public static final UnicodeNormalizer getUnicodeNormalizer() {
        UnicodeNormalizer unicodeNormalizer = UnicodeNormalizerFactory.icuIsOnTheClassPath() ? new UnicodeNormalizerICUImpl() : new UnicodeNormalizerDefaultImpl();
        return unicodeNormalizer;
    }

    private static class UnicodeNormalizerDefaultImpl
    implements UnicodeNormalizer {
        private UnicodeNormalizerDefaultImpl() {
        }

        @Override
        public boolean alreadyNormalized(int n2, int n3) {
            return true;
        }

        @Override
        public boolean alreadyNormalized(char[] cArray, int n2, int n3, int n4) {
            return true;
        }

        @Override
        public boolean alreadyNormalized(String string2, int n2) {
            return true;
        }

        @Override
        public String normalizeUnicode(int n2, int n3) {
            return null;
        }

        @Override
        public int normalizeUnicode(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            return 0;
        }

        @Override
        public String normalizeUnicode(String string2, int n2) {
            return null;
        }
    }

    private static class UnicodeNormalizerICUImpl
    implements UnicodeNormalizer {
        final Normalizer.Mode getMode(int n2) {
            switch (n2) {
                case 2: {
                    return Normalizer.NFC;
                }
                case 3: {
                    return Normalizer.NFD;
                }
                case 4: {
                    return Normalizer.NFKC;
                }
                case 5: {
                    return Normalizer.NFKD;
                }
                case 1: {
                    return Normalizer.NONE;
                }
                case 6: {
                    return Normalizer.NFC;
                }
            }
            return Normalizer.NONE;
        }

        @Override
        public final boolean alreadyNormalized(int n2, int n3) {
            return Normalizer.isNormalized((int)n2, (Normalizer.Mode)this.getMode(n3), (int)0);
        }

        @Override
        public final boolean alreadyNormalized(char[] cArray, int n2, int n3, int n4) {
            Normalizer.QuickCheckResult quickCheckResult = Normalizer.quickCheck((char[])cArray, (int)n2, (int)n3, (Normalizer.Mode)this.getMode(n4), (int)0);
            boolean bl = quickCheckResult == Normalizer.YES;
            return bl;
        }

        @Override
        public final boolean alreadyNormalized(String string2, int n2) {
            Normalizer.QuickCheckResult quickCheckResult = Normalizer.quickCheck((String)string2, (Normalizer.Mode)this.getMode(n2), (int)0);
            boolean bl = quickCheckResult == Normalizer.YES;
            return bl;
        }

        @Override
        public final String normalizeUnicode(int n2, int n3) {
            return Normalizer.normalize((int)n2, (Normalizer.Mode)this.getMode(n3), (int)0);
        }

        @Override
        public final int normalizeUnicode(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            return Normalizer.normalize((char[])cArray, (int)n2, (int)n3, (char[])cArray2, (int)n4, (int)n5, (Normalizer.Mode)this.getMode(n6), (int)0);
        }

        @Override
        public final String normalizeUnicode(String string2, int n2) {
            return Normalizer.normalize((String)string2, (Normalizer.Mode)this.getMode(n2));
        }
    }
}

