/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.res.XMLMessages;
import java.io.IOException;

public class URI {
    private static final String RESERVED_CHARACTERS = ";/?:@&=+$,";
    private static final String MARK_CHARACTERS = "-_.!~*'() ";
    private static final String SCHEME_CHARACTERS = "+-.";
    private static final String USERINFO_CHARACTERS = ";:&=+$,";
    private static final String REG_NAME_CHARACTERS = ";:&=+$,@";
    private String m_scheme = null;
    private String m_userinfo = null;
    private String m_reg_name = null;
    private String m_host = null;
    private int m_port = -1;
    private String m_path = null;
    private String m_queryString = null;
    private String m_fragment = null;
    private static boolean DEBUG = false;

    public URI() {
    }

    public URI(URI uRI) {
        this.initialize(uRI);
    }

    public URI(String string2) throws MalformedURIException {
        this((URI)null, string2);
    }

    public URI(URI uRI, String string2) throws MalformedURIException {
        this.initialize(uRI, string2);
    }

    public URI(String string2, String string3) throws MalformedURIException {
        if (string2 == null || string2.trim().length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_SCHEME_REQUIRED", null));
        }
        if (string3 == null || string3.trim().length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_URI_SCHEME_SPEC", null));
        }
        this.setScheme(string2);
        this.setPath(string3);
    }

    public URI(String string2, String string3, String string4, String string5, String string6) throws MalformedURIException {
        this(string2, null, string3, -1, string4, string5, string6);
    }

    public URI(String string2, String string3, String string4, int n2, String string5, String string6, String string7) throws MalformedURIException {
        if (string2 == null || string2.trim().length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_SCHEME_REQUIRED", null));
        }
        if (string4 == null) {
            if (string3 != null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_USERINFO_IF_NO_HOST", null));
            }
            if (n2 != -1) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_PORT_IF_NO_HOST", null));
            }
        }
        if (string5 != null) {
            if (string5.indexOf(63) != -1 && string6 != null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_QUERY_STRING_IN_PATH", null));
            }
            if (string5.indexOf(35) != -1 && string7 != null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_FRAGMENT_STRING_IN_PATH", null));
            }
        }
        this.setScheme(string2);
        this.setHost(string4);
        this.setPort(n2);
        this.setUserinfo(string3);
        this.setPath(string5);
        this.setQueryString(string6);
        this.setFragment(string7);
    }

    private void initialize(URI uRI) {
        this.m_scheme = uRI.getScheme();
        this.m_userinfo = uRI.getUserinfo();
        this.m_host = uRI.getHost();
        this.m_port = uRI.getPort();
        this.m_reg_name = uRI.getRegistryName();
        this.m_path = uRI.getPath();
        this.m_queryString = uRI.getQueryString();
        this.m_fragment = uRI.getFragment();
    }

    private void initialize(URI uRI, String string2) throws MalformedURIException {
        if (uRI == null && (string2 == null || string2.trim().length() == 0)) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_CANNOT_INIT_URI_EMPTY_PARMS", null));
        }
        if (string2 == null || string2.trim().length() == 0) {
            this.initialize(uRI);
            this.setFragment(null);
            return;
        }
        String string3 = string2.trim();
        int n2 = string3.length();
        int n3 = 0;
        int n4 = string3.indexOf(58);
        if (n4 < 0) {
            if (uRI == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_SCHEME_IN_URI", new Object[]{string3}));
            }
        } else {
            this.initializeScheme(string3);
            string3 = string3.substring(n4 + 1);
            if (!(this.m_scheme == null || uRI == null || !string3.startsWith("/") && this.m_scheme.equals(uRI.m_scheme) && uRI.getSchemeSpecificPart().startsWith("/"))) {
                uRI = null;
            }
            n2 = string3.length();
        }
        if (n3 + 1 < n2 && string3.substring(n3).startsWith("//")) {
            int n5 = n3 += 2;
            char c = '\u0000';
            while (n3 < n2 && (c = string3.charAt(n3)) != '/' && c != '?' && c != '#') {
                ++n3;
            }
            if (n3 > n5) {
                this.initializeAuthority(string3.substring(n5, n3));
            } else {
                this.m_host = "";
            }
        }
        this.initializePath(string3.substring(n3));
        if (uRI != null) {
            int n6;
            if (this.m_path.length() == 0 && this.m_scheme == null && this.m_host == null) {
                this.m_scheme = uRI.getScheme();
                this.m_userinfo = uRI.getUserinfo();
                this.m_host = uRI.getHost();
                this.m_port = uRI.getPort();
                this.m_reg_name = uRI.getRegistryName();
                this.m_path = uRI.getPath();
                if (this.m_queryString == null) {
                    this.m_queryString = uRI.getQueryString();
                }
                return;
            }
            if (this.m_scheme == null) {
                this.m_scheme = uRI.getScheme();
            }
            if (this.m_host != null || this.m_reg_name != null) {
                return;
            }
            this.m_userinfo = uRI.getUserinfo();
            this.m_host = uRI.getHost();
            this.m_port = uRI.getPort();
            this.m_reg_name = uRI.getRegistryName();
            if (this.m_path.length() > 0 && this.m_path.startsWith("/")) {
                return;
            }
            String string4 = new String();
            String string5 = uRI.getPath();
            if (string5 != null && (n6 = string5.lastIndexOf(47)) != -1) {
                string4 = string5.substring(0, n6 + 1);
            }
            string4 = string4.concat(this.m_path);
            if (uRI.isGenericURI() && string4.length() > 0 && string4.charAt(0) != '/') {
                string4 = "/".concat(string4);
            }
            n3 = -1;
            while ((n3 = string4.indexOf("/./")) != -1) {
                string4 = string4.substring(0, n3 + 1).concat(string4.substring(n3 + 3));
            }
            if (string4.endsWith("/.")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            n3 = -1;
            n6 = -1;
            String string6 = null;
            while ((n3 = string4.indexOf("/../")) >= 0) {
                string6 = string4.substring(0, string4.indexOf("/../"));
                n6 = string6.lastIndexOf(47);
                if (n6 < 0) {
                    n6 = 0;
                }
                string4 = string4.substring(0, n6).concat(string4.substring(n3 + 3));
            }
            if (string4.endsWith("/..") && (n6 = (string6 = string4.substring(0, string4.length() - 3)).lastIndexOf(47)) != -1) {
                string4 = string4.substring(0, n6 + 1);
            }
            this.m_path = string4;
        }
    }

    private void initializeScheme(String string2) throws MalformedURIException {
        int n2;
        int n3 = string2.length();
        String string3 = null;
        char c = '\u0000';
        for (n2 = 0; n2 < n3 && (c = string2.charAt(n2)) != ':' && c != '/' && c != '?' && c != '#'; ++n2) {
        }
        string3 = string2.substring(0, n2);
        if (string3.length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_SCHEME_IN_URI", new Object[]{string2}));
        }
        this.setScheme(string3);
    }

    private void initializeAuthority(String string2) throws MalformedURIException {
        int n2;
        int n3 = 0;
        int n4 = string2.length();
        char c = '\u0000';
        String string3 = null;
        if (string2.indexOf(64, n3) != -1) {
            for (n2 = 0; n2 < n4 && (c = string2.charAt(n2)) != '@'; ++n2) {
            }
            string3 = string2.substring(n3, n2);
            ++n2;
        }
        String string4 = null;
        n3 = n2;
        while (n2 < n4 && (c = string2.charAt(n2)) != ':') {
            ++n2;
        }
        string4 = string2.substring(n3, n2);
        int n5 = -1;
        if (string4.length() > 0 && c == ':') {
            n3 = ++n2;
            while (n2 < n4) {
                ++n2;
            }
            String string5 = string2.substring(n3, n2);
            if (string5.length() > 0) {
                for (int i = 0; i < string5.length(); ++i) {
                    if (URI.isDigit(string5.charAt(i))) continue;
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ER_INVALID_PORT", new Object[]{string5}));
                }
                try {
                    n5 = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (!URI.isWellFormedAddress(string4) || !URI.isValidPortNumber(n5) || string3 != null && URI.isValidUserinfo(string3) >= 0) {
            this.setRegistryName(string2);
        } else {
            this.setHost(string4);
            this.setPort(n5);
            this.setUserinfo(string3);
        }
    }

    private void initializePath(String string2) throws MalformedURIException {
        int n2;
        if (string2 == null) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_NULL_URI_SPEC", null));
        }
        int n3 = 0;
        int n4 = string2.length();
        char c = '\u0000';
        for (n2 = 0; n2 < n4 && (c = string2.charAt(n2)) != '?' && c != '#'; ++n2) {
            if (c == '%') {
                if (n2 + 2 < n4 && URI.isHex(string2.charAt(n2 + 1)) && URI.isHex(string2.charAt(n2 + 2))) continue;
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_CONTAINS_INVALID_ESCAPE_SEQUENCE", new Object[]{string2}));
            }
            if (URI.isReservedCharacter(c) || URI.isUnreservedCharacter(c) || '\\' == c) continue;
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_INVALID_CHAR", new Object[]{string2, String.valueOf(c)}));
        }
        this.m_path = string2.substring(n3, n2);
        if (c == '?') {
            n3 = ++n2;
            while (n2 < n4 && (c = string2.charAt(n2)) != '#') {
                if (c == '%') {
                    if (n2 + 2 >= n4 || !URI.isHex(string2.charAt(n2 + 1)) || !URI.isHex(string2.charAt(n2 + 2))) {
                        throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_QUERY_CONTAINS_INVALID_ESCAPE_CHAR", new Object[]{string2.substring(n3)}));
                    }
                } else if (!URI.isReservedCharacter(c) && !URI.isUnreservedCharacter(c)) {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_QUERY_CONTAINS_INVALID_CHAR", new Object[]{string2.substring(n3), String.valueOf(c)}));
                }
                ++n2;
            }
            this.m_queryString = string2.substring(n3, n2);
        }
        if (c == '#') {
            n3 = ++n2;
            while (n2 < n4) {
                c = string2.charAt(n2);
                if (c == '%') {
                    if (n2 + 2 >= n4 || !URI.isHex(string2.charAt(n2 + 1)) || !URI.isHex(string2.charAt(n2 + 2))) {
                        throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_FRAGMENT_CONTAINS_INVALID_ESCAPE_CHAR", new Object[]{string2.substring(n3)}));
                    }
                } else if (!URI.isReservedCharacter(c) && !URI.isUnreservedCharacter(c)) {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_FRAGMENT_CONTAINS_INVALID_CHAR", new Object[]{string2.substring(n3), String.valueOf(c)}));
                }
                ++n2;
            }
            this.m_fragment = string2.substring(n3, n2);
        }
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getSchemeSpecificPart() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_userinfo != null || this.m_host != null || this.m_port != -1 || this.m_reg_name != null) {
            stringBuffer.append("//");
        }
        if (this.m_reg_name != null) {
            stringBuffer.append(this.m_reg_name);
        }
        if (this.m_userinfo != null) {
            stringBuffer.append(this.m_userinfo);
            stringBuffer.append('@');
        }
        if (this.m_host != null) {
            stringBuffer.append(this.m_host);
        }
        if (this.m_port != -1) {
            stringBuffer.append(':');
            stringBuffer.append(this.m_port);
        }
        if (this.m_path != null) {
            stringBuffer.append(this.m_path);
        }
        if (this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getUserinfo() {
        return this.m_userinfo;
    }

    public String getRegistryName() {
        return this.m_reg_name;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getPath(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(this.m_path);
        if (bl && this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (bl2 && this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getPath() {
        return this.m_path;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public void setScheme(String string2) throws MalformedURIException {
        if (string2 == null || string2.trim().length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_SCHEME_REQUIRED", null));
        }
        if (!URI.isConformantSchemeName(string2)) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_SCHEME_NOT_CONFORMANT", new Object[]{string2}));
        }
        this.m_scheme = string2;
    }

    public void setUserinfo(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_userinfo = null;
        } else {
            if (this.m_host == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_USERINFO_IF_NO_HOST", null));
            }
            int n2 = URI.isValidUserinfo(string2);
            if (n2 == 0) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_USERINFO_CONTAINS_INVALID_ESCAPE_CHAR", new Object[]{string2}));
            }
            if (n2 > 0) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_USERINFO_CONTAINS_INVALID_CHAR", new Object[]{string2, String.valueOf((char)n2)}));
            }
            this.m_userinfo = string2;
        }
    }

    public void setHost(String string2) throws MalformedURIException {
        if (string2 == null || string2.trim().length() == 0) {
            this.m_host = string2;
            this.m_userinfo = null;
            this.m_port = -1;
            this.m_reg_name = null;
        } else if (!URI.isWellFormedAddress(string2)) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_HOST_ADDRESS_NOT_WELLFORMED", new Object[]{string2}));
        }
        this.m_host = string2;
        this.m_reg_name = null;
    }

    public void setPort(int n2) throws MalformedURIException {
        if (URI.isValidPortNumber(n2)) {
            if (this.m_host == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PORT_WHEN_HOST_NULL", null));
            }
        } else {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_INVALID_PORT", new Object[]{n2}));
        }
        this.m_port = n2;
        this.m_port = n2;
    }

    public void setRegistryName(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_reg_name = null;
        } else {
            int n2 = URI.isValidRegistryName(string2);
            if (n2 >= 0) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_REGISTRY_NAME_NOT_VALID", new Object[]{string2}));
            }
            this.m_reg_name = string2;
            this.m_host = null;
            this.m_userinfo = null;
            this.m_port = -1;
        }
    }

    public void setPath(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_path = null;
            this.m_queryString = null;
            this.m_fragment = null;
        } else {
            this.initializePath(string2);
        }
    }

    public void appendPath(String string2) throws MalformedURIException {
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        if (!URI.isURIString(string2)) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_INVALID", new Object[]{string2}));
        }
        this.m_path = this.m_path == null || this.m_path.trim().length() == 0 ? (string2.startsWith("/") ? string2 : "/" + string2) : (this.m_path.endsWith("/") ? (string2.startsWith("/") ? this.m_path.concat(string2.substring(1)) : this.m_path.concat(string2)) : (string2.startsWith("/") ? this.m_path.concat(string2) : this.m_path.concat("/" + string2)));
    }

    public void setQueryString(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_queryString = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_NON_GENERIC_URI", null));
            }
            if (this.getPath() == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_NULL_PATH_FOR_QUERY", null));
            }
            if (!URI.isURIString(string2)) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_QUERY_INVALID", new Object[]{string2}));
            }
            this.m_queryString = string2;
        }
    }

    public void setFragment(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_fragment = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_FRAG_FOR_GENERIC_URI", null));
            }
            if (this.getPath() == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_FRAG_WHEN_PATH_NULL", null));
            }
            if (!URI.isURIString(string2)) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_FRAG_INVALID_CHAR", new Object[]{string2}));
            }
            this.m_fragment = string2;
        }
    }

    public boolean equals(Object object2) {
        if (object2 instanceof URI) {
            URI uRI = (URI)object2;
            if ((this.m_scheme == null && uRI.m_scheme == null || this.m_scheme != null && uRI.m_scheme != null && this.m_scheme.toLowerCase().equals(uRI.m_scheme.toLowerCase())) && (this.m_userinfo == null && uRI.m_userinfo == null || this.m_userinfo != null && uRI.m_userinfo != null && this.m_userinfo.equals(uRI.m_userinfo)) && (this.m_host == null && uRI.m_host == null || this.m_host != null && uRI.m_host != null && this.m_host.equals(uRI.m_host)) && (this.m_reg_name == null && uRI.m_reg_name == null || this.m_reg_name != null && uRI.m_reg_name != null && this.m_reg_name.equals(uRI.m_reg_name)) && this.m_port == uRI.m_port && (this.m_path == null && uRI.m_path == null || this.m_path != null && uRI.m_path != null && this.m_path.equals(uRI.m_path)) && (this.m_queryString == null && uRI.m_queryString == null || this.m_queryString != null && uRI.m_queryString != null && this.m_queryString.equals(uRI.m_queryString)) && (this.m_fragment == null && uRI.m_fragment == null || this.m_fragment != null && uRI.m_fragment != null && this.m_fragment.equals(uRI.m_fragment))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_scheme != null) {
            stringBuffer.append(this.m_scheme);
            stringBuffer.append(':');
        }
        stringBuffer.append(this.getSchemeSpecificPart());
        return stringBuffer.toString();
    }

    public boolean isGenericURI() {
        return this.m_host != null || this.m_reg_name != null;
    }

    public static boolean isConformantSchemeName(String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return false;
        }
        if (!URI.isAlpha(string2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (URI.isAlphanum(c) || SCHEME_CHARACTERS.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedAddress(String string2) {
        if (string2 == null) {
            return false;
        }
        String string3 = string2.trim();
        int n2 = string3.length();
        if (n2 == 0 || n2 > 255) {
            return false;
        }
        if (string3.startsWith(".") || string3.startsWith("-")) {
            return false;
        }
        int n3 = string3.lastIndexOf(46);
        if (string3.endsWith(".")) {
            n3 = string3.substring(0, n3).lastIndexOf(46);
        }
        if (n3 + 1 < n2 && URI.isDigit(string2.charAt(n3 + 1))) {
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                char c = string3.charAt(i);
                if (c == '.') {
                    if (!URI.isDigit(string3.charAt(i - 1)) || i + 1 < n2 && !URI.isDigit(string3.charAt(i + 1))) {
                        return false;
                    }
                    ++n4;
                    continue;
                }
                if (URI.isDigit(c)) continue;
                return false;
            }
            if (n4 != 3) {
                return false;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                char c = string3.charAt(i);
                if (c == '.') {
                    if (!URI.isAlphanum(string3.charAt(i - 1))) {
                        return false;
                    }
                    if (i + 1 >= n2 || URI.isAlphanum(string3.charAt(i + 1))) continue;
                    return false;
                }
                if (URI.isAlphanum(c) || c == '-') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidPortNumber(int n2) {
        return n2 >= 0 && n2 <= 65535 || n2 == -1;
    }

    public static int isValidUserinfo(String string2) {
        return URI.isValidUserinfoOrRegistryName(string2, false);
    }

    public static int isValidRegistryName(String string2) {
        return URI.isValidUserinfoOrRegistryName(string2, true);
    }

    private static int isValidUserinfoOrRegistryName(String string2, boolean bl) {
        int n2 = string2.length();
        char c = '\u0000';
        for (int i = 0; i < n2; ++i) {
            c = string2.charAt(i);
            if (c == '%') {
                if (i + 2 < n2 && URI.isHex(string2.charAt(i + 1)) && URI.isHex(string2.charAt(i + 2))) continue;
                return 0;
            }
            if (URI.isUnreservedCharacter(c) || (bl || USERINFO_CHARACTERS.indexOf(c) != -1) && (!bl || REG_NAME_CHARACTERS.indexOf(c) != -1)) continue;
            return c;
        }
        return -1;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHex(char c) {
        return URI.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAlphanum(char c) {
        return URI.isAlpha(c) || URI.isDigit(c);
    }

    private static boolean isReservedCharacter(char c) {
        return RESERVED_CHARACTERS.indexOf(c) != -1;
    }

    private static boolean isUnreservedCharacter(char c) {
        return URI.isAlphanum(c) || MARK_CHARACTERS.indexOf(c) != -1;
    }

    private static boolean isURIString(String string2) {
        if (string2 == null) {
            return false;
        }
        int n2 = string2.length();
        char c = '\u0000';
        for (int i = 0; i < n2; ++i) {
            c = string2.charAt(i);
            if (c == '%') {
                if (i + 2 >= n2 || !URI.isHex(string2.charAt(i + 1)) || !URI.isHex(string2.charAt(i + 2))) {
                    return false;
                }
                i += 2;
                continue;
            }
            if (URI.isReservedCharacter(c) || URI.isUnreservedCharacter(c)) continue;
            return false;
        }
        return true;
    }

    public static class MalformedURIException
    extends IOException {
        private static final long serialVersionUID = -3880275380896996457L;

        public MalformedURIException() {
        }

        public MalformedURIException(String string2) {
            super(string2);
        }
    }
}

