/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.ArrayListToReplaceVector;
import com.ibm.xltxe.rnm1.xtq.common.utils.IntVector;

public class SparseVector {
    ArrayListToReplaceVector m_values;
    IntVector m_keys;
    static final int HASHPRIME = 101;
    int[] m_hashStart = new int[101];
    IntVector m_hashChain;
    static final int NULL = -1;

    public SparseVector() {
        this.m_values = new ArrayListToReplaceVector();
        this.m_keys = new IntVector();
        this.m_hashChain = new IntVector(512);
        this.removeAllElements();
    }

    public void removeAllElements() {
        this.m_values.clear();
        this.m_keys.removeAllElements();
        for (int i = 0; i < 101; ++i) {
            this.m_hashStart[i] = -1;
        }
        this.m_hashChain.removeAllElements();
    }

    public Object setElementAt(Object object2, int n2) {
        return this.maybeSetElementAt(object2, n2, true);
    }

    public Object elementAt(int n2) {
        int n3;
        int n4 = n2 % 101;
        if (n4 < 0) {
            n4 = -n4;
        }
        int n5 = n3 = this.m_hashStart[n4];
        while (n5 != -1) {
            if (this.m_keys.elementAt(n5) == n2) {
                Object e = this.m_values.get(n5);
                return e;
            }
            n3 = n5;
            n5 = this.m_hashChain.elementAt(n5);
        }
        return null;
    }

    protected Object maybeSetElementAt(Object object2, int n2, boolean bl) {
        int n3;
        int n4 = n2 % 101;
        if (n4 < 0) {
            n4 = -n4;
        }
        int n5 = n3 = this.m_hashStart[n4];
        while (n5 != -1) {
            if (this.m_keys.elementAt(n5) == n2) {
                Object e = this.m_values.get(n5);
                if (bl) {
                    this.m_values.set(n5, object2);
                }
                return e;
            }
            n3 = n5;
            n5 = this.m_hashChain.elementAt(n5);
        }
        if (bl) {
            int n6 = this.m_values.size();
            this.m_values.add(object2);
            this.m_keys.addElement(n2);
            this.m_hashChain.addElement(-1);
            if (n3 == -1) {
                this.m_hashStart[n4] = n6;
            } else {
                this.m_hashChain.setElementAt(n6, n3);
            }
        }
        return null;
    }
}

