/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.StAX2SAX;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class STAXStream2SAX
extends StAX2SAX {
    private XMLStreamReader m_streamReader = null;

    public STAXStream2SAX(XMLStreamReader xMLStreamReader) {
        this.m_streamReader = xMLStreamReader;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            if (this.m_streamReader != null && this.m_streamReader.hasNext()) {
                this.parse(this.m_streamReader, this.m_streamReader.getEventType());
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    private void parse(XMLStreamReader xMLStreamReader, int n2) throws IOException, SAXException {
        try {
            switch (n2) {
                case 7: {
                    this.setLocation(xMLStreamReader.getLocation());
                    this.getContentHandler().setDocumentLocator(this);
                    this.getContentHandler().startDocument();
                    while (xMLStreamReader.hasNext()) {
                        this.parse(xMLStreamReader, xMLStreamReader.next());
                    }
                    this.getContentHandler().endDocument();
                    break;
                }
                case 4: 
                case 6: {
                    String string2 = xMLStreamReader.getText();
                    this.getContentHandler().characters(string2.toCharArray(), 0, string2.length());
                    break;
                }
                case 12: {
                    int n3 = xMLStreamReader.getTextLength();
                    char[] cArray = new char[n3];
                    xMLStreamReader.getTextCharacters(xMLStreamReader.getTextStart(), cArray, 0, n3);
                    if (this.getLexicalHandler() != null) {
                        this.getLexicalHandler().startCDATA();
                        this.getContentHandler().characters(cArray, 0, cArray.length);
                        this.getLexicalHandler().endCDATA();
                        break;
                    }
                    this.getContentHandler().characters(cArray, 0, cArray.length);
                    break;
                }
                case 1: {
                    int n4;
                    String string3;
                    String string4;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    AttributesImpl attributesImpl = new AttributesImpl();
                    int n5 = xMLStreamReader.getNamespaceCount();
                    for (int i = 0; i < n5; ++i) {
                        string4 = xMLStreamReader.getNamespaceURI(i);
                        string3 = xMLStreamReader.getNamespacePrefix(i);
                        if (!this.startPrefixMapping(string3, string4)) continue;
                        arrayList.add(string3);
                    }
                    String string5 = xMLStreamReader.getNamespaceURI();
                    string4 = xMLStreamReader.getLocalName();
                    string3 = xMLStreamReader.getPrefix();
                    if (string5 != null) {
                        if (!string5.equals("") && this.startPrefixMapping(string3, string5)) {
                            arrayList.add(string3);
                        }
                    } else {
                        string5 = "";
                    }
                    String string6 = string3 == null || string3.equals("") ? string4 : string3 + ":" + string4;
                    this.getContentHandler().startElement(string5, string4, string6, this);
                    while (xMLStreamReader.hasNext() && (n4 = xMLStreamReader.next()) != 2) {
                        this.parse(xMLStreamReader, n4);
                    }
                    this.getContentHandler().endElement(string5, string4, string6);
                    int n6 = arrayList.size();
                    for (int i = 0; i < n6; ++i) {
                        this.endPrefixMapping((String)arrayList.get(i));
                    }
                    break;
                }
                case 5: {
                    if (this.getLexicalHandler() == null) break;
                    int n7 = xMLStreamReader.getTextLength();
                    char[] cArray = new char[n7];
                    xMLStreamReader.getTextCharacters(xMLStreamReader.getTextStart(), cArray, 0, n7);
                    this.getLexicalHandler().comment(cArray, 0, n7);
                    break;
                }
                case 3: {
                    this.getContentHandler().processingInstruction(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
                    break;
                }
                case 11: {
                    if (this.getDTDHandler() == null) break;
                    List list = (List)xMLStreamReader.getProperty("javax.xml.stream.entities");
                    for (XMLEvent xMLEvent : list) {
                        if (xMLEvent.getEventType() != 15) continue;
                        EntityDeclaration entityDeclaration = (EntityDeclaration)xMLEvent;
                        this.getDTDHandler().unparsedEntityDecl(entityDeclaration.getName(), entityDeclaration.getPublicId(), entityDeclaration.getSystemId(), entityDeclaration.getNotationName());
                    }
                    break;
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    @Override
    public int getIndex(String string2) {
        for (int i = 0; i < this.getLength(); ++i) {
            String string3;
            String string4 = this.m_streamReader.getAttributeLocalName(i);
            String string5 = this.m_streamReader.getAttributePrefix(i);
            String string6 = string3 = string5 == null || string5.equals("") ? string4 : string5 + ":" + string4;
            if (string3 == null || !string3.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String string2, String string3) {
        for (int i = 0; i < this.getLength(); ++i) {
            String string4 = this.m_streamReader.getAttributeLocalName(i);
            String string5 = this.m_streamReader.getAttributeNamespace(i);
            if (string2 == null && string5 == null && string3 != null && string3.equals(string4)) {
                return i;
            }
            if (string5 == null || !string5.equals(string2) || string4 == null || !string4.equals(string3)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.m_streamReader.getAttributeCount();
    }

    @Override
    public String getLocalName(int n2) {
        return this.m_streamReader.getAttributeLocalName(n2);
    }

    @Override
    public String getQName(int n2) {
        String string2 = this.m_streamReader.getAttributePrefix(n2);
        String string3 = this.m_streamReader.getAttributeLocalName(n2);
        return string2 == null || string2.equals("") ? string3 : string2 + ":" + string3;
    }

    @Override
    public String getType(int n2) {
        return this.m_streamReader.getAttributeType(n2);
    }

    @Override
    public String getType(String string2) {
        int n2 = this.getIndex(string2);
        return n2 > 0 ? this.getType(n2) : null;
    }

    @Override
    public String getType(String string2, String string3) {
        int n2 = this.getIndex(string2, string3);
        return n2 > 0 ? this.getType(n2) : null;
    }

    @Override
    public String getURI(int n2) {
        return this.m_streamReader.getAttributeNamespace(n2);
    }

    @Override
    public String getValue(int n2) {
        return this.m_streamReader.getAttributeValue(n2);
    }

    @Override
    public String getValue(String string2) {
        int n2 = this.getIndex(string2);
        return n2 > 0 ? this.getValue(n2) : null;
    }

    @Override
    public String getValue(String string2, String string3) {
        return this.m_streamReader.getAttributeValue(string2, string3);
    }
}

