/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.EncodingInfo;
import com.ibm.xltxe.rnm1.xtq.common.utils.ObjectFactory;
import com.ibm.xltxe.rnm1.xtq.common.utils.SecuritySupport;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Encodings {
    private static final String PKG_NAME;
    private static final String PKG_PATH;
    private static final String ENCODINGS_FILE;
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava;
    private static final Hashtable _encodingTableKeyMime;
    private static final EncodingInfo[] _encodings;

    static Writer getWriter(OutputStream outputStream, String string2) throws UnsupportedEncodingException {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!Encodings._encodings[i].name.equalsIgnoreCase(string2)) continue;
            try {
                String string3 = Encodings._encodings[i].javaName;
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string3);
                return outputStreamWriter;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            return new OutputStreamWriter(outputStream, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string2);
        }
    }

    static EncodingInfo getEncodingInfo(String string2) {
        String string3 = Encodings.toUpperCaseFast(string2);
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string3);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string3);
        }
        if (encodingInfo == null) {
            encodingInfo = new EncodingInfo(null, null, '\u0000', true);
        }
        return encodingInfo;
    }

    public static boolean isRecognizedEncoding(String string2) {
        String string3 = string2.toUpperCase();
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string3);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string3);
        }
        return encodingInfo != null;
    }

    private static String toUpperCaseFast(String string2) {
        boolean bl = false;
        int n2 = string2.length();
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if ('a' <= c && c <= 'z') {
                c = (char)(c + -32);
                bl = true;
            }
            cArray[i] = c;
        }
        String string3 = bl ? String.valueOf(cArray) : string2;
        return string3;
    }

    static String getMimeEncoding(String string2) {
        block5: {
            if (null == string2) {
                try {
                    string2 = System.getProperty("file.encoding", "UTF8");
                    if (null != string2) {
                        String string3 = string2.equalsIgnoreCase("Cp1252") || string2.equalsIgnoreCase("ISO8859_1") || string2.equalsIgnoreCase("8859_1") || string2.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(string2);
                        string2 = null != string3 ? string3 : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    string2 = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException securityException) {
                    string2 = DEFAULT_MIME_ENCODING;
                }
            } else {
                string2 = Encodings.convertJava2MimeEncoding(string2);
            }
        }
        return string2;
    }

    private static String convertJava2MimeEncoding(String string2) {
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(Encodings.toUpperCaseFast(string2));
        if (null != encodingInfo) {
            return encodingInfo.name;
        }
        return string2;
    }

    public static String convertMime2JavaEncoding(String string2) {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!Encodings._encodings[i].name.equalsIgnoreCase(string2)) continue;
            return Encodings._encodings[i].javaName;
        }
        return string2;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        try {
            InputStream inputStream = SecuritySupport.getResourceAsStream(ObjectFactory.findClassLoader(), ENCODINGS_FILE);
            Properties properties = new Properties();
            if (inputStream != null) {
                properties.load(inputStream);
                inputStream.close();
            }
            int n2 = properties.size();
            ArrayList<EncodingInfo> arrayList = new ArrayList<EncodingInfo>();
            Enumeration<Object> enumeration = properties.keys();
            for (int i = 0; i < n2; ++i) {
                char c;
                String string2;
                String string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                String string5 = null;
                String string6 = null;
                String string7 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, " \t");
                int n3 = 1;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (n3 == 1) {
                        string5 = string2;
                    } else if (n3 == 2) {
                        string6 = string2;
                    } else if (n3 == 3) {
                        string7 = string2;
                    }
                    ++n3;
                }
                if (string5 == null) {
                    string2 = string3;
                    c = '\u0000';
                    continue;
                }
                try {
                    String string8 = string6;
                    c = string6 == null ? (char)'\u0000' : (char)Integer.decode(string8).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    c = '\u0000';
                }
                boolean bl = "STATELESS".equals(string7);
                String string9 = string5;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string9, ",");
                boolean bl2 = true;
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    EncodingInfo encodingInfo = new EncodingInfo(string2, string3, c, bl);
                    arrayList.add(encodingInfo);
                    _encodingTableKeyMime.put(string2.toUpperCase(), encodingInfo);
                    if (bl2) {
                        _encodingTableKeyJava.put(string3.toUpperCase(), encodingInfo);
                    }
                    bl2 = false;
                }
            }
            EncodingInfo[] encodingInfoArray = new EncodingInfo[arrayList.size()];
            arrayList.toArray(encodingInfoArray);
            return encodingInfoArray;
        }
        catch (MalformedURLException malformedURLException) {
            throw new WrappedRuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(iOException);
        }
    }

    static boolean isHighUTF16Surrogate(char c) {
        return '\ud800' <= c && c <= '\udbff';
    }

    static boolean isLowUTF16Surrogate(char c) {
        return '\udc00' <= c && c <= '\udfff';
    }

    static int toCodePoint(char c, char c2) {
        int n2 = (c - 55296 << 10) + (c2 - 56320) + 65536;
        return n2;
    }

    static final boolean codePointHasSurrogatePair(int n2) {
        return n2 > 65535;
    }

    static int getHighSurrogate(int n2) {
        int n3 = n2 - 65536;
        if (n3 < 0) {
            return -1;
        }
        n3 >>>= 10;
        if ((n3 += 55296) > 56319) {
            return -1;
        }
        return n3;
    }

    static int getLowSurrogate(int n2) {
        int n3 = n2 & 0x3FF;
        if ((n3 += 56320) > 57343) {
            return -1;
        }
        return n3;
    }

    static int toCodePoint(char c) {
        char c2 = c;
        return c2;
    }

    public static char getHighChar(String string2) {
        String string3 = Encodings.toUpperCaseFast(string2);
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string3);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string3);
        }
        char c = encodingInfo != null ? encodingInfo.getHighChar() : (char)'\u0000';
        return c;
    }

    static {
        String string2 = Encodings.class.getName();
        int n2 = string2.lastIndexOf(46);
        PKG_NAME = n2 < 0 ? "" : string2.substring(0, n2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < PKG_NAME.length(); ++i) {
            char c = PKG_NAME.charAt(i);
            if (c == '.') {
                stringBuffer.append('/');
                continue;
            }
            stringBuffer.append(c);
        }
        PKG_PATH = stringBuffer.toString();
        ENCODINGS_FILE = PKG_PATH + "/Encodings.properties";
        _encodingTableKeyJava = new Hashtable();
        _encodingTableKeyMime = new Hashtable();
        _encodings = Encodings.loadEncodingInfo();
    }
}

