/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals;

import com.ibm.xltxe.rnm1.xtq.bcel.Repository;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JsrInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnaddressType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.PassVerifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerificationResult;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.Verifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.VerifierConstraintViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.ControlFlowGraph;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.ExceptionHandler;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.ExecutionVisitor;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.Frame;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.InstConstraintVisitor;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.InstructionContext;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.LocalVariables;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.OperandStack;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.UninitializedObjectType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;

public final class Pass3bVerifier
extends PassVerifier {
    private static final boolean DEBUG = true;
    private Verifier myOwner;
    private int method_no;

    public Pass3bVerifier(Verifier verifier, int n2) {
        this.myOwner = verifier;
        this.method_no = n2;
    }

    private void circulationPump(ControlFlowGraph controlFlowGraph, InstructionContext instructionContext, Frame frame, InstConstraintVisitor instConstraintVisitor, ExecutionVisitor executionVisitor) {
        int n2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Random random = new Random();
        InstructionContextQueue instructionContextQueue = new InstructionContextQueue();
        instructionContext.execute(frame, new ArrayList(), instConstraintVisitor, executionVisitor);
        instructionContextQueue.add(instructionContext, new ArrayList());
        while (!instructionContextQueue.isEmpty()) {
            Object object7;
            object6 = instructionContextQueue.getIC(0);
            object5 = instructionContextQueue.getEC(0);
            instructionContextQueue.remove(0);
            object4 = (ArrayList)((ArrayList)object5).clone();
            object3 = (ArrayList)((ArrayList)object5).clone();
            ((ArrayList)object3).add(object6);
            if (object6.getInstruction().getInstruction() instanceof RET) {
                object2 = (RET)object6.getInstruction().getInstruction();
                ReturnaddressType returnaddressType = (ReturnaddressType)object6.getOutFrame((ArrayList)object4).getLocals().get(((RET)object2).getIndex());
                object7 = controlFlowGraph.contextOf(returnaddressType.getTarget());
                InstructionContext instructionContext2 = null;
                int n3 = 0;
                for (int i = ((ArrayList)object4).size() - 1; i >= 0; --i) {
                    if (n3 < 0) {
                        throw new AssertionViolatedException("More RET than JSR in execution chain?!");
                    }
                    if (((InstructionContext)((ArrayList)object4).get(i)).getInstruction().getInstruction() instanceof JsrInstruction) {
                        if (n3 == 0) {
                            instructionContext2 = (InstructionContext)((ArrayList)object4).get(i);
                            break;
                        }
                        --n3;
                    }
                    if (!(((InstructionContext)((ArrayList)object4).get(i)).getInstruction().getInstruction() instanceof RET)) continue;
                    ++n3;
                }
                if (instructionContext2 == null) {
                    throw new AssertionViolatedException("RET without a JSR before in ExecutionChain?! EC: '" + object4 + "'.");
                }
                JsrInstruction jsrInstruction = (JsrInstruction)instructionContext2.getInstruction().getInstruction();
                if (object7 != controlFlowGraph.contextOf(jsrInstruction.physicalSuccessor())) {
                    throw new AssertionViolatedException("RET '" + object6.getInstruction() + "' info inconsistent: jump back to '" + object7 + "' or '" + controlFlowGraph.contextOf(jsrInstruction.physicalSuccessor()) + "'?");
                }
                if (object7.execute(object6.getOutFrame((ArrayList)object4), (ArrayList)object3, instConstraintVisitor, executionVisitor)) {
                    instructionContextQueue.add((InstructionContext)object7, (ArrayList)((ArrayList)object3).clone());
                }
            } else {
                object2 = object6.getSuccessors();
                for (n2 = 0; n2 < ((InstructionContext[])object2).length; ++n2) {
                    object7 = object2[n2];
                    if (!object7.execute(object6.getOutFrame((ArrayList)object4), (ArrayList)object3, instConstraintVisitor, executionVisitor)) continue;
                    instructionContextQueue.add((InstructionContext)object7, (ArrayList)((ArrayList)object3).clone());
                }
            }
            object2 = object6.getExceptionHandlers();
            for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                object7 = controlFlowGraph.contextOf(((ExceptionHandler)object2[n2]).getHandlerStart());
                if (!object7.execute(new Frame(object6.getOutFrame((ArrayList)object4).getLocals(), new OperandStack(object6.getOutFrame((ArrayList)object4).getStack().maxStack(), ((ExceptionHandler)object2[n2]).getExceptionType() == null ? Type.THROWABLE : ((ExceptionHandler)object2[n2]).getExceptionType())), new ArrayList(), instConstraintVisitor, executionVisitor)) continue;
                instructionContextQueue.add((InstructionContext)object7, new ArrayList());
            }
        }
        object6 = instructionContext.getInstruction();
        do {
            if (!(((InstructionHandle)object6).getInstruction() instanceof ReturnInstruction) || controlFlowGraph.isDead((InstructionHandle)object6)) continue;
            object5 = controlFlowGraph.contextOf((InstructionHandle)object6);
            object4 = object5.getOutFrame(new ArrayList());
            object3 = ((Frame)object4).getLocals();
            for (int i = 0; i < ((LocalVariables)object3).maxLocals(); ++i) {
                if (!(((LocalVariables)object3).get(i) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + object5 + "' may leave method with an uninitialized object in the local variables array '" + object3 + "'.");
            }
            object2 = ((Frame)object4).getStack();
            for (n2 = 0; n2 < ((OperandStack)object2).size(); ++n2) {
                if (!(((OperandStack)object2).peek(n2) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + object5 + "' may leave method with an uninitialized object on the operand stack '" + object2 + "'.");
            }
        } while ((object6 = ((InstructionHandle)object6).getNext()) != null);
    }

    @Override
    public VerificationResult do_verify() {
        if (!this.myOwner.doPass3a(this.method_no).equals(VerificationResult.VR_OK)) {
            return VerificationResult.VR_NOTYET;
        }
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
        InstConstraintVisitor instConstraintVisitor = new InstConstraintVisitor();
        instConstraintVisitor.setConstantPoolGen(constantPoolGen);
        ExecutionVisitor executionVisitor = new ExecutionVisitor();
        executionVisitor.setConstantPoolGen(constantPoolGen);
        Method[] methodArray = javaClass.getMethods();
        try {
            MethodGen methodGen = new MethodGen(methodArray[this.method_no], this.myOwner.getClassName(), constantPoolGen);
            instConstraintVisitor.setMethodGen(methodGen);
            if (!methodGen.isAbstract() && !methodGen.isNative()) {
                ControlFlowGraph controlFlowGraph = new ControlFlowGraph(methodGen);
                Frame frame = new Frame(methodGen.getMaxLocals(), methodGen.getMaxStack());
                if (!methodGen.isStatic()) {
                    if (methodGen.getName().equals("<init>")) {
                        Frame._this = new UninitializedObjectType(new ObjectType(javaClass.getClassName()));
                        frame.getLocals().set(0, Frame._this);
                    } else {
                        Frame._this = null;
                        frame.getLocals().set(0, new ObjectType(javaClass.getClassName()));
                    }
                }
                Type[] typeArray = methodGen.getArgumentTypes();
                int n2 = 0;
                for (int i = 0; i < typeArray.length; ++i) {
                    if (typeArray[i] == Type.SHORT || typeArray[i] == Type.BYTE || typeArray[i] == Type.CHAR || typeArray[i] == Type.BOOLEAN) {
                        typeArray[i] = Type.INT;
                    }
                    frame.getLocals().set(n2 + i + (methodGen.isStatic() ? 0 : 1), typeArray[i]);
                    if (typeArray[i].getSize() != 2) continue;
                    frame.getLocals().set(++n2 + i + (methodGen.isStatic() ? 0 : 1), Type.UNKNOWN);
                }
                this.circulationPump(controlFlowGraph, controlFlowGraph.contextOf(methodGen.getInstructionList().getStart()), frame, instConstraintVisitor, executionVisitor);
            }
        }
        catch (VerifierConstraintViolatedException verifierConstraintViolatedException) {
            verifierConstraintViolatedException.extendMessage("Constraint violated in method '" + methodArray[this.method_no] + "':\n", "");
            return new VerificationResult(2, verifierConstraintViolatedException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            runtimeException.printStackTrace(printWriter);
            throw new AssertionViolatedException("Some RuntimeException occured while verify()ing class '" + javaClass.getClassName() + "', method '" + methodArray[this.method_no] + "'. Original RuntimeException's stack trace:\n---\n" + stringWriter + "---\n");
        }
        return VerificationResult.VR_OK;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private static final class InstructionContextQueue {
        private Vector ics = new Vector();
        private Vector ecs = new Vector();

        private InstructionContextQueue() {
        }

        public void add(InstructionContext instructionContext, ArrayList arrayList) {
            this.ics.add(instructionContext);
            this.ecs.add(arrayList);
        }

        public boolean isEmpty() {
            return this.ics.isEmpty();
        }

        public void remove() {
            this.remove(0);
        }

        public void remove(int n2) {
            this.ics.remove(n2);
            this.ecs.remove(n2);
        }

        public InstructionContext getIC(int n2) {
            return (InstructionContext)this.ics.get(n2);
        }

        public ArrayList getEC(int n2) {
            return (ArrayList)this.ecs.get(n2);
        }

        public int size() {
            return this.ics.size();
        }
    }
}

