/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StructuralCodeConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.UninitializedObjectType;
import java.util.ArrayList;

public class OperandStack {
    private ArrayList stack = new ArrayList();
    private int maxStack;

    public OperandStack(int n2) {
        this.maxStack = n2;
    }

    public OperandStack(int n2, ObjectType objectType) {
        this.maxStack = n2;
        this.push(objectType);
    }

    protected Object clone() {
        OperandStack operandStack = new OperandStack(this.maxStack);
        operandStack.stack = (ArrayList)this.stack.clone();
        return operandStack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    public boolean equals(Object object2) {
        if (!(object2 instanceof OperandStack)) {
            return false;
        }
        OperandStack operandStack = (OperandStack)object2;
        return this.stack.equals(operandStack.stack);
    }

    public OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int maxStack() {
        return this.maxStack;
    }

    public Type peek() {
        return this.peek(0);
    }

    public Type peek(int n2) {
        return (Type)this.stack.get(this.size() - n2 - 1);
    }

    public Type pop() {
        Type type2 = (Type)this.stack.remove(this.size() - 1);
        return type2;
    }

    public Type pop(int n2) {
        for (int i = 0; i < n2; ++i) {
            this.pop();
        }
        return null;
    }

    public void push(Type type2) {
        if (type2 == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type2 == Type.BOOLEAN || type2 == Type.CHAR || type2 == Type.BYTE || type2 == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type2 + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type2);
    }

    int size() {
        return this.stack.size();
    }

    public int slotsUsed() {
        int n2 = 0;
        for (int i = 0; i < this.stack.size(); ++i) {
            n2 += this.peek(i).getSize();
        }
        return n2;
    }

    public String toString() {
        String string2 = "Slots used: " + this.slotsUsed() + " MaxStack: " + this.maxStack + ".\n";
        for (int i = 0; i < this.size(); ++i) {
            string2 = string2 + this.peek(i) + " (Size: " + this.peek(i).getSize() + ")\n";
        }
        return string2;
    }

    public void merge(OperandStack operandStack) {
        if (this.slotsUsed() != operandStack.slotsUsed() || this.size() != operandStack.size()) {
            throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + operandStack);
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.stack.get(i) instanceof UninitializedObjectType) && operandStack.stack.get(i) instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (!this.stack.get(i).equals(operandStack.stack.get(i)) && this.stack.get(i) instanceof UninitializedObjectType && !(operandStack.stack.get(i) instanceof UninitializedObjectType)) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (this.stack.get(i) instanceof UninitializedObjectType && !(operandStack.stack.get(i) instanceof UninitializedObjectType)) {
                this.stack.set(i, ((UninitializedObjectType)this.stack.get(i)).getInitialized());
            }
            if (this.stack.get(i).equals(operandStack.stack.get(i))) continue;
            if (this.stack.get(i) instanceof ReferenceType && operandStack.stack.get(i) instanceof ReferenceType) {
                this.stack.set(i, ((ReferenceType)this.stack.get(i)).getFirstCommonSuperclass((ReferenceType)operandStack.stack.get(i)));
                continue;
            }
            throw new StructuralCodeConstraintException("Cannot merge stacks of different types:\nStack A:\n" + this + "\nStack B:\n" + operandStack);
        }
    }

    public void initializeObject(UninitializedObjectType uninitializedObjectType) {
        for (int i = 0; i < this.stack.size(); ++i) {
            if (this.stack.get(i) != uninitializedObjectType) continue;
            this.stack.set(i, uninitializedObjectType.getInitialized());
        }
    }
}

