/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StructuralCodeConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int n2) {
        this.locals = new Type[n2];
        for (int i = 0; i < n2; ++i) {
            this.locals[i] = Type.UNKNOWN;
        }
    }

    protected Object clone() {
        LocalVariables localVariables = new LocalVariables(this.locals.length);
        for (int i = 0; i < this.locals.length; ++i) {
            localVariables.locals[i] = this.locals[i];
        }
        return localVariables;
    }

    public Type get(int n2) {
        return this.locals[n2];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int n2, Type type2) {
        if (type2 == Type.BYTE || type2 == Type.SHORT || type2 == Type.BOOLEAN || type2 == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type2 + "'. Use Type.INT instead.");
        }
        this.locals[n2] = type2;
    }

    public boolean equals(Object object2) {
        if (!(object2 instanceof LocalVariables)) {
            return false;
        }
        LocalVariables localVariables = (LocalVariables)object2;
        if (this.locals.length != localVariables.locals.length) {
            return false;
        }
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i].equals(localVariables.locals[i])) continue;
            return false;
        }
        return true;
    }

    public void merge(LocalVariables localVariables) {
        if (this.locals.length != localVariables.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i = 0; i < this.locals.length; ++i) {
            this.merge(localVariables, i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(LocalVariables localVariables, int n2) {
        if (!(this.locals[n2] instanceof UninitializedObjectType) && localVariables.locals[n2] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (!this.locals[n2].equals(localVariables.locals[n2]) && this.locals[n2] instanceof UninitializedObjectType && localVariables.locals[n2] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (this.locals[n2] instanceof UninitializedObjectType && !(localVariables.locals[n2] instanceof UninitializedObjectType)) {
            this.locals[n2] = ((UninitializedObjectType)this.locals[n2]).getInitialized();
        }
        if (this.locals[n2] instanceof ReferenceType && localVariables.locals[n2] instanceof ReferenceType) {
            if (this.locals[n2].equals(localVariables.locals[n2])) return;
            ReferenceType referenceType = ((ReferenceType)this.locals[n2]).getFirstCommonSuperclass((ReferenceType)localVariables.locals[n2]);
            if (referenceType == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[n2] + "' and '" + localVariables.locals[n2] + "'.");
            this.locals[n2] = referenceType;
            return;
        } else {
            if (this.locals[n2].equals(localVariables.locals[n2])) return;
            this.locals[n2] = Type.UNKNOWN;
        }
    }

    public String toString() {
        String string2 = new String();
        for (int i = 0; i < this.locals.length; ++i) {
            string2 = string2 + Integer.toString(i) + ": " + this.locals[i] + "\n";
        }
        return string2;
    }

    public void initializeObject(UninitializedObjectType uninitializedObjectType) {
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i] != uninitializedObjectType) continue;
            this.locals[i] = uninitializedObjectType.getInitialized();
        }
    }
}

