/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals;

import com.ibm.xltxe.rnm1.xtq.bcel.Repository;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.AccessFlags;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantLong;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Field;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.FieldOrMethod;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.AALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.AASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ACONST_NULL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ARETURN;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ARRAYLENGTH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ATHROW;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BIPUSH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BREAKPOINT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CHECKCAST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CPInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.D2F;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.D2I;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.D2L;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DADD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DCMPG;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DCMPL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DCONST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DDIV;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DMUL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DNEG;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DREM;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DRETURN;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DSUB;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DUP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DUP2;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DUP2_X1;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DUP2_X2;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DUP_X1;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DUP_X2;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.EmptyVisitor;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.F2D;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.F2I;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.F2L;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FADD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FCMPG;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FCMPL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FCONST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FDIV;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FMUL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FNEG;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FREM;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FRETURN;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FSUB;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GETFIELD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GETSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GOTO;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GOTO_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.I2B;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.I2C;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.I2D;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.I2F;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.I2L;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.I2S;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IADD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IAND;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ICONST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IDIV;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFGE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFGT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFLE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFLT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNONNULL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNULL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ACMPEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ACMPNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPGE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPGT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPLE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPLT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ILOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IMPDEP1;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IMPDEP2;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IMUL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INEG;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INSTANCEOF;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEINTERFACE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IOR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IREM;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IRETURN;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ISHL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ISHR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ISTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ISUB;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IUSHR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IXOR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InvokeInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JSR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JSR_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.L2D;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.L2F;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.L2I;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LADD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LAND;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LCMP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LCONST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC2_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDIV;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LMUL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LNEG;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LOOKUPSWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LOR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LREM;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LRETURN;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LSHL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LSHR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LSUB;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LUSHR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LXOR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LoadClass;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LoadInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MONITORENTER;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MONITOREXIT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MULTIANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEW;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NOP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.POP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.POP2;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUTFIELD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUTSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RETURN;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnaddressType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.SALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.SASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.SIPUSH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.SWAP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.StackConsumer;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.StackInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.StackProducer;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.StoreInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TABLESWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerificationResult;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.Verifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerifierFactory;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StructuralCodeConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.Frame;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.LocalVariables;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.OperandStack;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.UninitializedObjectType;

public class InstConstraintVisitor
extends EmptyVisitor
implements Visitor {
    private static ObjectType GENERIC_ARRAY = new ObjectType("com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.GenericArray");
    private Frame frame = null;
    private ConstantPoolGen cpg = null;
    private MethodGen mg = null;

    private OperandStack stack() {
        return this.frame.getStack();
    }

    private LocalVariables locals() {
        return this.frame.getLocals();
    }

    private void constraintViolated(Instruction instruction2, String string2) {
        String string3 = instruction2.getClass().getName();
        throw new StructuralCodeConstraintException("Instruction " + string3.substring(string3.lastIndexOf(46) + 1) + " constraint violated: " + string2);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setConstantPoolGen(ConstantPoolGen constantPoolGen) {
        this.cpg = constantPoolGen;
    }

    public void setMethodGen(MethodGen methodGen) {
        this.mg = methodGen;
    }

    private void indexOfInt(Instruction instruction2, Type type2) {
        if (!type2.equals(Type.INT)) {
            this.constraintViolated(instruction2, "The 'index' is not of type int but of type " + type2 + ".");
        }
    }

    private void referenceTypeIsInitialized(Instruction instruction2, ReferenceType referenceType) {
        if (referenceType instanceof UninitializedObjectType) {
            this.constraintViolated(instruction2, "Working on an uninitialized object '" + referenceType + "'.");
        }
    }

    private void valueOfInt(Instruction instruction2, Type type2) {
        if (!type2.equals(Type.INT)) {
            this.constraintViolated(instruction2, "The 'value' is not of type int but of type " + type2 + ".");
        }
    }

    private boolean arrayrefOfArrayType(Instruction instruction2, Type type2) {
        if (!(type2 instanceof ArrayType) && !type2.equals(Type.NULL)) {
            this.constraintViolated(instruction2, "The 'arrayref' does not refer to an array but is of type " + type2 + ".");
        }
        return type2 instanceof ArrayType;
    }

    private void _visitStackAccessor(Instruction instruction2) {
        int n2;
        int n3 = instruction2.consumeStack(this.cpg);
        if (n3 > this.stack().slotsUsed()) {
            this.constraintViolated(instruction2, "Cannot consume " + n3 + " stack slots: only " + this.stack().slotsUsed() + " slot(s) left on stack!\nStack:\n" + this.stack());
        }
        if ((n2 = instruction2.produceStack(this.cpg) - instruction2.consumeStack(this.cpg)) + this.stack().slotsUsed() > this.stack().maxStack()) {
            this.constraintViolated(instruction2, "Cannot produce " + n2 + " stack slots: only " + (this.stack().maxStack() - this.stack().slotsUsed()) + " free stack slot(s) left.\nStack:\n" + this.stack());
        }
    }

    @Override
    public void visitLoadClass(LoadClass loadClass) {
        Verifier verifier;
        VerificationResult verificationResult;
        ObjectType objectType = loadClass.getLoadClassType(this.cpg);
        if (objectType != null && (verificationResult = (verifier = VerifierFactory.getVerifier(objectType.getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated((Instruction)((Object)loadClass), "Class '" + loadClass.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
    }

    @Override
    public void visitStackConsumer(StackConsumer stackConsumer) {
        this._visitStackAccessor((Instruction)((Object)stackConsumer));
    }

    @Override
    public void visitStackProducer(StackProducer stackProducer) {
        this._visitStackAccessor((Instruction)((Object)stackProducer));
    }

    @Override
    public void visitCPInstruction(CPInstruction cPInstruction) {
        int n2 = cPInstruction.getIndex();
        if (n2 < 0 || n2 >= this.cpg.getSize()) {
            throw new AssertionViolatedException("Huh?! Constant pool index of instruction '" + cPInstruction + "' illegal? Pass 3a should have checked this!");
        }
    }

    @Override
    public void visitFieldInstruction(FieldInstruction fieldInstruction) {
        String string2;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type2;
        Constant constant = this.cpg.getConstant(fieldInstruction.getIndex());
        if (!(constant instanceof ConstantFieldref)) {
            this.constraintViolated(fieldInstruction, "Index '" + fieldInstruction.getIndex() + "' should refer to a CONSTANT_Fieldref_info structure, but refers to '" + constant + "'.");
        }
        if ((type2 = fieldInstruction.getType(this.cpg)) instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier(string2 = ((ObjectType)type2).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(fieldInstruction, "Class '" + string2 + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
    }

    @Override
    public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
    }

    @Override
    public void visitStackInstruction(StackInstruction stackInstruction) {
        this._visitStackAccessor(stackInstruction);
    }

    @Override
    public void visitLocalVariableInstruction(LocalVariableInstruction localVariableInstruction) {
        if (this.locals().maxLocals() <= (localVariableInstruction.getType(this.cpg).getSize() == 1 ? localVariableInstruction.getIndex() : localVariableInstruction.getIndex() + 1)) {
            this.constraintViolated(localVariableInstruction, "The 'index' is not a valid index into the local variable array.");
        }
    }

    @Override
    public void visitLoadInstruction(LoadInstruction loadInstruction) {
        if (this.locals().get(loadInstruction.getIndex()) == Type.UNKNOWN) {
            this.constraintViolated(loadInstruction, "Read-Access on local variable " + loadInstruction.getIndex() + " with unknown content.");
        }
        if (loadInstruction.getType(this.cpg).getSize() == 2 && this.locals().get(loadInstruction.getIndex() + 1) != Type.UNKNOWN) {
            this.constraintViolated(loadInstruction, "Reading a two-locals value from local variables " + loadInstruction.getIndex() + " and " + (loadInstruction.getIndex() + 1) + " where the latter one is destroyed.");
        }
        if (!(loadInstruction instanceof ALOAD)) {
            if (this.locals().get(loadInstruction.getIndex()) != loadInstruction.getType(this.cpg)) {
                this.constraintViolated(loadInstruction, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(loadInstruction.getIndex()) + "'; Instruction type: '" + loadInstruction.getType(this.cpg) + "'.");
            }
        } else if (!(this.locals().get(loadInstruction.getIndex()) instanceof ReferenceType)) {
            this.constraintViolated(loadInstruction, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(loadInstruction.getIndex()) + "'; Instruction expects a ReferenceType.");
        }
        if (this.stack().maxStack() - this.stack().slotsUsed() < loadInstruction.getType(this.cpg).getSize()) {
            this.constraintViolated(loadInstruction, "Not enough free stack slots to load a '" + loadInstruction.getType(this.cpg) + "' onto the OperandStack.");
        }
    }

    @Override
    public void visitStoreInstruction(StoreInstruction storeInstruction) {
        if (this.stack().isEmpty()) {
            this.constraintViolated(storeInstruction, "Cannot STORE: Stack to read from is empty.");
        }
        if (!(storeInstruction instanceof ASTORE)) {
            if (this.stack().peek() != storeInstruction.getType(this.cpg)) {
                this.constraintViolated(storeInstruction, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction type: '" + storeInstruction.getType(this.cpg) + "'.");
            }
        } else {
            Type type2 = this.stack().peek();
            if (!(type2 instanceof ReferenceType) && !(type2 instanceof ReturnaddressType)) {
                this.constraintViolated(storeInstruction, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction expects a ReferenceType or a ReturnadressType.");
            }
            if (type2 instanceof ReferenceType) {
                this.referenceTypeIsInitialized(storeInstruction, (ReferenceType)type2);
            }
        }
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction returnInstruction) {
        if (returnInstruction instanceof RETURN) {
            return;
        }
        if (returnInstruction instanceof ARETURN) {
            if (this.stack().peek() == Type.NULL) {
                return;
            }
            if (!(this.stack().peek() instanceof ReferenceType)) {
                this.constraintViolated(returnInstruction, "Reference type expected on top of stack, but is: '" + this.stack().peek() + "'.");
            }
            this.referenceTypeIsInitialized(returnInstruction, (ReferenceType)this.stack().peek());
        } else {
            Type type2 = this.mg.getType();
            if (type2 == Type.BOOLEAN || type2 == Type.BYTE || type2 == Type.SHORT || type2 == Type.CHAR) {
                type2 = Type.INT;
            }
            if (!type2.equals(this.stack().peek())) {
                this.constraintViolated(returnInstruction, "Current method has return type of '" + this.mg.getType() + "' expecting a '" + type2 + "' on top of the stack. But stack top is a '" + this.stack().peek() + "'.");
            }
        }
    }

    @Override
    public void visitAALOAD(AALOAD aALOAD) {
        Type type2 = this.stack().peek(1);
        Type type3 = this.stack().peek(0);
        this.indexOfInt(aALOAD, type3);
        if (this.arrayrefOfArrayType(aALOAD, type2)) {
            if (!(((ArrayType)type2).getElementType() instanceof ReferenceType)) {
                this.constraintViolated(aALOAD, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)type2).getElementType() + ".");
            }
            this.referenceTypeIsInitialized(aALOAD, (ReferenceType)((ArrayType)type2).getElementType());
        }
    }

    @Override
    public void visitAASTORE(AASTORE aASTORE) {
        Type type2 = this.stack().peek(2);
        Type type3 = this.stack().peek(1);
        Type type4 = this.stack().peek(0);
        this.indexOfInt(aASTORE, type3);
        if (!(type4 instanceof ReferenceType)) {
            this.constraintViolated(aASTORE, "The 'value' is not of a ReferenceType but of type " + type4 + ".");
        } else {
            this.referenceTypeIsInitialized(aASTORE, (ReferenceType)type4);
        }
        if (this.arrayrefOfArrayType(aASTORE, type2)) {
            if (!(((ArrayType)type2).getElementType() instanceof ReferenceType)) {
                this.constraintViolated(aASTORE, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)type2).getElementType() + ".");
            }
            if (!((ReferenceType)type4).isAssignmentCompatibleWith((ReferenceType)((ArrayType)type2).getElementType())) {
                this.constraintViolated(aASTORE, "The type of 'value' ('" + type4 + "') is not assignment compatible to the components of the array 'arrayref' refers to. ('" + ((ArrayType)type2).getElementType() + "')");
            }
        }
    }

    @Override
    public void visitACONST_NULL(ACONST_NULL aCONST_NULL) {
    }

    @Override
    public void visitALOAD(ALOAD aLOAD) {
    }

    @Override
    public void visitANEWARRAY(ANEWARRAY aNEWARRAY) {
        if (!this.stack().peek().equals(Type.INT)) {
            this.constraintViolated(aNEWARRAY, "The 'count' at the stack top is not of type '" + Type.INT + "' but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitARETURN(ARETURN aRETURN) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(aRETURN, "The 'objectref' at the stack top is not of a ReferenceType but of type '" + this.stack().peek() + "'.");
        }
        ReferenceType referenceType = (ReferenceType)this.stack().peek();
        this.referenceTypeIsInitialized(aRETURN, referenceType);
    }

    @Override
    public void visitARRAYLENGTH(ARRAYLENGTH aRRAYLENGTH) {
        Type type2 = this.stack().peek(0);
        this.arrayrefOfArrayType(aRRAYLENGTH, type2);
    }

    @Override
    public void visitASTORE(ASTORE aSTORE) {
        if (!(this.stack().peek() instanceof ReferenceType) && !(this.stack().peek() instanceof ReturnaddressType)) {
            this.constraintViolated(aSTORE, "The 'objectref' is not of a ReferenceType or of ReturnaddressType but of " + this.stack().peek() + ".");
        }
        if (this.stack().peek() instanceof ReferenceType) {
            this.referenceTypeIsInitialized(aSTORE, (ReferenceType)this.stack().peek());
        }
    }

    @Override
    public void visitATHROW(ATHROW aTHROW) {
        ObjectType objectType;
        if (!(this.stack().peek() instanceof ObjectType) && !this.stack().peek().equals(Type.NULL)) {
            this.constraintViolated(aTHROW, "The 'objectref' is not of an (initialized) ObjectType but of type " + this.stack().peek() + ".");
        }
        if (this.stack().peek().equals(Type.NULL)) {
            return;
        }
        ObjectType objectType2 = (ObjectType)this.stack().peek();
        if (!objectType2.subclassOf(objectType = (ObjectType)Type.getType("Ljava/lang/Throwable;")) && !objectType2.equals(objectType)) {
            this.constraintViolated(aTHROW, "The 'objectref' is not of class Throwable or of a subclass of Throwable, but of '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitBALOAD(BALOAD bALOAD) {
        Type type2 = this.stack().peek(1);
        Type type3 = this.stack().peek(0);
        this.indexOfInt(bALOAD, type3);
        if (this.arrayrefOfArrayType(bALOAD, type2) && !((ArrayType)type2).getElementType().equals(Type.BOOLEAN) && !((ArrayType)type2).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(bALOAD, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)type2).getElementType() + "'.");
        }
    }

    @Override
    public void visitBASTORE(BASTORE bASTORE) {
        Type type2 = this.stack().peek(2);
        Type type3 = this.stack().peek(1);
        Type type4 = this.stack().peek(0);
        this.indexOfInt(bASTORE, type3);
        this.valueOfInt(bASTORE, type4);
        if (this.arrayrefOfArrayType(bASTORE, type2) && !((ArrayType)type2).getElementType().equals(Type.BOOLEAN) && !((ArrayType)type2).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(bASTORE, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)type2).getElementType() + "'.");
        }
    }

    @Override
    public void visitBIPUSH(BIPUSH bIPUSH) {
    }

    @Override
    public void visitBREAKPOINT(BREAKPOINT bREAKPOINT) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as BREAKPOINT.");
    }

    @Override
    public void visitCALOAD(CALOAD cALOAD) {
        Type type2 = this.stack().peek(1);
        Type type3 = this.stack().peek(0);
        this.indexOfInt(cALOAD, type3);
        this.arrayrefOfArrayType(cALOAD, type2);
    }

    @Override
    public void visitCASTORE(CASTORE cASTORE) {
        Type type2 = this.stack().peek(2);
        Type type3 = this.stack().peek(1);
        Type type4 = this.stack().peek(0);
        this.indexOfInt(cASTORE, type3);
        this.valueOfInt(cASTORE, type4);
        if (this.arrayrefOfArrayType(cASTORE, type2) && !((ArrayType)type2).getElementType().equals(Type.CHAR)) {
            this.constraintViolated(cASTORE, "The 'arrayref' does not refer to an array with elements of type char but to an array of type " + ((ArrayType)type2).getElementType() + ".");
        }
    }

    @Override
    public void visitCHECKCAST(CHECKCAST cHECKCAST) {
        Type type2 = this.stack().peek(0);
        if (!(type2 instanceof ReferenceType)) {
            this.constraintViolated(cHECKCAST, "The 'objectref' is not of a ReferenceType but of type " + type2 + ".");
        } else {
            this.referenceTypeIsInitialized(cHECKCAST, (ReferenceType)type2);
        }
        Constant constant = this.cpg.getConstant(cHECKCAST.getIndex());
        if (!(constant instanceof ConstantClass)) {
            this.constraintViolated(cHECKCAST, "The Constant at 'index' is not a ConstantClass, but '" + constant + "'.");
        }
    }

    @Override
    public void visitD2F(D2F d2F) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(d2F, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitD2I(D2I d2I) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(d2I, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitD2L(D2L d2L) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(d2L, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDADD(DADD dADD) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dADD, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dADD, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDALOAD(DALOAD dALOAD) {
        Type type2;
        this.indexOfInt(dALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(dALOAD, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(dALOAD, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDASTORE(DASTORE dASTORE) {
        Type type2;
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dASTORE, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(dASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(dASTORE, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(dASTORE, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitDCMPG(DCMPG dCMPG) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dCMPG, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dCMPG, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDCMPL(DCMPL dCMPL) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dCMPL, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dCMPL, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDCONST(DCONST dCONST) {
    }

    @Override
    public void visitDDIV(DDIV dDIV) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dDIV, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dDIV, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDLOAD(DLOAD dLOAD) {
    }

    @Override
    public void visitDMUL(DMUL dMUL) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dMUL, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dMUL, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDNEG(DNEG dNEG) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dNEG, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDREM(DREM dREM) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dREM, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dREM, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDRETURN(DRETURN dRETURN) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dRETURN, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDSTORE(DSTORE dSTORE) {
    }

    @Override
    public void visitDSUB(DSUB dSUB) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dSUB, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dSUB, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDUP(DUP dUP) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(dUP, "Won't DUP type on stack top '" + this.stack().peek() + "' because it must occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitDUP_X1(DUP_X1 dUP_X1) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(dUP_X1, "Type on stack top '" + this.stack().peek() + "' should occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(dUP_X1, "Type on stack next-to-top '" + this.stack().peek(1) + "' should occupy exactly one slot, not '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    @Override
    public void visitDUP_X2(DUP_X2 dUP_X2) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(dUP_X2, "Stack top type must be of size 1, but is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() == 2) {
            return;
        }
        if (this.stack().peek(2).getSize() != 1) {
            this.constraintViolated(dUP_X2, "If stack top's size is 1 and stack next-to-top's size is 1, stack next-to-next-to-top's size must also be 1, but is: '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    @Override
    public void visitDUP2(DUP2 dUP2) {
        if (this.stack().peek().getSize() == 2) {
            return;
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(dUP2, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitDUP2_X1(DUP2_X1 dUP2_X1) {
        if (this.stack().peek().getSize() == 2) {
            if (this.stack().peek(1).getSize() == 1) return;
            this.constraintViolated(dUP2_X1, "If stack top's size is 2, then stack next-to-top's size must be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            return;
        } else {
            if (this.stack().peek(1).getSize() != 1) {
                this.constraintViolated(dUP2_X1, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(dUP2_X1, "If stack top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitDUP2_X2(DUP2_X2 dUP2_X2) {
        if (this.stack().peek(0).getSize() == 2) {
            if (this.stack().peek(1).getSize() == 2) {
                return;
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(dUP2_X2, "If stack top's size is 2 and stack-next-to-top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        } else if (this.stack().peek(1).getSize() == 1) {
            if (this.stack().peek(2).getSize() == 2) {
                return;
            }
            if (this.stack().peek(3).getSize() == 1) {
                return;
            }
        }
        this.constraintViolated(dUP2_X2, "The operand sizes on the stack do not match any of the four forms of usage of this instruction.");
    }

    @Override
    public void visitF2D(F2D f2D) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(f2D, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitF2I(F2I f2I) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(f2I, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitF2L(F2L f2L) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(f2L, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFADD(FADD fADD) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fADD, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fADD, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFALOAD(FALOAD fALOAD) {
        Type type2;
        this.indexOfInt(fALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(fALOAD, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(fALOAD, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFASTORE(FASTORE fASTORE) {
        Type type2;
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fASTORE, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(fASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(fASTORE, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(fASTORE, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitFCMPG(FCMPG fCMPG) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fCMPG, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fCMPG, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFCMPL(FCMPL fCMPL) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fCMPL, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fCMPL, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFCONST(FCONST fCONST) {
    }

    @Override
    public void visitFDIV(FDIV fDIV) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fDIV, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fDIV, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFLOAD(FLOAD fLOAD) {
    }

    @Override
    public void visitFMUL(FMUL fMUL) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fMUL, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fMUL, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFNEG(FNEG fNEG) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fNEG, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFREM(FREM fREM) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fREM, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fREM, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFRETURN(FRETURN fRETURN) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fRETURN, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFSTORE(FSTORE fSTORE) {
    }

    @Override
    public void visitFSUB(FSUB fSUB) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fSUB, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fSUB, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitGETFIELD(GETFIELD gETFIELD) {
        ObjectType objectType;
        ObjectType objectType2;
        Type type2 = this.stack().peek();
        if (!(type2 instanceof ObjectType) && type2 != Type.NULL) {
            this.constraintViolated(gETFIELD, "Stack top should be an object reference that's not an array reference, but is '" + type2 + "'.");
        }
        String string2 = gETFIELD.getFieldName(this.cpg);
        JavaClass javaClass = Repository.lookupClass(gETFIELD.getClassType(this.cpg).getClassName());
        Field[] fieldArray = javaClass.getFields();
        AccessFlags accessFlags = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(string2)) continue;
            accessFlags = fieldArray[i];
            break;
        }
        if (accessFlags == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        if (accessFlags.isProtected() && ((objectType2 = gETFIELD.getClassType(this.cpg)).equals(objectType = new ObjectType(this.mg.getClassName())) || objectType.subclassOf(objectType2))) {
            ObjectType objectType3;
            Type type3 = this.stack().peek();
            if (type3 == Type.NULL) {
                return;
            }
            if (!(type3 instanceof ObjectType)) {
                this.constraintViolated(gETFIELD, "The 'objectref' must refer to an object that's not an array. Found instead: '" + type3 + "'.");
            }
            if ((objectType3 = (ObjectType)type3).equals(objectType) || !objectType3.subclassOf(objectType)) {
                // empty if block
            }
        }
        if (accessFlags.isStatic()) {
            this.constraintViolated(gETFIELD, "Referenced field '" + accessFlags + "' is static which it shouldn't be.");
        }
    }

    @Override
    public void visitGETSTATIC(GETSTATIC gETSTATIC) {
    }

    @Override
    public void visitGOTO(GOTO gOTO) {
    }

    @Override
    public void visitGOTO_W(GOTO_W gOTO_W) {
    }

    @Override
    public void visitI2B(I2B i2B) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2B, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2C(I2C i2C) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2C, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2D(I2D i2D) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2D, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2F(I2F i2F) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2F, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2L(I2L i2L) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2L, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2S(I2S i2S) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2S, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIADD(IADD iADD) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iADD, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iADD, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIALOAD(IALOAD iALOAD) {
        Type type2;
        this.indexOfInt(iALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(iALOAD, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.INT) {
            this.constraintViolated(iALOAD, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIAND(IAND iAND) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iAND, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iAND, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIASTORE(IASTORE iASTORE) {
        Type type2;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iASTORE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(iASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(iASTORE, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.INT) {
            this.constraintViolated(iASTORE, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitICONST(ICONST iCONST) {
    }

    @Override
    public void visitIDIV(IDIV iDIV) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iDIV, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iDIV, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ACMPEQ(IF_ACMPEQ iF_ACMPEQ) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(iF_ACMPEQ, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(iF_ACMPEQ, (ReferenceType)this.stack().peek());
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(iF_ACMPEQ, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
        this.referenceTypeIsInitialized(iF_ACMPEQ, (ReferenceType)this.stack().peek(1));
    }

    @Override
    public void visitIF_ACMPNE(IF_ACMPNE iF_ACMPNE) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(iF_ACMPNE, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
            this.referenceTypeIsInitialized(iF_ACMPNE, (ReferenceType)this.stack().peek());
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(iF_ACMPNE, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
            this.referenceTypeIsInitialized(iF_ACMPNE, (ReferenceType)this.stack().peek(1));
        }
    }

    @Override
    public void visitIF_ICMPEQ(IF_ICMPEQ iF_ICMPEQ) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPEQ, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPEQ, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPGE(IF_ICMPGE iF_ICMPGE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPGE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPGE, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPGT(IF_ICMPGT iF_ICMPGT) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPGT, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPGT, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPLE(IF_ICMPLE iF_ICMPLE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPLE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPLE, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPLT(IF_ICMPLT iF_ICMPLT) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPLT, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPLT, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPNE(IF_ICMPNE iF_ICMPNE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPNE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPNE, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIFEQ(IFEQ iFEQ) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFEQ, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFGE(IFGE iFGE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFGE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFGT(IFGT iFGT) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFGT, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFLE(IFLE iFLE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFLE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFLT(IFLT iFLT) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFLT, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFNE(IFNE iFNE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFNE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFNONNULL(IFNONNULL iFNONNULL) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(iFNONNULL, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(iFNONNULL, (ReferenceType)this.stack().peek());
    }

    @Override
    public void visitIFNULL(IFNULL iFNULL) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(iFNULL, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(iFNULL, (ReferenceType)this.stack().peek());
    }

    @Override
    public void visitIINC(IINC iINC) {
        if (this.locals().maxLocals() <= (iINC.getType(this.cpg).getSize() == 1 ? iINC.getIndex() : iINC.getIndex() + 1)) {
            this.constraintViolated(iINC, "The 'index' is not a valid index into the local variable array.");
        }
        this.indexOfInt(iINC, this.locals().get(iINC.getIndex()));
    }

    @Override
    public void visitILOAD(ILOAD iLOAD) {
    }

    @Override
    public void visitIMPDEP1(IMPDEP1 iMPDEP1) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP1.");
    }

    @Override
    public void visitIMPDEP2(IMPDEP2 iMPDEP2) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP2.");
    }

    @Override
    public void visitIMUL(IMUL iMUL) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iMUL, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iMUL, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitINEG(INEG iNEG) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iNEG, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
        Type type2 = this.stack().peek(0);
        if (!(type2 instanceof ReferenceType)) {
            this.constraintViolated(iNSTANCEOF, "The 'objectref' is not of a ReferenceType but of type " + type2 + ".");
        } else {
            this.referenceTypeIsInitialized(iNSTANCEOF, (ReferenceType)type2);
        }
        Constant constant = this.cpg.getConstant(iNSTANCEOF.getIndex());
        if (!(constant instanceof ConstantClass)) {
            this.constraintViolated(iNSTANCEOF, "The Constant at 'index' is not a ConstantClass, but '" + constant + "'.");
        }
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE iNVOKEINTERFACE) {
        Type[] typeArray;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type2;
        int n2 = iNVOKEINTERFACE.getCount();
        if (n2 == 0) {
            this.constraintViolated(iNVOKEINTERFACE, "The 'count' argument must not be 0.");
        }
        if ((type2 = iNVOKEINTERFACE.getType(this.cpg)) instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier((String)(typeArray = ((ObjectType)type2).getClassName()))).doPass2()).getStatus() != 1) {
            this.constraintViolated(iNVOKEINTERFACE, "Class '" + (String)typeArray + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
        typeArray = iNVOKEINTERFACE.getArgumentTypes(this.cpg);
        int n3 = typeArray.length;
        for (int i = n3 - 1; i >= 0; --i) {
            Type type3 = this.stack().peek(n3 - 1 - i);
            Type type4 = typeArray[i];
            if (type4 == Type.BOOLEAN || type4 == Type.BYTE || type4 == Type.CHAR || type4 == Type.SHORT) {
                type4 = Type.INT;
            }
            if (type3.equals(type4) || type3 instanceof ReferenceType && type4 instanceof ReferenceType) continue;
            this.constraintViolated(iNVOKEINTERFACE, "Expecting a '" + type4 + "' but found a '" + type3 + "' on the stack.");
        }
        Type type5 = this.stack().peek(n3);
        if (type5 == Type.NULL) {
            return;
        }
        if (!(type5 instanceof ReferenceType)) {
            this.constraintViolated(iNVOKEINTERFACE, "Expecting a reference type as 'objectref' on the stack, not a '" + type5 + "'.");
        }
        this.referenceTypeIsInitialized(iNVOKEINTERFACE, (ReferenceType)type5);
        if (!(type5 instanceof ObjectType)) {
            if (!(type5 instanceof ArrayType)) {
                this.constraintViolated(iNVOKEINTERFACE, "Expecting an ObjectType as 'objectref' on the stack, not a '" + type5 + "'.");
            } else {
                type5 = GENERIC_ARRAY;
            }
        }
        int n4 = 1;
        for (int i = 0; i < n3; ++i) {
            n4 += typeArray[i].getSize();
        }
        if (n2 != n4) {
            this.constraintViolated(iNVOKEINTERFACE, "The 'count' argument should probably read '" + n4 + "' but is '" + n2 + "'.");
        }
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL iNVOKESPECIAL) {
        Object object2;
        Object object3;
        Type[] typeArray;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type2;
        if (iNVOKESPECIAL.getMethodName(this.cpg).equals("<init>") && !(this.stack().peek(iNVOKESPECIAL.getArgumentTypes(this.cpg).length) instanceof UninitializedObjectType)) {
            this.constraintViolated(iNVOKESPECIAL, "Possibly initializing object twice. A valid instruction sequence must not have an uninitialized object on the operand stack or in a local variable during a backwards branch, or in a local variable in code protected by an exception handler. Please see The Java Virtual Machine Specification, Second Edition, 4.9.4 (pages 147 and 148) for details.");
        }
        if ((type2 = iNVOKESPECIAL.getType(this.cpg)) instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier((String)(typeArray = ((ObjectType)type2).getClassName()))).doPass2()).getStatus() != 1) {
            this.constraintViolated(iNVOKESPECIAL, "Class '" + (String)typeArray + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
        typeArray = iNVOKESPECIAL.getArgumentTypes(this.cpg);
        int n2 = typeArray.length;
        for (int i = n2 - 1; i >= 0; --i) {
            object3 = this.stack().peek(n2 - 1 - i);
            object2 = typeArray[i];
            if (object2 == Type.BOOLEAN || object2 == Type.BYTE || object2 == Type.CHAR || object2 == Type.SHORT) {
                object2 = Type.INT;
            }
            if (object3.equals(object2)) continue;
            if (object3 instanceof ReferenceType && object2 instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)object3;
                ReferenceType referenceType2 = (ReferenceType)object2;
                if (referenceType.isAssignmentCompatibleWith(referenceType2)) continue;
                this.constraintViolated(iNVOKESPECIAL, "Expecting a '" + object2 + "' but found a '" + object3 + "' on the stack (which is not assignment compatible).");
                continue;
            }
            this.constraintViolated(iNVOKESPECIAL, "Expecting a '" + object2 + "' but found a '" + object3 + "' on the stack.");
        }
        Type type3 = this.stack().peek(n2);
        if (type3 == Type.NULL) {
            return;
        }
        if (!(type3 instanceof ReferenceType)) {
            this.constraintViolated(iNVOKESPECIAL, "Expecting a reference type as 'objectref' on the stack, not a '" + type3 + "'.");
        }
        object3 = null;
        if (!iNVOKESPECIAL.getMethodName(this.cpg).equals("<init>")) {
            this.referenceTypeIsInitialized(iNVOKESPECIAL, (ReferenceType)type3);
            if (!(type3 instanceof ObjectType)) {
                if (!(type3 instanceof ArrayType)) {
                    this.constraintViolated(iNVOKESPECIAL, "Expecting an ObjectType as 'objectref' on the stack, not a '" + type3 + "'.");
                } else {
                    type3 = GENERIC_ARRAY;
                }
            }
            object3 = ((ObjectType)type3).getClassName();
        } else {
            if (!(type3 instanceof UninitializedObjectType)) {
                this.constraintViolated(iNVOKESPECIAL, "Expecting an UninitializedObjectType as 'objectref' on the stack, not a '" + type3 + "'. Otherwise, you couldn't invoke a method since an array has no methods (not to speak of a return address).");
            }
            object3 = ((UninitializedObjectType)type3).getInitialized().getClassName();
        }
        object2 = iNVOKESPECIAL.getClassName(this.cpg);
        if (!Repository.instanceOf((String)object3, (String)object2)) {
            this.constraintViolated(iNVOKESPECIAL, "The 'objref' item '" + type3 + "' does not implement '" + (String)object2 + "' as expected.");
        }
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC iNVOKESTATIC) {
        Type[] typeArray;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type2 = iNVOKESTATIC.getType(this.cpg);
        if (type2 instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier((String)(typeArray = ((ObjectType)type2).getClassName()))).doPass2()).getStatus() != 1) {
            this.constraintViolated(iNVOKESTATIC, "Class '" + (String)typeArray + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
        typeArray = iNVOKESTATIC.getArgumentTypes(this.cpg);
        int n2 = typeArray.length;
        for (int i = n2 - 1; i >= 0; --i) {
            Type type3 = this.stack().peek(n2 - 1 - i);
            Type type4 = typeArray[i];
            if (type4 == Type.BOOLEAN || type4 == Type.BYTE || type4 == Type.CHAR || type4 == Type.SHORT) {
                type4 = Type.INT;
            }
            if (type3.equals(type4)) continue;
            if (type3 instanceof ReferenceType && type4 instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)type3;
                ReferenceType referenceType2 = (ReferenceType)type4;
                if (referenceType.isAssignmentCompatibleWith(referenceType2)) continue;
                this.constraintViolated(iNVOKESTATIC, "Expecting a '" + type4 + "' but found a '" + type3 + "' on the stack (which is not assignment compatible).");
                continue;
            }
            this.constraintViolated(iNVOKESTATIC, "Expecting a '" + type4 + "' but found a '" + type3 + "' on the stack.");
        }
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL iNVOKEVIRTUAL) {
        Object object2;
        Object object3;
        Type[] typeArray;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type2 = iNVOKEVIRTUAL.getType(this.cpg);
        if (type2 instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier((String)(typeArray = ((ObjectType)type2).getClassName()))).doPass2()).getStatus() != 1) {
            this.constraintViolated(iNVOKEVIRTUAL, "Class '" + (String)typeArray + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
        typeArray = iNVOKEVIRTUAL.getArgumentTypes(this.cpg);
        int n2 = typeArray.length;
        for (int i = n2 - 1; i >= 0; --i) {
            object3 = this.stack().peek(n2 - 1 - i);
            object2 = typeArray[i];
            if (object2 == Type.BOOLEAN || object2 == Type.BYTE || object2 == Type.CHAR || object2 == Type.SHORT) {
                object2 = Type.INT;
            }
            if (object3.equals(object2)) continue;
            if (object3 instanceof ReferenceType && object2 instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)object3;
                ReferenceType referenceType2 = (ReferenceType)object2;
                if (referenceType.isAssignmentCompatibleWith(referenceType2)) continue;
                this.constraintViolated(iNVOKEVIRTUAL, "Expecting a '" + object2 + "' but found a '" + object3 + "' on the stack (which is not assignment compatible).");
                continue;
            }
            this.constraintViolated(iNVOKEVIRTUAL, "Expecting a '" + object2 + "' but found a '" + object3 + "' on the stack.");
        }
        Type type3 = this.stack().peek(n2);
        if (type3 == Type.NULL) {
            return;
        }
        if (!(type3 instanceof ReferenceType)) {
            this.constraintViolated(iNVOKEVIRTUAL, "Expecting a reference type as 'objectref' on the stack, not a '" + type3 + "'.");
        }
        this.referenceTypeIsInitialized(iNVOKEVIRTUAL, (ReferenceType)type3);
        if (!(type3 instanceof ObjectType)) {
            if (!(type3 instanceof ArrayType)) {
                this.constraintViolated(iNVOKEVIRTUAL, "Expecting an ObjectType as 'objectref' on the stack, not a '" + type3 + "'.");
            } else {
                type3 = GENERIC_ARRAY;
            }
        }
        if (!Repository.instanceOf((String)(object3 = ((ObjectType)type3).getClassName()), (String)(object2 = iNVOKEVIRTUAL.getClassName(this.cpg)))) {
            this.constraintViolated(iNVOKEVIRTUAL, "The 'objref' item '" + type3 + "' does not implement '" + (String)object2 + "' as expected.");
        }
    }

    @Override
    public void visitIOR(IOR iOR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iOR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iOR, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIREM(IREM iREM) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iREM, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iREM, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIRETURN(IRETURN iRETURN) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iRETURN, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitISHL(ISHL iSHL) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iSHL, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iSHL, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitISHR(ISHR iSHR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iSHR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iSHR, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitISTORE(ISTORE iSTORE) {
    }

    @Override
    public void visitISUB(ISUB iSUB) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iSUB, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iSUB, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIUSHR(IUSHR iUSHR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iUSHR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iUSHR, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIXOR(IXOR iXOR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iXOR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iXOR, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitJSR(JSR jSR) {
    }

    @Override
    public void visitJSR_W(JSR_W jSR_W) {
    }

    @Override
    public void visitL2D(L2D l2D) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(l2D, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitL2F(L2F l2F) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(l2F, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitL2I(L2I l2I) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(l2I, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLADD(LADD lADD) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lADD, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lADD, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLALOAD(LALOAD lALOAD) {
        Type type2;
        this.indexOfInt(lALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(lALOAD, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.LONG) {
            this.constraintViolated(lALOAD, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLAND(LAND lAND) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lAND, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lAND, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLASTORE(LASTORE lASTORE) {
        Type type2;
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lASTORE, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(lASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(lASTORE, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.LONG) {
            this.constraintViolated(lASTORE, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitLCMP(LCMP lCMP) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lCMP, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lCMP, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLCONST(LCONST lCONST) {
    }

    @Override
    public void visitLDC(LDC lDC) {
        Constant constant = this.cpg.getConstant(lDC.getIndex());
        if (!(constant instanceof ConstantInteger || constant instanceof ConstantFloat || constant instanceof ConstantString)) {
            this.constraintViolated(lDC, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + constant + "'.");
        }
    }

    public void visitLDC_W(LDC_W lDC_W) {
        Constant constant = this.cpg.getConstant(lDC_W.getIndex());
        if (!(constant instanceof ConstantInteger || constant instanceof ConstantFloat || constant instanceof ConstantString)) {
            this.constraintViolated(lDC_W, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + constant + "'.");
        }
    }

    @Override
    public void visitLDC2_W(LDC2_W lDC2_W) {
        Constant constant = this.cpg.getConstant(lDC2_W.getIndex());
        if (!(constant instanceof ConstantLong) && !(constant instanceof ConstantDouble)) {
            this.constraintViolated(lDC2_W, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + constant + "'.");
        }
    }

    @Override
    public void visitLDIV(LDIV lDIV) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lDIV, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lDIV, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLLOAD(LLOAD lLOAD) {
    }

    @Override
    public void visitLMUL(LMUL lMUL) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lMUL, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lMUL, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLNEG(LNEG lNEG) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lNEG, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLOOKUPSWITCH(LOOKUPSWITCH lOOKUPSWITCH) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(lOOKUPSWITCH, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLOR(LOR lOR) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lOR, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lOR, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLREM(LREM lREM) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lREM, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lREM, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLRETURN(LRETURN lRETURN) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lRETURN, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLSHL(LSHL lSHL) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(lSHL, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lSHL, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLSHR(LSHR lSHR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(lSHR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lSHR, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLSTORE(LSTORE lSTORE) {
    }

    @Override
    public void visitLSUB(LSUB lSUB) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lSUB, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lSUB, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLUSHR(LUSHR lUSHR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(lUSHR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lUSHR, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLXOR(LXOR lXOR) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lXOR, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lXOR, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitMONITORENTER(MONITORENTER mONITORENTER) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(mONITORENTER, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(mONITORENTER, (ReferenceType)this.stack().peek());
    }

    @Override
    public void visitMONITOREXIT(MONITOREXIT mONITOREXIT) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(mONITOREXIT, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(mONITOREXIT, (ReferenceType)this.stack().peek());
    }

    @Override
    public void visitMULTIANEWARRAY(MULTIANEWARRAY mULTIANEWARRAY) {
        int n2 = mULTIANEWARRAY.getDimensions();
        for (int i = 0; i < n2; ++i) {
            if (this.stack().peek(i) == Type.INT) continue;
            this.constraintViolated(mULTIANEWARRAY, "The '" + n2 + "' upper stack types should be 'int' but aren't.");
        }
    }

    @Override
    public void visitNEW(NEW nEW) {
        ObjectType objectType;
        Type type2 = nEW.getType(this.cpg);
        if (!(type2 instanceof ReferenceType)) {
            throw new AssertionViolatedException("NEW.getType() returning a non-reference type?!");
        }
        if (!(type2 instanceof ObjectType)) {
            this.constraintViolated(nEW, "Expecting a class type (ObjectType) to work on. Found: '" + type2 + "'.");
        }
        if (!(objectType = (ObjectType)type2).referencesClass()) {
            this.constraintViolated(nEW, "Expecting a class type (ObjectType) to work on. Found: '" + objectType + "'.");
        }
    }

    @Override
    public void visitNEWARRAY(NEWARRAY nEWARRAY) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(nEWARRAY, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitNOP(NOP nOP) {
    }

    @Override
    public void visitPOP(POP pOP) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(pOP, "Stack top size should be 1 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitPOP2(POP2 pOP2) {
        if (this.stack().peek().getSize() != 2) {
            this.constraintViolated(pOP2, "Stack top size should be 2 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitPUTFIELD(PUTFIELD pUTFIELD) {
        ObjectType objectType;
        ReferenceType referenceType;
        Type type2 = this.stack().peek(1);
        if (!(type2 instanceof ObjectType) && type2 != Type.NULL) {
            this.constraintViolated(pUTFIELD, "Stack next-to-top should be an object reference that's not an array reference, but is '" + type2 + "'.");
        }
        String string2 = pUTFIELD.getFieldName(this.cpg);
        JavaClass javaClass = Repository.lookupClass(pUTFIELD.getClassType(this.cpg).getClassName());
        Field[] fieldArray = javaClass.getFields();
        FieldOrMethod fieldOrMethod = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(string2)) continue;
            fieldOrMethod = fieldArray[i];
            break;
        }
        if (fieldOrMethod == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        Type type3 = this.stack().peek();
        Type type4 = Type.getType(fieldOrMethod.getSignature());
        Type type5 = type4;
        if (type5 == Type.BOOLEAN || type5 == Type.BYTE || type5 == Type.CHAR || type5 == Type.SHORT) {
            type5 = Type.INT;
        }
        if (type4 instanceof ReferenceType) {
            referenceType = null;
            if (type3 instanceof ReferenceType) {
                referenceType = (ReferenceType)type3;
                this.referenceTypeIsInitialized(pUTFIELD, referenceType);
            } else {
                this.constraintViolated(pUTFIELD, "The stack top type '" + type3 + "' is not of a reference type as expected.");
            }
            if (!referenceType.isAssignmentCompatibleWith(type5)) {
                this.constraintViolated(pUTFIELD, "The stack top type '" + type3 + "' is not assignment compatible with '" + type5 + "'.");
            }
        } else if (type5 != type3) {
            this.constraintViolated(pUTFIELD, "The stack top type '" + type3 + "' is not of type '" + type5 + "' as expected.");
        }
        if (fieldOrMethod.isProtected() && (((ObjectType)(referenceType = pUTFIELD.getClassType(this.cpg))).equals(objectType = new ObjectType(this.mg.getClassName())) || objectType.subclassOf((ObjectType)referenceType))) {
            ObjectType objectType2;
            Type type6 = this.stack().peek(1);
            if (type6 == Type.NULL) {
                return;
            }
            if (!(type6 instanceof ObjectType)) {
                this.constraintViolated(pUTFIELD, "The 'objectref' must refer to an object that's not an array. Found instead: '" + type6 + "'.");
            }
            if (!(objectType2 = (ObjectType)type6).equals(objectType) && !objectType2.subclassOf(objectType)) {
                this.constraintViolated(pUTFIELD, "The referenced field has the ACC_PROTECTED modifier, and it's a member of the current class or a superclass of the current class. However, the referenced object type '" + this.stack().peek() + "' is not the current class or a subclass of the current class.");
            }
        }
        if (fieldOrMethod.isStatic()) {
            this.constraintViolated(pUTFIELD, "Referenced field '" + fieldOrMethod + "' is static which it shouldn't be.");
        }
    }

    @Override
    public void visitPUTSTATIC(PUTSTATIC pUTSTATIC) {
        String string2 = pUTSTATIC.getFieldName(this.cpg);
        JavaClass javaClass = Repository.lookupClass(pUTSTATIC.getClassType(this.cpg).getClassName());
        Field[] fieldArray = javaClass.getFields();
        FieldOrMethod fieldOrMethod = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(string2)) continue;
            fieldOrMethod = fieldArray[i];
            break;
        }
        if (fieldOrMethod == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        Type type2 = this.stack().peek();
        Type type3 = Type.getType(fieldOrMethod.getSignature());
        Type type4 = type3;
        if (type4 == Type.BOOLEAN || type4 == Type.BYTE || type4 == Type.CHAR || type4 == Type.SHORT) {
            type4 = Type.INT;
        }
        if (type3 instanceof ReferenceType) {
            ReferenceType referenceType = null;
            if (type2 instanceof ReferenceType) {
                referenceType = (ReferenceType)type2;
                this.referenceTypeIsInitialized(pUTSTATIC, referenceType);
            } else {
                this.constraintViolated(pUTSTATIC, "The stack top type '" + type2 + "' is not of a reference type as expected.");
            }
            if (!referenceType.isAssignmentCompatibleWith(type4)) {
                this.constraintViolated(pUTSTATIC, "The stack top type '" + type2 + "' is not assignment compatible with '" + type4 + "'.");
            }
        } else if (type4 != type2) {
            this.constraintViolated(pUTSTATIC, "The stack top type '" + type2 + "' is not of type '" + type4 + "' as expected.");
        }
    }

    @Override
    public void visitRET(RET rET) {
        if (!(this.locals().get(rET.getIndex()) instanceof ReturnaddressType)) {
            this.constraintViolated(rET, "Expecting a ReturnaddressType in local variable " + rET.getIndex() + ".");
        }
        if (this.locals().get(rET.getIndex()) == ReturnaddressType.NO_TARGET) {
            throw new AssertionViolatedException("Oops: RET expecting a target!");
        }
    }

    @Override
    public void visitRETURN(RETURN rETURN) {
        if (this.mg.getName().equals("<init>")) {
            if (Frame._this != null && !this.mg.getClassName().equals(Type.OBJECT.getClassName())) {
                this.constraintViolated(rETURN, "Leaving a constructor that itself did not call a constructor.");
            }
        }
    }

    @Override
    public void visitSALOAD(SALOAD sALOAD) {
        Type type2;
        this.indexOfInt(sALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(sALOAD, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(sALOAD, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitSASTORE(SASTORE sASTORE) {
        Type type2;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(sASTORE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(sASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(sASTORE, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(sASTORE, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitSIPUSH(SIPUSH sIPUSH) {
    }

    @Override
    public void visitSWAP(SWAP sWAP) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(sWAP, "The value at the stack top is not of size '1', but of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(sWAP, "The value at the stack next-to-top is not of size '1', but of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    @Override
    public void visitTABLESWITCH(TABLESWITCH tABLESWITCH) {
        this.indexOfInt(tABLESWITCH, this.stack().peek());
    }
}

