/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics;

import com.ibm.xltxe.rnm1.xtq.bcel.Repository;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.AccessFlags;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.CodeException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInterfaceMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantLong;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Field;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.FieldOrMethod;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumber;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ATHROW;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BREAKPOINT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CHECKCAST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.EmptyVisitor;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GETSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GotoInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ILOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IMPDEP1;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IMPDEP2;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INSTANCEOF;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEINTERFACE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ISTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InvokeInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JsrInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC2_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LOOKUPSWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LoadClass;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MULTIANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEW;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUTSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TABLESWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.PassVerifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerificationResult;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.Verifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerifierFactory;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.ClassConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.InvalidMethodException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StaticCodeConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StaticCodeInstructionConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StaticCodeInstructionOperandConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics.IntList;
import java.io.Serializable;

public final class Pass3aVerifier
extends PassVerifier {
    private Verifier myOwner;
    private int method_no;
    InstructionList instructionList;
    Code code;

    public Pass3aVerifier(Verifier verifier, int n2) {
        this.myOwner = verifier;
        this.method_no = n2;
    }

    @Override
    public VerificationResult do_verify() {
        if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
            JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
            Method[] methodArray = javaClass.getMethods();
            if (this.method_no >= methodArray.length) {
                throw new InvalidMethodException("METHOD DOES NOT EXIST!");
            }
            Method method = methodArray[this.method_no];
            this.code = method.getCode();
            if (method.isAbstract() || method.isNative()) {
                return VerificationResult.VR_OK;
            }
            try {
                this.instructionList = new InstructionList(method.getCode().getCode());
            }
            catch (RuntimeException runtimeException) {
                return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
            }
            this.instructionList.setPositions(true);
            VerificationResult verificationResult = VerificationResult.VR_OK;
            try {
                this.delayedPass2Checks();
            }
            catch (ClassConstraintException classConstraintException) {
                verificationResult = new VerificationResult(2, classConstraintException.getMessage());
                return verificationResult;
            }
            try {
                this.pass3StaticInstructionChecks();
                this.pass3StaticInstructionOperandsChecks();
            }
            catch (StaticCodeConstraintException staticCodeConstraintException) {
                verificationResult = new VerificationResult(2, staticCodeConstraintException.getMessage());
            }
            return verificationResult;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void delayedPass2Checks() {
        int n2;
        int n3;
        int n4;
        Cloneable[] cloneableArray;
        int[] nArray = this.instructionList.getInstructionPositions();
        int n5 = this.code.getCode().length;
        LineNumberTable lineNumberTable = this.code.getLineNumberTable();
        if (lineNumberTable != null) {
            cloneableArray = lineNumberTable.getLineNumberTable();
            IntList intList = new IntList();
            block0: for (n4 = 0; n4 < cloneableArray.length; ++n4) {
                for (int i = 0; i < nArray.length; ++i) {
                    n3 = ((LineNumber)cloneableArray[n4]).getStartPC();
                    if (nArray[i] != n3) continue;
                    if (intList.contains(n3)) {
                        this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + n3 + "') more than once which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                        continue block0;
                    }
                    intList.add(n3);
                    continue block0;
                }
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + ((LineNumber)cloneableArray[n4]).getStartPC() + "') that does not exist.");
            }
        }
        cloneableArray = this.code.getAttributes();
        for (int i = 0; i < cloneableArray.length; ++i) {
            LocalVariableTable localVariableTable;
            if (!(cloneableArray[i] instanceof LocalVariableTable) || (localVariableTable = (LocalVariableTable)cloneableArray[i]) == null) continue;
            LocalVariable[] localVariableArray = localVariableTable.getLocalVariableTable();
            for (n3 = 0; n3 < localVariableArray.length; ++n3) {
                n2 = localVariableArray[n3].getStartPC();
                int n6 = localVariableArray[n3].getLength();
                if (!Pass3aVerifier.contains(nArray, n2)) {
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + n2 + "') that does not exist.");
                }
                if (Pass3aVerifier.contains(nArray, n2 + n6) || n2 + n6 == n5) continue;
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (n2 + n6) + "') that does not exist.");
            }
        }
        CodeException[] codeExceptionArray = this.code.getExceptionTable();
        for (n4 = 0; n4 < codeExceptionArray.length; ++n4) {
            int n7 = codeExceptionArray[n4].getStartPC();
            n3 = codeExceptionArray[n4].getEndPC();
            n2 = codeExceptionArray[n4].getHandlerPC();
            if (n7 >= n3) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n4] + "' that has its start_pc ('" + n7 + "') not smaller than its end_pc ('" + n3 + "').");
            }
            if (!Pass3aVerifier.contains(nArray, n7)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n4] + "' that has a non-existant bytecode offset as its start_pc ('" + n7 + "').");
            }
            if (!Pass3aVerifier.contains(nArray, n3) && n3 != n5) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n4] + "' that has a non-existant bytecode offset as its end_pc ('" + n7 + "') [that is also not equal to code_length ('" + n5 + "')].");
            }
            if (Pass3aVerifier.contains(nArray, n2)) continue;
            throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n4] + "' that has a non-existant bytecode offset as its handler_pc ('" + n2 + "').");
        }
    }

    private void pass3StaticInstructionChecks() {
        Instruction instruction2;
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than 65536 bytes.");
        }
        for (InstructionHandle instructionHandle = this.instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction2 = instructionHandle.getInstruction();
            if (instruction2 instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (instruction2 instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (!(instruction2 instanceof BREAKPOINT)) continue;
            throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
        }
        instruction2 = this.instructionList.getEnd().getInstruction();
        if (!(instruction2 instanceof ReturnInstruction || instruction2 instanceof RET || instruction2 instanceof GotoInstruction || instruction2 instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
        InstOperandConstraintVisitor instOperandConstraintVisitor = new InstOperandConstraintVisitor(constantPoolGen);
        for (InstructionHandle instructionHandle = this.instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            Instruction instruction2 = instructionHandle.getInstruction();
            if (instruction2 instanceof JsrInstruction) {
                InstructionHandle instructionHandle2 = ((JsrInstruction)instruction2).getTarget();
                if (instructionHandle2 == this.instructionList.getStart()) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + instructionHandle + "' as its target.");
                }
                if (!(instructionHandle2.getInstruction() instanceof ASTORE)) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + instructionHandle + "' targets '" + instructionHandle2 + "'.");
                }
            }
            instructionHandle.accept(instOperandConstraintVisitor);
        }
    }

    private static boolean contains(int[] nArray, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n2) continue;
            return true;
        }
        return false;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private ConstantPoolGen cpg;

        InstOperandConstraintVisitor(ConstantPoolGen constantPoolGen) {
            this.cpg = constantPoolGen;
        }

        private int max_locals() {
            return Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getCode().getMaxLocals();
        }

        private void constraintViolated(Instruction instruction2, String string2) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + instruction2 + " constraint violated: " + string2);
        }

        private void indexValid(Instruction instruction2, int n2) {
            if (n2 < 0 || n2 >= this.cpg.getSize()) {
                this.constraintViolated(instruction2, "Illegal constant pool index '" + n2 + "'.");
            }
        }

        @Override
        public void visitLoadClass(LoadClass loadClass) {
            Verifier verifier;
            VerificationResult verificationResult;
            ObjectType objectType = loadClass.getLoadClassType(this.cpg);
            if (objectType != null && (verificationResult = (verifier = VerifierFactory.getVerifier(objectType.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)loadClass), "Class '" + loadClass.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded: '" + verificationResult + "'.");
            }
        }

        @Override
        public void visitLDC(LDC lDC) {
            this.indexValid(lDC, lDC.getIndex());
            Constant constant = this.cpg.getConstant(lDC.getIndex());
            if (!(constant instanceof ConstantInteger || constant instanceof ConstantFloat || constant instanceof ConstantString)) {
                this.constraintViolated(lDC, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + constant + "'.");
            }
        }

        @Override
        public void visitLDC2_W(LDC2_W lDC2_W) {
            this.indexValid(lDC2_W, lDC2_W.getIndex());
            Constant constant = this.cpg.getConstant(lDC2_W.getIndex());
            if (!(constant instanceof ConstantLong) && !(constant instanceof ConstantDouble)) {
                this.constraintViolated(lDC2_W, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + constant + "'.");
            }
            try {
                this.indexValid(lDC2_W, lDC2_W.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException staticCodeInstructionOperandConstraintException) {
                throw new AssertionViolatedException("OOPS: Does not BCEL handle that? LDC2_W operand has a problem.");
            }
        }

        @Override
        public void visitFieldInstruction(FieldInstruction fieldInstruction) {
            this.indexValid(fieldInstruction, fieldInstruction.getIndex());
            Constant constant = this.cpg.getConstant(fieldInstruction.getIndex());
            if (!(constant instanceof ConstantFieldref)) {
                this.constraintViolated(fieldInstruction, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + constant + "'.");
            }
            String string2 = fieldInstruction.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(fieldInstruction.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            FieldOrMethod fieldOrMethod = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equals(string2)) continue;
                fieldOrMethod = fieldArray[i];
                break;
            }
            if (fieldOrMethod == null) {
                this.constraintViolated(fieldInstruction, "Referenced field '" + string2 + "' does not exist in class '" + javaClass.getClassName() + "'.");
            } else {
                Type type2;
                Type type3 = Type.getType(fieldOrMethod.getSignature());
                if (!type3.equals(type2 = fieldInstruction.getType(this.cpg))) {
                    this.constraintViolated(fieldInstruction, "Referenced field '" + string2 + "' has type '" + type3 + "' instead of '" + type2 + "' as expected.");
                }
            }
        }

        @Override
        public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
            Object object2;
            Object object3;
            Serializable serializable;
            this.indexValid(invokeInstruction, invokeInstruction.getIndex());
            if (invokeInstruction instanceof INVOKEVIRTUAL || invokeInstruction instanceof INVOKESPECIAL || invokeInstruction instanceof INVOKESTATIC) {
                serializable = this.cpg.getConstant(invokeInstruction.getIndex());
                if (!(serializable instanceof ConstantMethodref)) {
                    this.constraintViolated(invokeInstruction, "Indexing a constant that's not a CONSTANT_Methodref but a '" + serializable + "'.");
                } else {
                    object3 = (ConstantNameAndType)this.cpg.getConstant(((ConstantMethodref)serializable).getNameAndTypeIndex());
                    object2 = (ConstantUtf8)this.cpg.getConstant(object3.getNameIndex());
                    if (((ConstantUtf8)object2).getBytes().equals("<init>") && !(invokeInstruction instanceof INVOKESPECIAL)) {
                        this.constraintViolated(invokeInstruction, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!((ConstantUtf8)object2).getBytes().equals("<init>") && ((ConstantUtf8)object2).getBytes().startsWith("<")) {
                        this.constraintViolated(invokeInstruction, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                serializable = this.cpg.getConstant(invokeInstruction.getIndex());
                if (!(serializable instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(invokeInstruction, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + serializable + "'.");
                }
                if (((String)(object2 = ((ConstantUtf8)this.cpg.getConstant((object3 = (ConstantNameAndType)this.cpg.getConstant(((ConstantInterfaceMethodref)serializable).getNameAndTypeIndex())).getNameIndex())).getBytes())).equals("<init>")) {
                    this.constraintViolated(invokeInstruction, "Method to invoke must not be '<init>'.");
                }
                if (((String)object2).equals("<clinit>")) {
                    this.constraintViolated(invokeInstruction, "Method to invoke must not be '<clinit>'.");
                }
            }
            serializable = invokeInstruction.getReturnType(this.cpg);
            if (serializable instanceof ArrayType) {
                serializable = ((ArrayType)serializable).getBasicType();
            }
            if (serializable instanceof ObjectType && ((VerificationResult)(object2 = (object3 = VerifierFactory.getVerifier(((ObjectType)serializable).getClassName())).doPass2())).getStatus() != 1) {
                this.constraintViolated(invokeInstruction, "Return type class/interface could not be verified successfully: '" + ((VerificationResult)object2).getMessage() + "'.");
            }
            object3 = invokeInstruction.getArgumentTypes(this.cpg);
            for (int i = 0; i < ((Type[])object3).length; ++i) {
                Verifier verifier;
                VerificationResult verificationResult;
                serializable = object3[i];
                if (serializable instanceof ArrayType) {
                    serializable = ((ArrayType)serializable).getBasicType();
                }
                if (!(serializable instanceof ObjectType) || (verificationResult = (verifier = VerifierFactory.getVerifier(((ObjectType)serializable).getClassName())).doPass2()).getStatus() == 1) continue;
                this.constraintViolated(invokeInstruction, "Argument type class/interface could not be verified successfully: '" + verificationResult.getMessage() + "'.");
            }
        }

        @Override
        public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
            this.indexValid(iNSTANCEOF, iNSTANCEOF.getIndex());
            Constant constant = this.cpg.getConstant(iNSTANCEOF.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(iNSTANCEOF, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
        }

        @Override
        public void visitCHECKCAST(CHECKCAST cHECKCAST) {
            this.indexValid(cHECKCAST, cHECKCAST.getIndex());
            Constant constant = this.cpg.getConstant(cHECKCAST.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(cHECKCAST, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
        }

        @Override
        public void visitNEW(NEW nEW) {
            this.indexValid(nEW, nEW.getIndex());
            Constant constant = this.cpg.getConstant(nEW.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(nEW, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            } else {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpg.getConstant(((ConstantClass)constant).getNameIndex());
                Type type2 = Type.getType("L" + constantUtf8.getBytes() + ";");
                if (type2 instanceof ArrayType) {
                    this.constraintViolated(nEW, "NEW must not be used to create an array.");
                }
            }
        }

        @Override
        public void visitMULTIANEWARRAY(MULTIANEWARRAY mULTIANEWARRAY) {
            Type type2;
            short s;
            this.indexValid(mULTIANEWARRAY, mULTIANEWARRAY.getIndex());
            Constant constant = this.cpg.getConstant(mULTIANEWARRAY.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(mULTIANEWARRAY, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
            if ((s = mULTIANEWARRAY.getDimensions()) < 1) {
                this.constraintViolated(mULTIANEWARRAY, "Number of dimensions to create must be greater than zero.");
            }
            if ((type2 = mULTIANEWARRAY.getType(this.cpg)) instanceof ArrayType) {
                int n2 = ((ArrayType)type2).getDimensions();
                if (n2 < s) {
                    this.constraintViolated(mULTIANEWARRAY, "Not allowed to create array with more dimensions ('+dimensions2create+') than the one referenced by the CONSTANT_Class '" + type2 + "'.");
                }
            } else {
                this.constraintViolated(mULTIANEWARRAY, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        @Override
        public void visitANEWARRAY(ANEWARRAY aNEWARRAY) {
            int n2;
            Type type2;
            this.indexValid(aNEWARRAY, aNEWARRAY.getIndex());
            Constant constant = this.cpg.getConstant(aNEWARRAY.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(aNEWARRAY, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
            if ((type2 = aNEWARRAY.getType(this.cpg)) instanceof ArrayType && (n2 = ((ArrayType)type2).getDimensions()) >= 255) {
                this.constraintViolated(aNEWARRAY, "Not allowed to create an array with more than 255 dimensions.");
            }
        }

        @Override
        public void visitNEWARRAY(NEWARRAY nEWARRAY) {
            byte by2 = nEWARRAY.getTypecode();
            if (by2 != 4 && by2 != 5 && by2 != 6 && by2 != 7 && by2 != 8 && by2 != 9 && by2 != 10 && by2 != 11) {
                this.constraintViolated(nEWARRAY, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        @Override
        public void visitILOAD(ILOAD iLOAD) {
            int n2 = iLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitFLOAD(FLOAD fLOAD) {
            int n2 = fLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(fLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(fLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitALOAD(ALOAD aLOAD) {
            int n2 = aLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(aLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(aLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitISTORE(ISTORE iSTORE) {
            int n2 = iSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitFSTORE(FSTORE fSTORE) {
            int n2 = fSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(fSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(fSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitASTORE(ASTORE aSTORE) {
            int n2 = aSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(aSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(aSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitIINC(IINC iINC) {
            int n2 = iINC.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iINC, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iINC, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitRET(RET rET) {
            int n2 = rET.getIndex();
            if (n2 < 0) {
                this.constraintViolated(rET, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(rET, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitLLOAD(LLOAD lLOAD) {
            int n2 = lLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(lLOAD, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(lLOAD, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitDLOAD(DLOAD dLOAD) {
            int n2 = dLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(dLOAD, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(dLOAD, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitLSTORE(LSTORE lSTORE) {
            int n2 = lSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(lSTORE, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(lSTORE, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitDSTORE(DSTORE dSTORE) {
            int n2 = dSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(dSTORE, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(dSTORE, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        @Override
        public void visitLOOKUPSWITCH(LOOKUPSWITCH lOOKUPSWITCH) {
            int[] nArray = lOOKUPSWITCH.getMatchs();
            int n2 = Integer.MIN_VALUE;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == n2 && i != 0) {
                    this.constraintViolated(lOOKUPSWITCH, "Match '" + nArray[i] + "' occurs more than once.");
                }
                if (nArray[i] < n2) {
                    this.constraintViolated(lOOKUPSWITCH, "Lookup table must be sorted but isn't.");
                    continue;
                }
                n2 = nArray[i];
            }
        }

        @Override
        public void visitTABLESWITCH(TABLESWITCH tABLESWITCH) {
        }

        @Override
        public void visitPUTSTATIC(PUTSTATIC pUTSTATIC) {
            String string2 = pUTSTATIC.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(pUTSTATIC.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            AccessFlags accessFlags = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equals(string2)) continue;
                accessFlags = fieldArray[i];
                break;
            }
            if (accessFlags == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (accessFlags.isFinal() && !Pass3aVerifier.this.myOwner.getClassName().equals(pUTSTATIC.getClassType(this.cpg).getClassName())) {
                this.constraintViolated(pUTSTATIC, "Referenced field '" + accessFlags + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.this.myOwner.getClassName() + "' which is not the case: it is declared in '" + pUTSTATIC.getClassType(this.cpg).getClassName() + "'.");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(pUTSTATIC, "Referenced field '" + accessFlags + "' is not static which it should be.");
            }
            String string3 = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getName();
            if (!javaClass.isClass() && !string3.equals("<clinit>")) {
                this.constraintViolated(pUTSTATIC, "Interface field '" + accessFlags + "' must be set in a '" + "<clinit>" + "' method.");
            }
        }

        @Override
        public void visitGETSTATIC(GETSTATIC gETSTATIC) {
            String string2 = gETSTATIC.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(gETSTATIC.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            AccessFlags accessFlags = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equals(string2)) continue;
                accessFlags = fieldArray[i];
                break;
            }
            if (accessFlags == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(gETSTATIC, "Referenced field '" + accessFlags + "' is not static which it should be.");
            }
        }

        @Override
        public void visitINVOKEINTERFACE(INVOKEINTERFACE iNVOKEINTERFACE) {
            String string2 = iNVOKEINTERFACE.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string2);
            Method[] methodArray = javaClass.getMethods();
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(iNVOKEINTERFACE.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i].getSignature()).equals(iNVOKEINTERFACE.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i].getSignature()), iNVOKEINTERFACE.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKEINTERFACE, "Referenced method '" + iNVOKEINTERFACE.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verfier does allow the method to be declared in some superinterface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (javaClass.isClass()) {
                this.constraintViolated(iNVOKEINTERFACE, "Referenced class '" + javaClass.getClassName() + "' is a class, but not an interface as expected.");
            }
        }

        @Override
        public void visitINVOKESPECIAL(INVOKESPECIAL iNVOKESPECIAL) {
            JavaClass javaClass;
            String string2 = iNVOKESPECIAL.getClassName(this.cpg);
            JavaClass javaClass2 = Repository.lookupClass(string2);
            Method[] methodArray = javaClass2.getMethods();
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(iNVOKESPECIAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i].getSignature()).equals(iNVOKESPECIAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i].getSignature()), iNVOKESPECIAL.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKESPECIAL, "Referenced method '" + iNVOKESPECIAL.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass2.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if ((javaClass = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName())).isSuper() && Repository.instanceOf(javaClass, javaClass2) && !javaClass.equals(javaClass2) && !iNVOKESPECIAL.getMethodName(this.cpg).equals("<init>")) {
                int n2 = -1;
                Method method2 = null;
                while (n2 != 0) {
                    n2 = javaClass.getSuperclassNameIndex();
                    javaClass = Repository.lookupClass(javaClass.getSuperclassName());
                    Method[] methodArray2 = javaClass.getMethods();
                    for (int i = 0; i < methodArray2.length; ++i) {
                        if (!methodArray2[i].getName().equals(iNVOKESPECIAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray2[i].getSignature()).equals(iNVOKESPECIAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray2[i].getSignature()), iNVOKESPECIAL.getArgumentTypes(this.cpg))) continue;
                        method2 = methodArray2[i];
                        break;
                    }
                    if (method2 == null) continue;
                    break;
                }
                if (method2 == null) {
                    this.constraintViolated(iNVOKESPECIAL, "ACC_SUPER special lookup procedure not successful: method '" + iNVOKESPECIAL.getMethodName(this.cpg) + "' with proper signature not declared in superclass hierarchy.");
                }
            }
        }

        @Override
        public void visitINVOKESTATIC(INVOKESTATIC iNVOKESTATIC) {
            String string2 = iNVOKESTATIC.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string2);
            Method[] methodArray = javaClass.getMethods();
            AccessFlags accessFlags = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(iNVOKESTATIC.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i].getSignature()).equals(iNVOKESTATIC.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i].getSignature()), iNVOKESTATIC.getArgumentTypes(this.cpg))) continue;
                accessFlags = methodArray[i];
                break;
            }
            if (accessFlags == null) {
                this.constraintViolated(iNVOKESTATIC, "Referenced method '" + iNVOKESTATIC.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verifier possibly allows the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(iNVOKESTATIC, "Referenced method '" + iNVOKESTATIC.getMethodName(this.cpg) + "' has ACC_STATIC unset.");
            }
        }

        @Override
        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL iNVOKEVIRTUAL) {
            String string2 = iNVOKEVIRTUAL.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string2);
            Method[] methodArray = javaClass.getMethods();
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(iNVOKEVIRTUAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i].getSignature()).equals(iNVOKEVIRTUAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i].getSignature()), iNVOKEVIRTUAL.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKEVIRTUAL, "Referenced method '" + iNVOKEVIRTUAL.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!javaClass.isClass()) {
                this.constraintViolated(iNVOKEVIRTUAL, "Referenced class '" + javaClass.getClassName() + "' is an interface, but not a class as expected.");
            }
        }

        private boolean objarrayequals(Object[] objectArray, Object[] objectArray2) {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].equals(objectArray2[i])) continue;
                return false;
            }
            return true;
        }
    }
}

