/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics;

import com.ibm.xltxe.rnm1.xtq.bcel.Repository;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.PassVerifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerificationResult;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.Verifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.LoadingException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.Utility;

public final class Pass1Verifier
extends PassVerifier {
    private JavaClass jc;
    private Verifier myOwner;

    private JavaClass getJavaClass() {
        if (this.jc == null) {
            this.jc = Repository.lookupClass(this.myOwner.getClassName());
        }
        return this.jc;
    }

    public Pass1Verifier(Verifier verifier) {
        this.myOwner = verifier;
    }

    @Override
    public VerificationResult do_verify() {
        JavaClass javaClass;
        try {
            javaClass = this.getJavaClass();
            if (javaClass != null && !this.myOwner.getClassName().equals(javaClass.getClassName())) {
                throw new LoadingException("Wrong name: the internal name of the .class file '" + javaClass.getClassName() + "' does not match the file's name '" + this.myOwner.getClassName() + "'.");
            }
        }
        catch (LoadingException loadingException) {
            return new VerificationResult(2, loadingException.getMessage());
        }
        catch (ClassFormatError classFormatError) {
            return new VerificationResult(2, classFormatError.getMessage());
        }
        catch (RuntimeException runtimeException) {
            return new VerificationResult(2, "Parsing via BCEL did not succeed. " + runtimeException.getClass().getName() + " occured:\n" + Utility.getStackTrace(runtimeException));
        }
        if (javaClass != null) {
            return VerificationResult.VR_OK;
        }
        return new VerificationResult(2, "Repository.lookup() failed. FILE NOT FOUND?");
    }

    @Override
    public String[] getMessages() {
        return super.getMessages();
    }
}

