/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier;

import com.ibm.xltxe.rnm1.xtq.bcel.Repository;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.PassVerifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerificationResult;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerifierFactory;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics.Pass1Verifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics.Pass2Verifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics.Pass3aVerifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.Pass3bVerifier;
import java.util.ArrayList;
import java.util.HashMap;

public class Verifier {
    private final String classname;
    private Pass1Verifier p1v;
    private Pass2Verifier p2v;
    private HashMap p3avs = new HashMap();
    private HashMap p3bvs = new HashMap();

    public VerificationResult doPass1() {
        if (this.p1v == null) {
            this.p1v = new Pass1Verifier(this);
        }
        return this.p1v.verify();
    }

    public VerificationResult doPass2() {
        if (this.p2v == null) {
            this.p2v = new Pass2Verifier(this);
        }
        return this.p2v.verify();
    }

    public VerificationResult doPass3a(int n2) {
        String string2 = Integer.toString(n2);
        Pass3aVerifier pass3aVerifier = (Pass3aVerifier)this.p3avs.get(string2);
        if (this.p3avs.get(string2) == null) {
            pass3aVerifier = new Pass3aVerifier(this, n2);
            this.p3avs.put(string2, pass3aVerifier);
        }
        return pass3aVerifier.verify();
    }

    public VerificationResult doPass3b(int n2) {
        String string2 = Integer.toString(n2);
        Pass3bVerifier pass3bVerifier = (Pass3bVerifier)this.p3bvs.get(string2);
        if (this.p3bvs.get(string2) == null) {
            pass3bVerifier = new Pass3bVerifier(this, n2);
            this.p3bvs.put(string2, pass3bVerifier);
        }
        return pass3bVerifier.verify();
    }

    Verifier(String string2) {
        this.classname = string2;
        this.flush();
    }

    public final String getClassName() {
        return this.classname;
    }

    public void flush() {
        this.p1v = null;
        this.p2v = null;
        this.p3avs.clear();
        this.p3bvs.clear();
    }

    public String[] getMessages() {
        int n2;
        Object object22;
        int n3;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.p1v != null) {
            object3 = this.p1v.getMessages();
            for (n3 = 0; n3 < ((String[])object3).length; ++n3) {
                arrayList.add("Pass 1: " + (String)object3[n3]);
            }
        }
        if (this.p2v != null) {
            object3 = this.p2v.getMessages();
            for (n3 = 0; n3 < ((Object)object3).length; ++n3) {
                arrayList.add("Pass 2: " + (String)object3[n3]);
            }
        }
        for (Pass3aVerifier pass3aVerifier : this.p3avs.values()) {
            object22 = pass3aVerifier.getMessages();
            int n4 = pass3aVerifier.getMethodNo();
            for (n2 = 0; n2 < ((Object)object22).length; ++n2) {
                arrayList.add("Pass 3a, method " + n4 + " ('" + Repository.lookupClass(this.classname).getMethods()[n4] + "'): " + (String)object22[n2]);
            }
        }
        for (Object object22 : this.p3bvs.values()) {
            String[] stringArray = ((PassVerifier)object22).getMessages();
            n2 = ((Pass3bVerifier)object22).getMethodNo();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add("Pass 3b, method " + n2 + " ('" + Repository.lookupClass(this.classname).getMethods()[n2] + "'): " + stringArray[i]);
            }
        }
        object22 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object22[i] = (String)arrayList.get(i);
        }
        return object22;
    }

    public static void main(String[] stringArray) {
        System.out.println("JustIce by Enver Haase, (C) 2001-2002.\n<http://bcel.sourceforge.net>\n<http://jakarta.apache.org/bcel>\n");
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            String[] stringArray2;
            int n3;
            if (stringArray[i].endsWith(".class") && (n3 = stringArray[i].lastIndexOf(".class")) != -1) {
                stringArray[i] = stringArray[i].substring(0, n3);
            }
            stringArray[i] = stringArray[i].replace('/', '.');
            System.out.println("Now verifying: " + stringArray[i] + "\n");
            Verifier verifier = VerifierFactory.getVerifier(stringArray[i]);
            VerificationResult verificationResult = verifier.doPass1();
            System.out.println("Pass 1:\n" + verificationResult);
            verificationResult = verifier.doPass2();
            System.out.println("Pass 2:\n" + verificationResult);
            if (verificationResult == VerificationResult.VR_OK) {
                stringArray2 = Repository.lookupClass(stringArray[i]);
                for (n2 = 0; n2 < stringArray2.getMethods().length; ++n2) {
                    verificationResult = verifier.doPass3a(n2);
                    System.out.println("Pass 3a, method number " + n2 + " ['" + stringArray2.getMethods()[n2] + "']:\n" + verificationResult);
                    verificationResult = verifier.doPass3b(n2);
                    System.out.println("Pass 3b, method number " + n2 + " ['" + stringArray2.getMethods()[n2] + "']:\n" + verificationResult);
                }
            }
            System.out.println("Warnings:");
            stringArray2 = verifier.getMessages();
            if (stringArray2.length == 0) {
                System.out.println("<none>");
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                System.out.println(stringArray2[n2]);
            }
            System.out.println("\n");
            verifier.flush();
            Repository.clearCache();
            System.gc();
        }
    }
}

