/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassParser;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ClassPath;
import com.ibm.xltxe.rnm1.xtq.bcel.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class SyntheticRepository
implements Repository {
    private static final String DEFAULT_PATH = ClassPath.getClassPath();
    private static HashMap _instances = new HashMap();
    private ClassPath _path = null;
    private HashMap _loadedClasses = new HashMap();

    private SyntheticRepository(ClassPath classPath) {
        this._path = classPath;
    }

    public static SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.SYSTEM_CLASS_PATH);
    }

    public static SyntheticRepository getInstance(ClassPath classPath) {
        SyntheticRepository syntheticRepository = (SyntheticRepository)_instances.get(classPath);
        if (syntheticRepository == null) {
            syntheticRepository = new SyntheticRepository(classPath);
            _instances.put(classPath, syntheticRepository);
        }
        return syntheticRepository;
    }

    @Override
    public void storeClass(JavaClass javaClass) {
        this._loadedClasses.put(javaClass.getClassName(), javaClass);
        javaClass.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass javaClass) {
        this._loadedClasses.remove(javaClass.getClassName());
    }

    @Override
    public JavaClass findClass(String string2) {
        return (JavaClass)this._loadedClasses.get(string2);
    }

    @Override
    public JavaClass loadClass(String string2) throws ClassNotFoundException {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + string2);
        }
        string2 = string2.replace('/', '.');
        try {
            return this.loadClass(this._path.getInputStream(string2), string2);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string2 + ": " + iOException.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        String string2 = clazz.getName();
        String string3 = string2;
        int n2 = string3.lastIndexOf(46);
        if (n2 > 0) {
            string3 = string3.substring(n2 + 1);
        }
        return this.loadClass(clazz.getResourceAsStream(string3 + ".class"), string2);
    }

    private JavaClass loadClass(InputStream inputStream, String string2) throws ClassNotFoundException {
        JavaClass javaClass = this.findClass(string2);
        if (javaClass != null) {
            return javaClass;
        }
        try {
            if (inputStream != null) {
                ClassParser classParser = new ClassParser(inputStream, string2);
                javaClass = classParser.parse();
                this.storeClass(javaClass);
                return javaClass;
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string2 + ": " + iOException.toString());
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + string2);
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

