/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantValue;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ExceptionTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Field;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.util.AttributeHTML;
import com.ibm.xltxe.rnm1.xtq.bcel.util.Class2HTML;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class MethodHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private ConstantHTML constant_html;
    private AttributeHTML attribute_html;

    MethodHTML(String string2, String string3, Method[] methodArray, Field[] fieldArray, ConstantHTML constantHTML, AttributeHTML attributeHTML) throws IOException {
        int n2;
        this.class_name = string3;
        this.attribute_html = attributeHTML;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string2 + string3 + "_methods.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        this.file.println("<TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Type</TH><TH ALIGN=LEFT>Field&nbsp;name</TH></TR>");
        for (n2 = 0; n2 < fieldArray.length; ++n2) {
            this.writeField(fieldArray[n2]);
        }
        this.file.println("</TABLE>");
        this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Return&nbsp;type</TH><TH ALIGN=LEFT>Method&nbsp;name</TH><TH ALIGN=LEFT>Arguments</TH></TR>");
        for (n2 = 0; n2 < methodArray.length; ++n2) {
            this.writeMethod(methodArray[n2], n2);
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    private void writeField(Field field) throws IOException {
        int n2;
        String string2 = Utility.signatureToString(field.getSignature());
        String string3 = field.getName();
        String string4 = Utility.accessToString(field.getAccessFlags());
        string4 = Utility.replace(string4, " ", "&nbsp;");
        this.file.print("<TR><TD><FONT COLOR=\"#FF0000\">" + string4 + "</FONT></TD>\n<TD>" + Class2HTML.referenceType(string2) + "</TD><TD><A NAME=\"field" + string3 + "\">" + string3 + "</A></TD>");
        Attribute[] attributeArray = field.getAttributes();
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            this.attribute_html.writeAttribute(attributeArray[n2], string3 + "@" + n2);
        }
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            if (attributeArray[n2].getTag() != 1) continue;
            String string5 = ((ConstantValue)attributeArray[n2]).toString();
            this.file.print("<TD>= <A HREF=\"" + this.class_name + "_attributes.html#" + string3 + "@" + n2 + "\" TARGET=\"Attributes\">" + string5 + "</TD>\n");
            break;
        }
        this.file.println("</TR>");
    }

    private final void writeMethod(Method method, int n2) throws IOException {
        int n3;
        String string2 = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string2, false);
        String string3 = Utility.methodSignatureReturnType(string2, false);
        String string4 = method.getName();
        String string5 = Utility.accessToString(method.getAccessFlags());
        Attribute[] attributeArray = method.getAttributes();
        string5 = Utility.replace(string5, " ", "&nbsp;");
        String string6 = Class2HTML.toHTML(string4);
        this.file.print("<TR VALIGN=TOP><TD><FONT COLOR=\"#FF0000\"><A NAME=method" + n2 + ">" + string5 + "</A></FONT></TD>");
        this.file.print("<TD>" + Class2HTML.referenceType(string3) + "</TD><TD>" + "<A HREF=" + this.class_name + "_code.html#method" + n2 + " TARGET=Code>" + string6 + "</A></TD>\n<TD>(");
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            this.file.print(Class2HTML.referenceType(stringArray[n3]));
            if (n3 >= stringArray.length - 1) continue;
            this.file.print(", ");
        }
        this.file.print(")</TD></TR>");
        for (n3 = 0; n3 < attributeArray.length; ++n3) {
            int n4;
            Object[] objectArray;
            this.attribute_html.writeAttribute(attributeArray[n3], "method" + n2 + "@" + n3, n2);
            byte by2 = attributeArray[n3].getTag();
            if (by2 == 3) {
                this.file.print("<TR VALIGN=TOP><TD COLSPAN=2></TD><TH ALIGN=LEFT>throws</TH><TD>");
                objectArray = ((ExceptionTable)attributeArray[n3]).getExceptionIndexTable();
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    this.file.print(this.constant_html.referenceConstant((int)objectArray[n4]));
                    if (n4 >= objectArray.length - 1) continue;
                    this.file.print(", ");
                }
                this.file.println("</TD></TR>");
                continue;
            }
            if (by2 != 2) continue;
            objectArray = ((Code)attributeArray[n3]).getAttributes();
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                this.attribute_html.writeAttribute(objectArray[n4], "method" + n2 + "@" + n3 + "@" + n4, n2);
            }
        }
    }
}

