/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantCP;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInterfaceMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.util.Class2HTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class ConstantHTML
implements Constants {
    private String class_name;
    private String class_package;
    private ConstantPool constant_pool;
    private PrintWriter file;
    private String[] constant_ref;
    private Constant[] constants;
    private Method[] methods;

    ConstantHTML(String string2, String string3, String string4, Method[] methodArray, ConstantPool constantPool) throws IOException {
        this.class_name = string3;
        this.class_package = string4;
        this.constant_pool = constantPool;
        this.methods = methodArray;
        this.constants = constantPool.getConstantPool();
        this.file = new PrintWriter(new FileOutputStream(string2 + string3 + "_cp.html"));
        this.constant_ref = new String[this.constants.length];
        this.constant_ref[0] = "&lt;unknown&gt;";
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        for (int i = 1; i < this.constants.length; ++i) {
            if (i % 2 == 0) {
                this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
            } else {
                this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
            }
            if (this.constants[i] != null) {
                this.writeConstant(i);
            }
            this.file.print("</TD></TR>\n");
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    String referenceConstant(int n2) {
        return this.constant_ref[n2];
    }

    private void writeConstant(int n2) {
        byte by2 = this.constants[n2].getTag();
        this.file.println("<H4> <A NAME=cp" + n2 + ">" + n2 + "</A> " + CONSTANT_NAMES[by2] + "</H4>");
        switch (by2) {
            case 10: 
            case 11: {
                int n3;
                int n4;
                Object object2;
                if (by2 == 10) {
                    object2 = (ConstantMethodref)this.constant_pool.getConstant(n2, (byte)10);
                    n4 = ((ConstantCP)object2).getClassIndex();
                    n3 = ((ConstantCP)object2).getNameAndTypeIndex();
                } else {
                    object2 = (ConstantInterfaceMethodref)this.constant_pool.getConstant(n2, (byte)11);
                    n4 = ((ConstantCP)object2).getClassIndex();
                    n3 = ((ConstantCP)object2).getNameAndTypeIndex();
                }
                object2 = this.constant_pool.constantToString(n3, (byte)12);
                String string2 = Class2HTML.toHTML((String)object2);
                String string3 = this.constant_pool.constantToString(n4, (byte)7);
                String string4 = Utility.compactClassName(string3);
                string4 = Utility.compactClassName(string3);
                string4 = Utility.compactClassName(string4, this.class_package + ".", true);
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n3, (byte)12);
                String string5 = this.constant_pool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string5, false);
                String string6 = Utility.methodSignatureReturnType(string5, false);
                String string7 = Class2HTML.referenceType(string6);
                StringBuffer stringBuffer = new StringBuffer("(");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(Class2HTML.referenceType(stringArray[i]));
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append(",&nbsp;");
                }
                stringBuffer.append(")");
                String string8 = stringBuffer.toString();
                String string9 = string3.equals(this.class_name) ? "<A HREF=\"" + this.class_name + "_code.html#method" + this.getMethodNumber((String)object2 + string5) + "\" TARGET=Code>" + string2 + "</A>" : "<A HREF=\"" + string3 + ".html" + "\" TARGET=_top>" + string4 + "</A>." + string2;
                this.constant_ref[n2] = string7 + "&nbsp;<A HREF=\"" + this.class_name + "_cp.html#cp" + n4 + "\" TARGET=Constants>" + string4 + "</A>.<A HREF=\"" + this.class_name + "_cp.html#cp" + n2 + "\" TARGET=ConstantPool>" + string2 + "</A>&nbsp;" + string8;
                this.file.println("<P><TT>" + string7 + "&nbsp;" + string9 + string8 + "&nbsp;</TT>\n<UL>" + "<LI><A HREF=\"#cp" + n4 + "\">Class index(" + n4 + ")</A>\n" + "<LI><A HREF=\"#cp" + n3 + "\">NameAndType index(" + n3 + ")</A></UL>");
                break;
            }
            case 9: {
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n2, (byte)9);
                int n5 = constantFieldref.getClassIndex();
                int n6 = constantFieldref.getNameAndTypeIndex();
                String string10 = this.constant_pool.constantToString(n5, (byte)7);
                String string11 = Utility.compactClassName(string10);
                string11 = Utility.compactClassName(string11, this.class_package + ".", true);
                String string12 = this.constant_pool.constantToString(n6, (byte)12);
                String string13 = string10.equals(this.class_name) ? "<A HREF=\"" + string10 + "_methods.html#field" + string12 + "\" TARGET=Methods>" + string12 + "</A>" : "<A HREF=\"" + string10 + ".html\" TARGET=_top>" + string11 + "</A>." + string12 + "\n";
                this.constant_ref[n2] = "<A HREF=\"" + this.class_name + "_cp.html#cp" + n5 + "\" TARGET=Constants>" + string11 + "</A>.<A HREF=\"" + this.class_name + "_cp.html#cp" + n2 + "\" TARGET=ConstantPool>" + string12 + "</A>";
                this.file.println("<P><TT>" + string13 + "</TT><BR>\n" + "<UL>" + "<LI><A HREF=\"#cp" + n5 + "\">Class(" + n5 + ")</A><BR>\n" + "<LI><A HREF=\"#cp" + n6 + "\">NameAndType(" + n6 + ")</A></UL>");
                break;
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)this.constant_pool.getConstant(n2, (byte)7);
                int n7 = constantClass.getNameIndex();
                String string14 = this.constant_pool.constantToString(n2, by2);
                String string15 = Utility.compactClassName(string14);
                string15 = Utility.compactClassName(string15, this.class_package + ".", true);
                String string16 = "<A HREF=\"" + string14 + ".html\" TARGET=_top>" + string15 + "</A>";
                this.constant_ref[n2] = "<A HREF=\"" + this.class_name + "_cp.html#cp" + n2 + "\" TARGET=ConstantPool>" + string15 + "</A>";
                this.file.println("<P><TT>" + string16 + "</TT><UL>" + "<LI><A HREF=\"#cp" + n7 + "\">Name index(" + n7 + ")</A></UL>\n");
                break;
            }
            case 8: {
                ConstantString constantString = (ConstantString)this.constant_pool.getConstant(n2, (byte)8);
                int n8 = constantString.getStringIndex();
                String string17 = Class2HTML.toHTML(this.constant_pool.constantToString(n2, by2));
                this.file.println("<P><TT>" + string17 + "</TT><UL>" + "<LI><A HREF=\"#cp" + n8 + "\">Name index(" + n8 + ")</A></UL>\n");
                break;
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n2, (byte)12);
                int n9 = constantNameAndType.getNameIndex();
                int n10 = constantNameAndType.getSignatureIndex();
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constant_pool.constantToString(n2, by2)) + "</TT><UL>" + "<LI><A HREF=\"#cp" + n9 + "\">Name index(" + n9 + ")</A>\n" + "<LI><A HREF=\"#cp" + n10 + "\">Signature index(" + n10 + ")</A></UL>\n");
                break;
            }
            default: {
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constant_pool.constantToString(n2, by2)) + "</TT>\n");
            }
        }
    }

    private final int getMethodNumber(String string2) {
        for (int i = 0; i < this.methods.length; ++i) {
            String string3 = this.methods[i].getName() + this.methods[i].getSignature();
            if (!string3.equals(string2)) continue;
            return i;
        }
        return -1;
    }
}

