/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.CodeException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantCP;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInterfaceMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import com.ibm.xltxe.rnm1.xtq.bcel.util.Class2HTML;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;

final class CodeHTML
implements Constants {
    private String class_name;
    private Method[] methods;
    private PrintWriter file;
    private BitSet goto_set;
    private ConstantPool constant_pool;
    private ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String string2, String string3, Method[] methodArray, ConstantPool constantPool, ConstantHTML constantHTML) throws IOException {
        this.class_name = string3;
        this.methods = methodArray;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string2 + string3 + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        for (int i = 0; i < methodArray.length; ++i) {
            this.writeMethod(methodArray[i], i);
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private final String codeToHTML(ByteSequence byteSequence, int n2) throws IOException {
        int n3;
        int n4;
        short s = (short)byteSequence.readUnsignedByte();
        int n5 = 0;
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer("<TT>" + OPCODE_NAMES[s] + "</TT></TD><TD>");
        if (s == 170 || s == 171) {
            n4 = byteSequence.getIndex() % 4;
            n6 = n4 == 0 ? 0 : 4 - n4;
            for (n3 = 0; n3 < n6; ++n3) {
                byteSequence.readByte();
            }
            n5 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.readInt();
                int n9 = byteSequence.getIndex() - 12 - n6 - 1;
                n5 += n9;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                int[] nArray = new int[n8 - n7 + 1];
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    nArray[n4] = n9 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + (n7 + n4) + "</TH>");
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + nArray[n4] + "\">" + nArray[n4] + "</A></TD>");
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + n5 + "\">" + n5 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                n4 = byteSequence.readInt();
                int n10 = byteSequence.getIndex() - 8 - n6 - 1;
                int[] nArray = new int[n4];
                n5 += n10;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                for (n3 = 0; n3 < n4; ++n3) {
                    int n11 = byteSequence.readInt();
                    nArray[n3] = n10 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + n11 + "</TH>");
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                for (n3 = 0; n3 < n4; ++n3) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + nArray[n3] + "\">" + nArray[n3] + "</A></TD>");
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + n5 + "\">" + n5 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int n12 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                stringBuffer.append("<A HREF=\"#code" + n2 + "@" + n12 + "\">" + n12 + "</A>");
                break;
            }
            case 200: 
            case 201: {
                n3 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                stringBuffer.append("<A HREF=\"#code" + n2 + "@" + n3 + "\">" + n3 + "</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n13;
                if (wide) {
                    n13 = byteSequence.readShort();
                    wide = false;
                } else {
                    n13 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("%" + n13);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("<FONT COLOR=\"#00FF00\">" + TYPE_NAMES[byteSequence.readByte()] + "</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n14 = byteSequence.readShort();
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n14, (byte)9);
                int n15 = constantFieldref.getClassIndex();
                String string2 = this.constant_pool.getConstantString(n15, (byte)7);
                string2 = Utility.compactClassName(string2, false);
                n14 = constantFieldref.getNameAndTypeIndex();
                String string3 = this.constant_pool.constantToString(n14, (byte)12);
                if (string2.equals(this.class_name)) {
                    stringBuffer.append("<A HREF=\"" + this.class_name + "_methods.html#field" + string3 + "\" TARGET=Methods>" + string3 + "</A>\n");
                    break;
                }
                stringBuffer.append(this.constant_html.referenceConstant(n15) + "." + string3);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short s2 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s2));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int n16;
                String string4;
                int n17;
                Object object2;
                short s3 = byteSequence.readShort();
                if (s == 185) {
                    int n18 = byteSequence.readUnsignedByte();
                    int n19 = byteSequence.readUnsignedByte();
                    object2 = (ConstantInterfaceMethodref)this.constant_pool.getConstant(s3, (byte)11);
                    n17 = ((ConstantCP)object2).getClassIndex();
                    string4 = this.constant_pool.constantToString((Constant)object2);
                    n16 = ((ConstantCP)object2).getNameAndTypeIndex();
                } else {
                    ConstantMethodref constantMethodref = (ConstantMethodref)this.constant_pool.getConstant(s3, (byte)10);
                    n17 = constantMethodref.getClassIndex();
                    string4 = this.constant_pool.constantToString(constantMethodref);
                    n16 = constantMethodref.getNameAndTypeIndex();
                }
                String string5 = Class2HTML.referenceClass(n17);
                string4 = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(n16, (byte)12)));
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n16, (byte)12);
                String string6 = this.constant_pool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string6, false);
                object2 = Utility.methodSignatureReturnType(string6, false);
                stringBuffer.append(string5 + ".<A HREF=\"" + this.class_name + "_cp.html#cp" + s3 + "\" TARGET=ConstantPool>" + string4 + "</A>" + "(");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(Class2HTML.referenceType(stringArray[i]));
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append("):" + Class2HTML.referenceType((String)object2));
                break;
            }
            case 19: 
            case 20: {
                short s4 = byteSequence.readShort();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + s4 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(s4, this.constant_pool.getConstant(s4).getTag())) + "</a>");
                break;
            }
            case 18: {
                int n20 = byteSequence.readUnsignedByte();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + n20 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(n20, this.constant_pool.getConstant(n20).getTag())) + "</a>");
                break;
            }
            case 189: {
                short s5 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s5));
                break;
            }
            case 197: {
                short s6 = byteSequence.readShort();
                byte by2 = byteSequence.readByte();
                stringBuffer.append(this.constant_html.referenceConstant(s6) + ":" + by2 + "-dimensional");
                break;
            }
            case 132: {
                short s7;
                int n21;
                if (wide) {
                    n21 = byteSequence.readShort();
                    s7 = byteSequence.readShort();
                    wide = false;
                } else {
                    n21 = byteSequence.readUnsignedByte();
                    s7 = byteSequence.readByte();
                }
                stringBuffer.append("%" + n21 + " " + s7);
                break;
            }
            default: {
                if (NO_OF_OPERANDS[s] <= 0) break;
                for (int i = 0; i < TYPE_OF_OPERANDS[s].length; ++i) {
                    switch (TYPE_OF_OPERANDS[s][i]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    stringBuffer.append("&nbsp;");
                }
            }
        }
        stringBuffer.append("</TD>");
        return stringBuffer.toString();
    }

    private final void findGotos(ByteSequence byteSequence, Method method, Code code) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.goto_set = new BitSet(byteSequence.available());
        if (code != null) {
            CodeException[] codeExceptionArray = code.getExceptionTable();
            n6 = codeExceptionArray.length;
            for (int i = 0; i < n6; ++i) {
                this.goto_set.set(codeExceptionArray[i].getStartPC());
                this.goto_set.set(codeExceptionArray[i].getEndPC());
                this.goto_set.set(codeExceptionArray[i].getHandlerPC());
            }
            Attribute[] attributeArray = code.getAttributes();
            for (n5 = 0; n5 < attributeArray.length; ++n5) {
                if (attributeArray[n5].getTag() != 5) continue;
                LocalVariable[] localVariableArray = ((LocalVariableTable)attributeArray[n5]).getLocalVariableTable();
                for (n4 = 0; n4 < localVariableArray.length; ++n4) {
                    n3 = localVariableArray[n4].getStartPC();
                    n2 = n3 + localVariableArray[n4].getLength();
                    this.goto_set.set(n3);
                    this.goto_set.set(n2);
                }
                break;
            }
        }
        int n7 = 0;
        while (byteSequence.available() > 0) {
            int n8 = byteSequence.readUnsignedByte();
            switch (n8) {
                case 170: 
                case 171: {
                    int n9;
                    n6 = byteSequence.getIndex() % 4;
                    int n10 = n6 == 0 ? 0 : 4 - n6;
                    for (n4 = 0; n4 < n10; ++n4) {
                        byteSequence.readByte();
                    }
                    n5 = byteSequence.readInt();
                    if (n8 == 170) {
                        n4 = byteSequence.readInt();
                        n3 = byteSequence.readInt();
                        int n11 = byteSequence.getIndex() - 12 - n10 - 1;
                        this.goto_set.set(n5 += n11);
                        for (n2 = 0; n2 < n3 - n4 + 1; ++n2) {
                            n9 = n11 + byteSequence.readInt();
                            this.goto_set.set(n9);
                        }
                    } else {
                        n4 = byteSequence.readInt();
                        int n12 = byteSequence.getIndex() - 8 - n10 - 1;
                        this.goto_set.set(n5 += n12);
                        for (n3 = 0; n3 < n4; ++n3) {
                            n2 = byteSequence.readInt();
                            n9 = n12 + byteSequence.readInt();
                            this.goto_set.set(n9);
                        }
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int n9 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                    this.goto_set.set(n9);
                    break;
                }
                case 200: 
                case 201: {
                    int n9 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                    this.goto_set.set(n9);
                    break;
                }
                default: {
                    byteSequence.unreadByte();
                    this.codeToHTML(byteSequence, 0);
                }
            }
            ++n7;
        }
    }

    private void writeMethod(Method method, int n2) throws IOException {
        int n3;
        String string2 = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string2, false);
        String string3 = Utility.methodSignatureReturnType(string2, false);
        String string4 = method.getName();
        String string5 = Class2HTML.toHTML(string4);
        String string6 = Utility.accessToString(method.getAccessFlags());
        string6 = Utility.replace(string6, " ", "&nbsp;");
        Attribute[] attributeArray = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + string6 + "</FONT>&nbsp;" + "<A NAME=method" + n2 + ">" + Class2HTML.referenceType(string3) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + n2 + "\" TARGET=Methods>" + string5 + "</A>(");
        for (int i = 0; i < stringArray.length; ++i) {
            this.file.print(Class2HTML.referenceType(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            this.file.print(",&nbsp;");
        }
        this.file.println(")</B></P>");
        Code code = null;
        byte[] byArray = null;
        if (attributeArray.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            for (int i = 0; i < attributeArray.length; ++i) {
                n3 = attributeArray[i].getTag();
                if (n3 != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + n2 + "@" + i + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[n3] + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributeArray[i] + "</LI>");
                }
                if (n3 != 2) continue;
                code = (Code)attributeArray[i];
                Attribute[] attributeArray2 = code.getAttributes();
                byArray = code.getCode();
                this.file.print("<UL>");
                for (int j = 0; j < attributeArray2.length; ++j) {
                    n3 = attributeArray2[j].getTag();
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#" + "method" + n2 + "@" + i + "@" + j + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[n3] + "</A></LI>\n");
                }
                this.file.print("</UL>");
            }
            this.file.println("</UL>");
        }
        if (byArray != null) {
            ByteSequence byteSequence = new ByteSequence(byArray);
            byteSequence.mark(byteSequence.available());
            this.findGotos(byteSequence, method, code);
            byteSequence.reset();
            this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
            n3 = 0;
            while (byteSequence.available() > 0) {
                int n4 = byteSequence.getIndex();
                String string7 = this.codeToHTML(byteSequence, n2);
                String string8 = "";
                if (this.goto_set.get(n4)) {
                    string8 = "<A NAME=code" + n2 + "@" + n4 + "></A>";
                }
                String string9 = byteSequence.getIndex() == byArray.length ? "<A NAME=code" + n2 + "@" + byArray.length + ">" + n4 + "</A>" : "" + n4;
                this.file.println("<TR VALIGN=TOP><TD>" + string9 + "</TD><TD>" + string8 + string7 + "</TR>");
                ++n3;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

