/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath
implements Serializable {
    public static final ClassPath SYSTEM_CLASS_PATH = new ClassPath();
    private PathEntry[] paths;
    private String class_path;

    public ClassPath(final String string2) {
        this.class_path = string2;
        ArrayList arrayList = (ArrayList)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ArrayList<PathEntry> arrayList = new ArrayList<PathEntry>();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, System.getProperty("path.separator"));
                while (stringTokenizer.hasMoreTokens()) {
                    String string22 = stringTokenizer.nextToken();
                    if (string22.equals("")) continue;
                    File file = new File(string22);
                    try {
                        if (!file.exists()) continue;
                        if (file.isDirectory()) {
                            arrayList.add(new Dir(string22));
                            continue;
                        }
                        arrayList.add(new Zip(new ZipFile(file)));
                    }
                    catch (IOException iOException) {
                        System.err.println("CLASSPATH component " + file + ": " + iOException);
                    }
                }
                return arrayList;
            }
        });
        this.paths = new PathEntry[arrayList.size()];
        arrayList.toArray(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public String toString() {
        return this.class_path;
    }

    public int hashCode() {
        return this.class_path.hashCode();
    }

    public boolean equals(Object object2) {
        if (object2 instanceof ClassPath) {
            return this.class_path.equals(((ClassPath)object2).class_path);
        }
        return false;
    }

    private static final void getPathComponents(String string2, final ArrayList arrayList) {
        if (string2 != null) {
            final StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        File file = new File(string2);
                        if (!file.exists()) continue;
                        arrayList.add(string2);
                    }
                    return null;
                }
            });
        }
    }

    public static final String getClassPath() {
        Object object2;
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("java.class.path");
            }
        });
        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("sun.boot.class.path");
            }
        });
        String string4 = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("java.ext.dirs");
            }
        });
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassPath.getPathComponents(string2, arrayList);
        ClassPath.getPathComponents(string3, arrayList);
        ArrayList arrayList2 = new ArrayList();
        ClassPath.getPathComponents(string4, arrayList2);
        Object object3 = arrayList2.iterator();
        while (object3.hasNext()) {
            object2 = new File((String)object3.next());
            String[] stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction<Object>((File)object2){
                final /* synthetic */ File val$ext_dir;
                {
                    this.val$ext_dir = file;
                }

                @Override
                public Object run() {
                    return this.val$ext_dir.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string2) {
                            return (string2 = string2.toLowerCase()).endsWith(".zip") || string2.endsWith(".jar");
                        }
                    });
                }
            });
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(string4 + File.separatorChar + stringArray[i]);
            }
        }
        object3 = new StringBuffer();
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            ((StringBuffer)object3).append((String)object2.next());
            if (!object2.hasNext()) continue;
            ((StringBuffer)object3).append(File.pathSeparatorChar);
        }
        return ((StringBuffer)object3).toString().intern();
    }

    public InputStream getInputStream(String string2) throws IOException {
        return this.getInputStream(string2, ".class");
    }

    public InputStream getInputStream(String string2, String string3) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string2 + string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            return inputStream;
        }
        return this.getClassFile(string2, string3).getInputStream();
    }

    public ClassFile getClassFile(String string2, String string3) throws IOException {
        for (int i = 0; i < this.paths.length; ++i) {
            ClassFile classFile = this.paths[i].getClassFile(string2, string3);
            if (classFile == null) continue;
            return classFile;
        }
        throw new IOException("Couldn't find: " + string2 + string3);
    }

    public ClassFile getClassFile(String string2) throws IOException {
        return this.getClassFile(string2, ".class");
    }

    public byte[] getBytes(String string2, String string3) throws IOException {
        InputStream inputStream = this.getInputStream(string2, string3);
        if (inputStream == null) {
            throw new IOException("Couldn't find: " + string2 + string3);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[inputStream.available()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        inputStream.close();
        return byArray;
    }

    public byte[] getBytes(String string2) throws IOException {
        return this.getBytes(string2, ".class");
    }

    public String getPath(String string2) throws IOException {
        int n2 = string2.lastIndexOf(46);
        String string3 = "";
        if (n2 > 0) {
            string3 = string2.substring(n2);
            string2 = string2.substring(0, n2);
        }
        return this.getPath(string2, string3);
    }

    public String getPath(String string2, String string3) throws IOException {
        return this.getClassFile(string2, string3).getPath();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile zipFile) {
            this.zip = zipFile;
        }

        @Override
        ClassFile getClassFile(String string2, String string3) throws IOException {
            final ZipEntry zipEntry = this.zip.getEntry(string2.replace('.', '/') + string3);
            return zipEntry != null ? new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return Zip.this.zip.getInputStream(zipEntry);
                }

                @Override
                public String getPath() {
                    return zipEntry.toString();
                }

                @Override
                public long getTime() {
                    return zipEntry.getTime();
                }

                @Override
                public long getSize() {
                    return zipEntry.getSize();
                }

                @Override
                public String getBase() {
                    return Zip.this.zip.getName();
                }
            } : null;
        }
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String string2) {
            this.dir = string2;
        }

        @Override
        ClassFile getClassFile(String string2, String string3) throws IOException {
            final File file = new File(this.dir + File.separatorChar + string2.replace('.', File.separatorChar) + string3);
            return file.exists() ? new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                @Override
                public long getTime() {
                    return file.lastModified();
                }

                @Override
                public long getSize() {
                    return file.length();
                }

                @Override
                public String getBase() {
                    return Dir.this.dir;
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    public static interface ClassFile {
        public InputStream getInputStream() throws IOException;

        public String getPath();

        public String getBase();

        public long getTime();

        public long getSize();
    }

    private static abstract class PathEntry
    implements Serializable {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }
}

