/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassParser;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ClassLoaderRepository
implements Repository {
    private ClassLoader loader;
    private HashMap loadedClasses = new HashMap();

    public ClassLoaderRepository(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    @Override
    public void storeClass(JavaClass javaClass) {
        this.loadedClasses.put(javaClass.getClassName(), javaClass);
        javaClass.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass javaClass) {
        this.loadedClasses.remove(javaClass.getClassName());
    }

    @Override
    public JavaClass findClass(String string2) {
        if (this.loadedClasses.containsKey(string2)) {
            return (JavaClass)this.loadedClasses.get(string2);
        }
        return null;
    }

    @Override
    public JavaClass loadClass(String string2) throws ClassNotFoundException {
        String string3 = string2.replace('.', '/');
        JavaClass javaClass = this.findClass(string2);
        if (javaClass != null) {
            return javaClass;
        }
        try {
            InputStream inputStream = this.loader.getResourceAsStream(string3 + ".class");
            if (inputStream == null) {
                throw new ClassNotFoundException(string2 + " not found.");
            }
            ClassParser classParser = new ClassParser(inputStream, string2);
            javaClass = classParser.parse();
            this.storeClass(javaClass);
            return javaClass;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }
}

