/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.Repository;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassParser;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantValue;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.EmptyVisitor;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Field;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.util.BCELFactory;
import java.io.OutputStream;
import java.io.PrintWriter;

public class BCELifier
extends EmptyVisitor {
    private JavaClass _clazz;
    private PrintWriter _out;
    private ConstantPoolGen _cp;

    public BCELifier(JavaClass javaClass, OutputStream outputStream) {
        this._clazz = javaClass;
        this._out = new PrintWriter(outputStream);
        this._cp = new ConstantPoolGen(this._clazz.getConstantPool());
    }

    public void start() {
        this.visitJavaClass(this._clazz);
        this._out.flush();
    }

    @Override
    public void visitJavaClass(JavaClass javaClass) {
        String string2 = javaClass.getClassName();
        String string3 = javaClass.getSuperclassName();
        String string4 = javaClass.getPackageName();
        String string5 = Utility.printArray(javaClass.getInterfaceNames(), false, true);
        if (!"".equals(string4)) {
            string2 = string2.substring(string4.length() + 1);
            this._out.println("package " + string4 + ";\n");
        }
        this._out.println("import com.ibm.xltxe.rnm1.xtq.bcel.generic.*;");
        this._out.println("import com.ibm.xltxe.rnm1.xtq.bcel.classfile.*;");
        this._out.println("import com.ibm.xltxe.rnm1.xtq.bcel.*;");
        this._out.println("import java.io.*;\n");
        this._out.println("public class " + string2 + "Creator implements Constants {");
        this._out.println("  private InstructionFactory _factory;");
        this._out.println("  private ConstantPoolGen    _cp;");
        this._out.println("  private ClassGen           _cg;\n");
        this._out.println("  public " + string2 + "Creator() {");
        this._out.println("    _cg = new ClassGen(\"" + ("".equals(string4) ? string2 : string4 + "." + string2) + "\", \"" + string3 + "\", " + "\"" + javaClass.getSourceFileName() + "\", " + BCELifier.printFlags(javaClass.getAccessFlags(), true) + ", " + "new String[] { " + string5 + " });\n");
        this._out.println("    _cp = _cg.getConstantPool();");
        this._out.println("    _factory = new InstructionFactory(_cg, _cp);");
        this._out.println("  }\n");
        this.printCreate();
        Field[] fieldArray = javaClass.getFields();
        if (fieldArray.length > 0) {
            this._out.println("  private void createFields() {");
            this._out.println("    FieldGen field;");
            for (int i = 0; i < fieldArray.length; ++i) {
                fieldArray[i].accept(this);
            }
            this._out.println("  }\n");
        }
        Method[] methodArray = javaClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this._out.println("  private void createMethod_" + i + "() {");
            methodArray[i].accept(this);
            this._out.println("  }\n");
        }
        this.printMain();
        this._out.println("}");
    }

    private void printCreate() {
        this._out.println("  public void create(OutputStream out) throws IOException {");
        Field[] fieldArray = this._clazz.getFields();
        if (fieldArray.length > 0) {
            this._out.println("    createFields();");
        }
        Method[] methodArray = this._clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this._out.println("    createMethod_" + i + "();");
        }
        this._out.println("    _cg.getJavaClass().dump(out);");
        this._out.println("  }\n");
    }

    private void printMain() {
        String string2 = this._clazz.getClassName();
        this._out.println("  public static void main(String[] args) throws Exception {");
        this._out.println("    " + string2 + "Creator creator = new " + string2 + "Creator();");
        this._out.println("    creator.create(new FileOutputStream(\"" + string2 + ".class\"));");
        this._out.println("  }");
    }

    @Override
    public void visitField(Field field) {
        this._out.println("\n    field = new FieldGen(" + BCELifier.printFlags(field.getAccessFlags()) + ", " + BCELifier.printType(field.getSignature()) + ", \"" + field.getName() + "\", _cp);");
        ConstantValue constantValue = field.getConstantValue();
        if (constantValue != null) {
            String string2 = constantValue.toString();
            this._out.println("    field.setInitValue(" + string2 + ")");
        }
        this._out.println("    _cg.addField(field.getField());");
    }

    @Override
    public void visitMethod(Method method) {
        MethodGen methodGen = new MethodGen(method, this._clazz.getClassName(), this._cp);
        Type type2 = methodGen.getReturnType();
        Type[] typeArray = methodGen.getArgumentTypes();
        this._out.println("    InstructionList il = new InstructionList();");
        this._out.println("    MethodGen method = new MethodGen(" + BCELifier.printFlags(method.getAccessFlags()) + ", " + BCELifier.printType(type2) + ", " + BCELifier.printArgumentTypes(typeArray) + ", " + "new String[] { " + Utility.printArray(methodGen.getArgumentNames(), false, true) + " }, \"" + method.getName() + "\", \"" + this._clazz.getClassName() + "\", il, _cp);\n");
        BCELFactory bCELFactory = new BCELFactory(methodGen, this._out);
        bCELFactory.start();
        this._out.println("    method.setMaxStack();");
        this._out.println("    method.setMaxLocals();");
        this._out.println("    _cg.addMethod(method.getMethod());");
        this._out.println("    il.dispose();");
    }

    static String printFlags(int n2) {
        return BCELifier.printFlags(n2, false);
    }

    static String printFlags(int n2, boolean bl) {
        if (n2 == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 1;
        for (int i = 0; i <= 2048; ++i) {
            if ((n2 & n3) != 0) {
                if (n3 == 32 && bl) {
                    stringBuffer.append("ACC_SUPER | ");
                } else {
                    stringBuffer.append("ACC_" + Constants.ACCESS_NAMES[i].toUpperCase() + " | ");
                }
            }
            n3 <<= 1;
        }
        String string2 = stringBuffer.toString();
        return string2.substring(0, string2.length() - 3);
    }

    static String printArgumentTypes(Type[] typeArray) {
        if (typeArray.length == 0) {
            return "Type.NO_ARGS";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append(BCELifier.printType(typeArray[i]));
            if (i >= typeArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return "new Type[] { " + stringBuffer.toString() + " }";
    }

    static String printType(Type type2) {
        return BCELifier.printType(type2.getSignature());
    }

    static String printType(String string2) {
        Type type2 = Type.getType(string2);
        byte by2 = type2.getType();
        if (by2 <= 12) {
            return "Type." + Constants.TYPE_NAMES[by2].toUpperCase();
        }
        if (type2.toString().equals("java.lang.String")) {
            return "Type.STRING";
        }
        if (type2.toString().equals("java.lang.Object")) {
            return "Type.OBJECT";
        }
        if (type2.toString().equals("java.lang.StringBuffer")) {
            return "Type.STRINGBUFFER";
        }
        if (type2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type2;
            return "new ArrayType(" + BCELifier.printType(arrayType.getBasicType()) + ", " + arrayType.getDimensions() + ")";
        }
        return "new ObjectType(\"" + Utility.signatureToString(string2, false) + "\")";
    }

    public static void main(String[] stringArray) throws Exception {
        String string2 = stringArray[0];
        JavaClass javaClass = Repository.lookupClass(string2);
        if (javaClass == null) {
            javaClass = new ClassParser(string2).parse();
        }
        BCELifier bCELifier = new BCELifier(javaClass, System.out);
        bCELifier.start();
    }
}

