/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.AllocationInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CHECKCAST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CPInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CodeExceptionGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPushInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.EmptyVisitor;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INSTANCEOF;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InvokeInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC2_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MULTIANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Select;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.util.BCELifier;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

class BCELFactory
extends EmptyVisitor {
    private MethodGen _mg;
    private PrintWriter _out;
    private ConstantPoolGen _cp;
    private HashMap branch_map = new HashMap();
    private ArrayList branches = new ArrayList();

    BCELFactory(MethodGen methodGen, PrintWriter printWriter) {
        this._mg = methodGen;
        this._cp = methodGen.getConstantPool();
        this._out = printWriter;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            for (InstructionHandle instructionHandle = this._mg.getInstructionList().getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                Instruction instruction2 = instructionHandle.getInstruction();
                if (instruction2 instanceof BranchInstruction) {
                    this.branch_map.put(instruction2, instructionHandle);
                }
                if (instructionHandle.hasTargeters()) {
                    if (instruction2 instanceof BranchInstruction) {
                        this._out.println("    InstructionHandle ih_" + instructionHandle.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + instructionHandle.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (this.visitInstruction(instruction2)) continue;
                instruction2.accept(this);
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction instruction2) {
        short s = instruction2.getOpcode();
        if (InstructionConstants.INSTRUCTIONS[s] != null && !(instruction2 instanceof ConstantPushInstruction) && !(instruction2 instanceof ReturnInstruction)) {
            this._out.println("il.append(InstructionConstants." + instruction2.getName().toUpperCase() + ");");
            return true;
        }
        return false;
    }

    @Override
    public void visitLocalVariableInstruction(LocalVariableInstruction localVariableInstruction) {
        short s = localVariableInstruction.getOpcode();
        Type type2 = localVariableInstruction.getType(this._cp);
        if (s == 132) {
            this._out.println("il.append(new IINC(" + localVariableInstruction.getIndex() + ", " + ((IINC)localVariableInstruction).getIncrement() + "));");
        } else {
            String string2 = s < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + string2 + "(" + BCELifier.printType(type2) + ", " + localVariableInstruction.getIndex() + "));");
        }
    }

    @Override
    public void visitArrayInstruction(ArrayInstruction arrayInstruction) {
        short s = arrayInstruction.getOpcode();
        Type type2 = arrayInstruction.getType(this._cp);
        String string2 = s < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + string2 + "(" + BCELifier.printType(type2) + "));");
    }

    @Override
    public void visitFieldInstruction(FieldInstruction fieldInstruction) {
        short s = fieldInstruction.getOpcode();
        String string2 = fieldInstruction.getClassName(this._cp);
        String string3 = fieldInstruction.getFieldName(this._cp);
        Type type2 = fieldInstruction.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + string2 + "\", \"" + string3 + "\", " + BCELifier.printType(type2) + ", " + "Constants." + Constants.OPCODE_NAMES[s].toUpperCase() + "));");
    }

    @Override
    public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
        short s = invokeInstruction.getOpcode();
        String string2 = invokeInstruction.getClassName(this._cp);
        String string3 = invokeInstruction.getMethodName(this._cp);
        Type type2 = invokeInstruction.getReturnType(this._cp);
        Type[] typeArray = invokeInstruction.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + string2 + "\", \"" + string3 + "\", " + BCELifier.printType(type2) + ", " + BCELifier.printArgumentTypes(typeArray) + ", " + "Constants." + Constants.OPCODE_NAMES[s].toUpperCase() + "));");
    }

    @Override
    public void visitAllocationInstruction(AllocationInstruction allocationInstruction) {
        Type type2 = allocationInstruction instanceof CPInstruction ? ((CPInstruction)((Object)allocationInstruction)).getType(this._cp) : ((NEWARRAY)allocationInstruction).getType();
        short s = ((Instruction)((Object)allocationInstruction)).getOpcode();
        short s2 = 1;
        switch (s) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type2).getClassName() + "\"));");
                break;
            }
            case 197: {
                s2 = ((MULTIANEWARRAY)allocationInstruction).getDimensions();
            }
            case 188: 
            case 189: {
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type2) + ", (short) " + s2 + "));");
                break;
            }
            default: {
                throw new RuntimeException("Oops: " + s);
            }
        }
    }

    private void createConstant(Object object2) {
        String string2 = object2.toString();
        if (object2 instanceof String) {
            string2 = '\"' + Utility.convertString(object2.toString()) + '\"';
        } else if (object2 instanceof Character) {
            string2 = "(char)0x" + Integer.toHexString(((Character)object2).charValue());
        }
        this._out.println("il.append(new PUSH(_cp, " + string2 + "));");
    }

    @Override
    public void visitLDC(LDC lDC) {
        this.createConstant(lDC.getValue(this._cp));
    }

    @Override
    public void visitLDC2_W(LDC2_W lDC2_W) {
        this.createConstant(lDC2_W.getValue(this._cp));
    }

    @Override
    public void visitConstantPushInstruction(ConstantPushInstruction constantPushInstruction) {
        this.createConstant(constantPushInstruction.getValue());
    }

    @Override
    public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
        Type type2 = iNSTANCEOF.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type2) + ")));");
    }

    @Override
    public void visitCHECKCAST(CHECKCAST cHECKCAST) {
        Type type2 = cHECKCAST.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type2) + "));");
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction returnInstruction) {
        Type type2 = returnInstruction.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type2) + "));");
    }

    @Override
    public void visitBranchInstruction(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = (BranchHandle)this.branch_map.get(branchInstruction);
        int n2 = branchHandle.getPosition();
        String string2 = branchInstruction.getName() + "_" + n2;
        if (branchInstruction instanceof Select) {
            int n3;
            Select select2 = (Select)branchInstruction;
            this.branches.add(branchInstruction);
            StringBuffer stringBuffer = new StringBuffer("new int[] { ");
            int[] nArray = select2.getMatchs();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                stringBuffer.append(nArray[n3]);
                if (n3 >= nArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            this._out.print("    Select " + string2 + " = new " + branchInstruction.getName().toUpperCase() + "(" + stringBuffer + ", new InstructionHandle[] { ");
            for (n3 = 0; n3 < nArray.length; ++n3) {
                this._out.print("null");
                if (n3 >= nArray.length - 1) continue;
                this._out.print(", ");
            }
            this._out.println(");");
        } else {
            String string3;
            int n4 = branchHandle.getTarget().getPosition();
            if (n2 > n4) {
                string3 = "ih_" + n4;
            } else {
                this.branches.add(branchInstruction);
                string3 = "null";
            }
            this._out.println("    BranchInstruction " + string2 + " = _factory.createBranchInstruction(" + "Constants." + branchInstruction.getName().toUpperCase() + ", " + string3 + ");");
        }
        if (branchHandle.hasTargeters()) {
            this._out.println("    ih_" + n2 + " = il.append(" + string2 + ");");
        } else {
            this._out.println("    il.append(" + string2 + ");");
        }
    }

    @Override
    public void visitRET(RET rET) {
        this._out.println("il.append(new RET(" + rET.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        for (BranchInstruction branchInstruction : this.branches) {
            BranchHandle branchHandle = (BranchHandle)this.branch_map.get(branchInstruction);
            int n2 = branchHandle.getPosition();
            String string2 = branchInstruction.getName() + "_" + n2;
            int n3 = branchHandle.getTarget().getPosition();
            this._out.println("    " + string2 + ".setTarget(ih_" + n3 + ");");
            if (!(branchInstruction instanceof Select)) continue;
            InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
            for (int i = 0; i < instructionHandleArray.length; ++i) {
                n3 = instructionHandleArray[i].getPosition();
                this._out.println("    " + string2 + ".setTarget(" + i + ", ih_" + n3 + ");");
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] codeExceptionGenArray = this._mg.getExceptionHandlers();
        for (int i = 0; i < codeExceptionGenArray.length; ++i) {
            CodeExceptionGen codeExceptionGen = codeExceptionGenArray[i];
            String string2 = codeExceptionGen.getCatchType() == null ? "null" : BCELifier.printType(codeExceptionGen.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + codeExceptionGen.getStartPC().getPosition() + ", " + "ih_" + codeExceptionGen.getEndPC().getPosition() + ", " + "ih_" + codeExceptionGen.getHandlerPC().getPosition() + ", " + string2 + ");");
        }
    }
}

