/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.CodeException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantValue;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ExceptionTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.InnerClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.InnerClasses;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumber;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.SourceFile;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.util.Class2HTML;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class AttributeHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private int attr_count = 0;
    private ConstantHTML constant_html;
    private ConstantPool constant_pool;

    AttributeHTML(String string2, String string3, ConstantPool constantPool, ConstantHTML constantHTML) throws IOException {
        this.class_name = string3;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string2 + string3 + "_attributes.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
    }

    private final String codeLink(int n2, int n3) {
        return "<A HREF=\"" + this.class_name + "_code.html#code" + n3 + "@" + n2 + "\" TARGET=Code>" + n2 + "</A>";
    }

    final void close() {
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    final void writeAttribute(Attribute attribute2, String string2) throws IOException {
        this.writeAttribute(attribute2, string2, 0);
    }

    final void writeAttribute(Attribute attribute2, String string2, int n2) throws IOException {
        byte by2 = attribute2.getTag();
        if (by2 == -1) {
            return;
        }
        ++this.attr_count;
        if (this.attr_count % 2 == 0) {
            this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
        } else {
            this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
        }
        this.file.println("<H4><A NAME=\"" + string2 + "\">" + this.attr_count + " " + ATTRIBUTE_NAMES[by2] + "</A></H4>");
        switch (by2) {
            case 2: {
                Code code = (Code)attribute2;
                this.file.print("<UL><LI>Maximum stack size = " + code.getMaxStack() + "</LI>\n<LI>Number of local variables = " + code.getMaxLocals() + "</LI>\n<LI><A HREF=\"" + this.class_name + "_code.html#method" + n2 + "\" TARGET=Code>Byte code</A></LI></UL>\n");
                CodeException[] codeExceptionArray = code.getExceptionTable();
                int n3 = codeExceptionArray.length;
                if (n3 <= 0) break;
                this.file.print("<P><B>Exceptions handled</B><UL>");
                for (int i = 0; i < n3; ++i) {
                    int n4 = codeExceptionArray[i].getCatchType();
                    this.file.print("<LI>");
                    if (n4 != 0) {
                        this.file.print(this.constant_html.referenceConstant(n4));
                    } else {
                        this.file.print("Any Exception");
                    }
                    this.file.print("<BR>(Ranging from lines " + this.codeLink(codeExceptionArray[i].getStartPC(), n2) + " to " + this.codeLink(codeExceptionArray[i].getEndPC(), n2) + ", handled at line " + this.codeLink(codeExceptionArray[i].getHandlerPC(), n2) + ")</LI>");
                }
                this.file.print("</UL>");
                break;
            }
            case 1: {
                int n5 = ((ConstantValue)attribute2).getConstantValueIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + n5 + "\" TARGET=\"ConstantPool\">Constant value index(" + n5 + ")</A></UL>\n");
                break;
            }
            case 0: {
                int n6 = ((SourceFile)attribute2).getSourceFileIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + n6 + "\" TARGET=\"ConstantPool\">Source file index(" + n6 + ")</A></UL>\n");
                break;
            }
            case 3: {
                int[] nArray = ((ExceptionTable)attribute2).getExceptionIndexTable();
                this.file.print("<UL>");
                for (int i = 0; i < nArray.length; ++i) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_cp.html#cp" + nArray[i] + "\" TARGET=\"ConstantPool\">Exception class index(" + nArray[i] + ")</A>\n");
                }
                this.file.print("</UL>\n");
                break;
            }
            case 4: {
                LineNumber[] lineNumberArray = ((LineNumberTable)attribute2).getLineNumberTable();
                this.file.print("<P>");
                for (int i = 0; i < lineNumberArray.length; ++i) {
                    this.file.print("(" + lineNumberArray[i].getStartPC() + ",&nbsp;" + lineNumberArray[i].getLineNumber() + ")");
                    if (i >= lineNumberArray.length - 1) continue;
                    this.file.print(", ");
                }
                break;
            }
            case 5: {
                LocalVariable[] localVariableArray = ((LocalVariableTable)attribute2).getLocalVariableTable();
                this.file.print("<UL>");
                for (int i = 0; i < localVariableArray.length; ++i) {
                    int n7 = localVariableArray[i].getSignatureIndex();
                    String string3 = ((ConstantUtf8)this.constant_pool.getConstant(n7, (byte)1)).getBytes();
                    string3 = Utility.signatureToString(string3, false);
                    int n8 = localVariableArray[i].getStartPC();
                    int n9 = n8 + localVariableArray[i].getLength();
                    this.file.println("<LI>" + Class2HTML.referenceType(string3) + "&nbsp;<B>" + localVariableArray[i].getName() + "</B> in slot %" + localVariableArray[i].getIndex() + "<BR>Valid from lines " + "<A HREF=\"" + this.class_name + "_code.html#code" + n2 + "@" + n8 + "\" TARGET=Code>" + n8 + "</A> to " + "<A HREF=\"" + this.class_name + "_code.html#code" + n2 + "@" + n9 + "\" TARGET=Code>" + n9 + "</A></LI>");
                }
                this.file.print("</UL>\n");
                break;
            }
            case 6: {
                InnerClass[] innerClassArray = ((InnerClasses)attribute2).getInnerClasses();
                this.file.print("<UL>");
                for (int i = 0; i < innerClassArray.length; ++i) {
                    int n10 = innerClassArray[i].getInnerNameIndex();
                    String string4 = n10 > 0 ? ((ConstantUtf8)this.constant_pool.getConstant(n10, (byte)1)).getBytes() : "&lt;anonymous&gt;";
                    String string5 = Utility.accessToString(innerClassArray[i].getInnerAccessFlags());
                    this.file.print("<LI><FONT COLOR=\"#FF0000\">" + string5 + "</FONT> " + this.constant_html.referenceConstant(innerClassArray[i].getInnerClassIndex()) + " in&nbsp;class " + this.constant_html.referenceConstant(innerClassArray[i].getOuterClassIndex()) + " named " + string4 + "</LI>\n");
                }
                this.file.print("</UL>\n");
                break;
            }
            default: {
                this.file.print("<P>" + attribute2.toString());
            }
        }
        this.file.println("</TD></TR>");
        this.file.flush();
    }
}

