/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BasicType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;

public abstract class Type
implements Serializable {
    protected byte type;
    protected String signature;
    public static final BasicType VOID = new BasicType(12);
    public static final BasicType BOOLEAN = new BasicType(4);
    public static final BasicType INT = new BasicType(10);
    public static final BasicType SHORT = new BasicType(9);
    public static final BasicType BYTE = new BasicType(8);
    public static final BasicType LONG = new BasicType(11);
    public static final BasicType DOUBLE = new BasicType(7);
    public static final BasicType FLOAT = new BasicType(6);
    public static final BasicType CHAR = new BasicType(5);
    public static final ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final ObjectType STRING = new ObjectType("java.lang.String");
    public static final ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final Type[] NO_ARGS = new Type[0];
    public static final ReferenceType NULL = new ReferenceType(){};
    public static final Type UNKNOWN = new Type(15, "<unknown object>"){};
    private static int consumed_chars = 0;

    protected Type(byte by2, String string2) {
        this.type = by2;
        this.signature = string2;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte getType() {
        return this.type;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static String getMethodSignature(Type type2, Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n2 = typeArray == null ? 0 : typeArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(typeArray[i].getSignature());
        }
        stringBuffer.append(')');
        stringBuffer.append(type2.getSignature());
        return stringBuffer.toString();
    }

    public static final Type getType(String string2) throws StringIndexOutOfBoundsException {
        byte by2 = Utility.typeOfSignature(string2);
        if (by2 <= 12) {
            consumed_chars = 1;
            return BasicType.getType(by2);
        }
        if (by2 == 13) {
            int n2 = 0;
            while (string2.charAt(++n2) == '[') {
            }
            Type type2 = Type.getType(string2.substring(n2));
            consumed_chars += n2;
            return new ArrayType(type2, n2);
        }
        int n3 = string2.indexOf(59);
        if (n3 < 0) {
            throw new ClassFormatException("Invalid signature: " + string2);
        }
        consumed_chars = n3 + 1;
        return new ObjectType(string2.substring(1, n3).replace('/', '.'));
    }

    public static Type getReturnType(String string2) {
        try {
            int n2 = string2.lastIndexOf(41) + 1;
            return Type.getType(string2.substring(n2));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string2);
        }
    }

    public static Type[] getArgumentTypes(String string2) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        try {
            if (string2.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string2);
            }
            int n2 = 1;
            while (string2.charAt(n2) != ')') {
                arrayList.add(Type.getType(string2.substring(n2)));
                n2 += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string2);
        }
        Type[] typeArray = new Type[arrayList.size()];
        arrayList.toArray(typeArray);
        return typeArray;
    }

    public static Type getType(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (clazz.isArray()) {
            return Type.getType(clazz.getName());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT;
            }
            if (clazz == Void.TYPE) {
                return VOID;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (clazz == Byte.TYPE) {
                return BYTE;
            }
            if (clazz == Short.TYPE) {
                return SHORT;
            }
            if (clazz == Byte.TYPE) {
                return BYTE;
            }
            if (clazz == Long.TYPE) {
                return LONG;
            }
            if (clazz == Character.TYPE) {
                return CHAR;
            }
            throw new IllegalStateException("Ooops, what primitive type is " + clazz);
        }
        return new ObjectType(clazz.getName());
    }

    public static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(Type.getType(classArray[i]).getSignature());
        }
        stringBuffer.append(")");
        stringBuffer.append(Type.getType(method.getReturnType()).getSignature());
        return stringBuffer.toString();
    }
}

