/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Select;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class TABLESWITCH
extends Select {
    TABLESWITCH() {
    }

    public TABLESWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)170, nArray, instructionHandleArray, instructionHandle);
        this.length = (short)(13 + this.match_length * 4);
        this.fixed_length = this.length;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        int n2 = this.match_length > 0 ? this.match[0] : 0;
        dataOutputStream.writeInt(n2);
        int n3 = this.match_length > 0 ? this.match[this.match_length - 1] : 0;
        dataOutputStream.writeInt(n3);
        for (int i = 0; i < this.match_length; ++i) {
            this.indices[i] = this.getTargetOffset(this.targets[i]);
            dataOutputStream.writeInt(this.indices[i]);
        }
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        int n2;
        super.initFromFile(byteSequence, bl);
        int n3 = byteSequence.readInt();
        int n4 = byteSequence.readInt();
        this.match_length = n4 - n3 + 1;
        this.fixed_length = (short)(13 + this.match_length * 4);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        for (n2 = n3; n2 <= n4; ++n2) {
            this.match[n2 - n3] = n2;
        }
        for (n2 = 0; n2 < this.match_length; ++n2) {
            this.indices[n2] = byteSequence.readInt();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitVariableLengthInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitBranchInstruction(this);
        visitor.visitSelect(this);
        visitor.visitTABLESWITCH(this);
    }
}

