/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.BIPUSH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CompoundInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC2_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.SIPUSH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.VariableLengthInstruction;

public final class PUSH
implements CompoundInstruction,
VariableLengthInstruction,
InstructionConstants {
    private Instruction instruction;

    public PUSH(ConstantPoolGen constantPoolGen, int n2) {
        this.instruction = n2 >= -1 && n2 <= 5 ? INSTRUCTIONS[3 + n2] : (n2 >= -128 && n2 <= 127 ? new BIPUSH((byte)n2) : (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE ? new SIPUSH((short)n2) : new LDC(constantPoolGen.addInteger(n2))));
    }

    public PUSH(ConstantPoolGen constantPoolGen, boolean bl) {
        this.instruction = INSTRUCTIONS[3 + (bl ? 1 : 0)];
    }

    public PUSH(ConstantPoolGen constantPoolGen, float f2) {
        this.instruction = (double)f2 == 0.0 ? FCONST_0 : ((double)f2 == 1.0 ? FCONST_1 : ((double)f2 == 2.0 ? FCONST_2 : new LDC(constantPoolGen.addFloat(f2))));
    }

    public PUSH(ConstantPoolGen constantPoolGen, long l) {
        this.instruction = l == 0L ? LCONST_0 : (l == 1L ? LCONST_1 : new LDC2_W(constantPoolGen.addLong(l)));
    }

    public PUSH(ConstantPoolGen constantPoolGen, double d) {
        this.instruction = d == 0.0 ? DCONST_0 : (d == 1.0 ? DCONST_1 : new LDC2_W(constantPoolGen.addDouble(d)));
    }

    public PUSH(ConstantPoolGen constantPoolGen, String string2) {
        this.instruction = string2 == null ? ACONST_NULL : new LDC(constantPoolGen.addString(string2));
    }

    public PUSH(ConstantPoolGen constantPoolGen, Number number2) {
        if (number2 instanceof Integer || number2 instanceof Short || number2 instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (int)number2.intValue()).instruction;
        } else if (number2 instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (double)number2.doubleValue()).instruction;
        } else if (number2 instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (float)number2.floatValue()).instruction;
        } else if (number2 instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (long)number2.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + number2);
        }
    }

    public PUSH(ConstantPoolGen constantPoolGen, Character c) {
        this(constantPoolGen, (int)c.charValue());
    }

    public PUSH(ConstantPoolGen constantPoolGen, Boolean bl) {
        this(constantPoolGen, (boolean)bl);
    }

    @Override
    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public String toString() {
        return this.instruction.toString() + " (PUSH)";
    }
}

