/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.CodeException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ExceptionTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumber;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CodeExceptionGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldGenOrMethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IfInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IndexedInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionTargeter;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LineNumberGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodObserver;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NOP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Select;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TargetLostException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TypedInstruction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class MethodGen
extends FieldGenOrMethodGen {
    private String class_name;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private boolean strip_attributes;
    private ArrayList variable_vec = new ArrayList();
    private ArrayList line_number_vec = new ArrayList();
    private ArrayList exception_vec = new ArrayList();
    private ArrayList throws_vec = new ArrayList();
    private ArrayList code_attrs_vec = new ArrayList();
    private ArrayList observers;

    public MethodGen(int n2, Type type2, Type[] typeArray, String[] stringArray, String string2, String string3, InstructionList instructionList, ConstantPoolGen constantPoolGen) {
        this.setAccessFlags(n2);
        this.setType(type2);
        this.setArgumentTypes(typeArray);
        this.setArgumentNames(stringArray);
        this.setName(string2);
        this.setClassName(string3);
        this.setInstructionList(instructionList);
        this.setConstantPool(constantPoolGen);
        boolean bl = this.isAbstract() || this.isNative();
        InstructionHandle instructionHandle = null;
        InstructionHandle instructionHandle2 = null;
        if (!bl) {
            instructionHandle = instructionList.getStart();
            instructionHandle2 = instructionList.getEnd();
            if (!this.isStatic() && string3 != null) {
                this.addLocalVariable("this", new ObjectType(string3), instructionHandle, instructionHandle2);
            }
        }
        if (typeArray != null) {
            int n3;
            int n4 = typeArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (Type.VOID != typeArray[n3]) continue;
                throw new ClassGenException("'void' is an illegal argument type for a method");
            }
            if (stringArray != null) {
                if (n4 != stringArray.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + n4 + " vs. " + stringArray.length);
                }
            } else {
                stringArray = new String[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    stringArray[n3] = "arg" + n3;
                }
                this.setArgumentNames(stringArray);
            }
            if (!bl) {
                for (n3 = 0; n3 < n4; ++n3) {
                    this.addLocalVariable(stringArray[n3], typeArray[n3], instructionHandle, instructionHandle2);
                }
            }
        }
    }

    public MethodGen(Method method, String string2, ConstantPoolGen constantPoolGen) {
        this(method.getAccessFlags(), Type.getReturnType(method.getSignature()), Type.getArgumentTypes(method.getSignature()), null, method.getName(), string2, (method.getAccessFlags() & 0x500) == 0 ? new InstructionList(method.getCode().getCode()) : null, constantPoolGen);
        Attribute[] attributeArray = method.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            String[] stringArray;
            Attribute attribute2 = attributeArray[i];
            if (attribute2 instanceof Code) {
                InstructionHandle instructionHandle;
                stringArray = (String[])attribute2;
                this.setMaxStack(stringArray.getMaxStack());
                this.setMaxLocals(stringArray.getMaxLocals());
                CodeException[] codeExceptionArray = stringArray.getExceptionTable();
                if (codeExceptionArray != null) {
                    for (int j = 0; j < codeExceptionArray.length; ++j) {
                        CodeException codeException = codeExceptionArray[j];
                        int n2 = codeException.getCatchType();
                        ObjectType objectType = null;
                        if (n2 > 0) {
                            String string3 = method.getConstantPool().getConstantString(n2, (byte)7);
                            objectType = new ObjectType(string3);
                        }
                        int n3 = codeException.getEndPC();
                        int n4 = method.getCode().getCode().length;
                        if (n4 == n3) {
                            instructionHandle = this.il.getEnd();
                        } else {
                            instructionHandle = this.il.findHandle(n3);
                            instructionHandle = instructionHandle.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(codeException.getStartPC()), instructionHandle, this.il.findHandle(codeException.getHandlerPC()), objectType);
                    }
                }
                Attribute[] attributeArray2 = stringArray.getAttributes();
                for (int j = 0; j < attributeArray2.length; ++j) {
                    Cloneable cloneable;
                    int n5;
                    Cloneable[] cloneableArray;
                    attribute2 = attributeArray2[j];
                    if (attribute2 instanceof LineNumberTable) {
                        cloneableArray = ((LineNumberTable)attribute2).getLineNumberTable();
                        for (n5 = 0; n5 < cloneableArray.length; ++n5) {
                            cloneable = cloneableArray[n5];
                            this.addLineNumber(this.il.findHandle(((LineNumber)cloneable).getStartPC()), ((LineNumber)cloneable).getLineNumber());
                        }
                        continue;
                    }
                    if (attribute2 instanceof LocalVariableTable) {
                        cloneableArray = ((LocalVariableTable)attribute2).getLocalVariableTable();
                        this.removeLocalVariables();
                        for (n5 = 0; n5 < cloneableArray.length; ++n5) {
                            cloneable = cloneableArray[n5];
                            InstructionHandle instructionHandle2 = this.il.findHandle(((LocalVariable)cloneable).getStartPC());
                            instructionHandle = this.il.findHandle(((LocalVariable)cloneable).getStartPC() + ((LocalVariable)cloneable).getLength());
                            if (null == instructionHandle2) {
                                instructionHandle2 = this.il.getStart();
                            }
                            if (null == instructionHandle) {
                                instructionHandle = this.il.getEnd();
                            }
                            this.addLocalVariable(((LocalVariable)cloneable).getName(), Type.getType(((LocalVariable)cloneable).getSignature()), ((LocalVariable)cloneable).getIndex(), instructionHandle2, instructionHandle);
                        }
                        continue;
                    }
                    this.addCodeAttribute(attribute2);
                }
                continue;
            }
            if (attribute2 instanceof ExceptionTable) {
                stringArray = ((ExceptionTable)attribute2).getExceptionNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    this.addException(stringArray[j]);
                }
                continue;
            }
            this.addAttribute(attribute2);
        }
    }

    public LocalVariableGen addLocalVariable(String string2, Type type2, int n2, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        byte by2 = type2.getType();
        if (by2 != 16) {
            LocalVariableGen localVariableGen;
            int n3;
            int n4 = type2.getSize();
            if (n2 + n4 > this.max_locals) {
                this.max_locals = n2 + n4;
            }
            if ((n3 = this.variable_vec.indexOf(localVariableGen = new LocalVariableGen(n2, string2, type2, instructionHandle, instructionHandle2))) >= 0) {
                this.variable_vec.set(n3, localVariableGen);
            } else {
                this.variable_vec.add(localVariableGen);
            }
            return localVariableGen;
        }
        throw new IllegalArgumentException("Can not use " + type2 + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String string2, Type type2, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        return this.addLocalVariable(string2, type2, this.max_locals, instructionHandle, instructionHandle2);
    }

    public void removeLocalVariable(LocalVariableGen localVariableGen) {
        this.variable_vec.remove(localVariableGen);
    }

    public void removeLocalVariables() {
        this.variable_vec.clear();
    }

    private static final void sort(LocalVariableGen[] localVariableGenArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = localVariableGenArray[(n2 + n3) / 2].getIndex();
        while (true) {
            if (localVariableGenArray[n4].getIndex() < n6) {
                ++n4;
                continue;
            }
            while (n6 < localVariableGenArray[n5].getIndex()) {
                --n5;
            }
            if (n4 <= n5) {
                LocalVariableGen localVariableGen = localVariableGenArray[n4];
                localVariableGenArray[n4] = localVariableGenArray[n5];
                localVariableGenArray[n5] = localVariableGen;
                ++n4;
                --n5;
            }
            if (n4 > n5) break;
        }
        if (n2 < n5) {
            MethodGen.sort(localVariableGenArray, n2, n5);
        }
        if (n4 < n3) {
            MethodGen.sort(localVariableGenArray, n4, n3);
        }
    }

    public LocalVariableGen[] getLocalVariables() {
        int n2 = this.variable_vec.size();
        LocalVariableGen[] localVariableGenArray = new LocalVariableGen[n2];
        this.variable_vec.toArray(localVariableGenArray);
        for (int i = 0; i < n2; ++i) {
            if (localVariableGenArray[i].getStart() == null) {
                localVariableGenArray[i].setStart(this.il.getStart());
            }
            if (localVariableGenArray[i].getEnd() != null) continue;
            localVariableGenArray[i].setEnd(this.il.getEnd());
        }
        if (n2 > 1) {
            MethodGen.sort(localVariableGenArray, 0, n2 - 1);
        }
        return localVariableGenArray;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen constantPoolGen) {
        LocalVariableGen[] localVariableGenArray = this.getLocalVariables();
        int n2 = localVariableGenArray.length;
        LocalVariable[] localVariableArray = new LocalVariable[n2];
        for (int i = 0; i < n2; ++i) {
            localVariableArray[i] = localVariableGenArray[i].getLocalVariable(constantPoolGen);
        }
        return new LocalVariableTable(constantPoolGen.addUtf8("LocalVariableTable"), 2 + localVariableArray.length * 10, localVariableArray, constantPoolGen.getConstantPool());
    }

    public LineNumberGen addLineNumber(InstructionHandle instructionHandle, int n2) {
        LineNumberGen lineNumberGen = new LineNumberGen(instructionHandle, n2);
        this.line_number_vec.add(lineNumberGen);
        return lineNumberGen;
    }

    public void removeLineNumber(LineNumberGen lineNumberGen) {
        this.line_number_vec.remove(lineNumberGen);
    }

    public void removeLineNumbers() {
        this.line_number_vec.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lineNumberGenArray = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.toArray(lineNumberGenArray);
        return lineNumberGenArray;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen constantPoolGen) {
        int n2 = this.line_number_vec.size();
        LineNumber[] lineNumberArray = new LineNumber[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                lineNumberArray[i] = ((LineNumberGen)this.line_number_vec.get(i)).getLineNumber();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new LineNumberTable(constantPoolGen.addUtf8("LineNumberTable"), 2 + lineNumberArray.length * 4, lineNumberArray, constantPoolGen.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, ObjectType objectType) {
        if (instructionHandle == null || instructionHandle2 == null || instructionHandle3 == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen codeExceptionGen = new CodeExceptionGen(instructionHandle, instructionHandle2, instructionHandle3, objectType);
        this.exception_vec.add(codeExceptionGen);
        return codeExceptionGen;
    }

    public void removeExceptionHandler(CodeExceptionGen codeExceptionGen) {
        this.exception_vec.remove(codeExceptionGen);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] codeExceptionGenArray = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.toArray(codeExceptionGenArray);
        return codeExceptionGenArray;
    }

    private CodeException[] getCodeExceptions() {
        int n2 = this.exception_vec.size();
        CodeException[] codeExceptionArray = new CodeException[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                CodeExceptionGen codeExceptionGen = (CodeExceptionGen)this.exception_vec.get(i);
                codeExceptionArray[i] = codeExceptionGen.getCodeException(this.cp);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return codeExceptionArray;
    }

    public void addException(String string2) {
        this.throws_vec.add(string2);
    }

    public void removeException(String string2) {
        this.throws_vec.remove(string2);
    }

    public void removeExceptions() {
        this.throws_vec.clear();
    }

    public String[] getExceptions() {
        String[] stringArray = new String[this.throws_vec.size()];
        this.throws_vec.toArray(stringArray);
        return stringArray;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen constantPoolGen) {
        int n2 = this.throws_vec.size();
        int[] nArray = new int[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = constantPoolGen.addClass((String)this.throws_vec.get(i));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new ExceptionTable(constantPoolGen.addUtf8("Exceptions"), 2 + 2 * n2, nArray, constantPoolGen.getConstantPool());
    }

    public void addCodeAttribute(Attribute attribute2) {
        this.code_attrs_vec.add(attribute2);
    }

    public void removeCodeAttribute(Attribute attribute2) {
        this.code_attrs_vec.remove(attribute2);
    }

    public void removeCodeAttributes() {
        this.code_attrs_vec.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributeArray = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.toArray(attributeArray);
        return attributeArray;
    }

    public Method getMethod() {
        Object object2;
        String string2 = this.getSignature();
        int n2 = this.cp.addUtf8(this.name);
        int n3 = this.cp.addUtf8(string2);
        byte[] byArray = null;
        if (this.il != null) {
            byArray = this.il.getByteCode();
        }
        LineNumberTable lineNumberTable = null;
        LocalVariableTable localVariableTable = null;
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            localVariableTable = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(localVariableTable);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            lineNumberTable = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lineNumberTable);
        }
        Attribute[] attributeArray = this.getCodeAttributes();
        int n4 = 0;
        for (int i = 0; i < attributeArray.length; ++i) {
            n4 += attributeArray[i].getLength() + 6;
        }
        CodeException[] codeExceptionArray = this.getCodeExceptions();
        int n5 = codeExceptionArray.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract()) {
            object2 = this.getAttributes();
            for (int i = 0; i < ((Attribute[])object2).length; ++i) {
                Attribute attribute2 = object2[i];
                if (!(attribute2 instanceof Code)) continue;
                this.removeAttribute(attribute2);
            }
            code = new Code(this.cp.addUtf8("Code"), 8 + byArray.length + 2 + n5 + 2 + n4, this.max_stack, this.max_locals, byArray, codeExceptionArray, attributeArray, this.cp.getConstantPool());
            this.addAttribute(code);
        }
        object2 = null;
        if (this.throws_vec.size() > 0) {
            object2 = this.getExceptionTable(this.cp);
            this.addAttribute((Attribute)object2);
        }
        Method method = new Method(this.access_flags, n2, n3, this.getAttributes(), this.cp.getConstantPool());
        if (localVariableTable != null) {
            this.removeCodeAttribute(localVariableTable);
        }
        if (lineNumberTable != null) {
            this.removeCodeAttribute(lineNumberTable);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (object2 != null) {
            this.removeAttribute((Attribute)object2);
        }
        return method;
    }

    public void removeNOPs() {
        if (this.il != null) {
            InstructionHandle instructionHandle = this.il.getStart();
            while (instructionHandle != null) {
                InstructionHandle instructionHandle2 = instructionHandle.next;
                if (instructionHandle2 != null && instructionHandle.getInstruction() instanceof NOP) {
                    try {
                        this.il.delete(instructionHandle);
                    }
                    catch (TargetLostException targetLostException) {
                        InstructionHandle[] instructionHandleArray = targetLostException.getTargets();
                        for (int i = 0; i < instructionHandleArray.length; ++i) {
                            InstructionTargeter[] instructionTargeterArray = instructionHandleArray[i].getTargeters();
                            for (int j = 0; j < instructionTargeterArray.length; ++j) {
                                instructionTargeterArray[j].updateTarget(instructionHandleArray[i], instructionHandle2);
                            }
                        }
                    }
                }
                instructionHandle = instructionHandle2;
            }
        }
    }

    public void setMaxLocals(int n2) {
        this.max_locals = n2;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int n2) {
        this.max_stack = n2;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String string2) {
        this.class_name = string2;
    }

    public void setReturnType(Type type2) {
        this.setType(type2);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] typeArray) {
        this.arg_types = typeArray;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(int n2, Type type2) {
        this.arg_types[n2] = type2;
    }

    public Type getArgumentType(int n2) {
        return this.arg_types[n2];
    }

    public void setArgumentNames(String[] stringArray) {
        this.arg_names = stringArray;
    }

    public String[] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(int n2, String string2) {
        this.arg_names[n2] = string2;
    }

    public String getArgumentName(int n2) {
        return this.arg_names[n2];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList instructionList) {
        this.il = instructionList;
    }

    @Override
    public String getSignature() {
        return Type.getMethodSignature(this.type, this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int n2;
            int n3 = n2 = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                for (int i = 0; i < this.arg_types.length; ++i) {
                    n2 += this.arg_types[i].getSize();
                }
            }
            for (InstructionHandle instructionHandle = this.il.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                int n4;
                Instruction instruction2 = instructionHandle.getInstruction();
                if (!(instruction2 instanceof LocalVariableInstruction) && !(instruction2 instanceof RET) && !(instruction2 instanceof IINC) || (n4 = ((IndexedInstruction)((Object)instruction2)).getIndex() + ((TypedInstruction)((Object)instruction2)).getType(this.cp).getSize()) <= n2) continue;
                n2 = n4;
            }
            this.max_locals = n2;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripAttributes(boolean bl) {
        this.strip_attributes = bl;
    }

    public static int getMaxStack(ConstantPoolGen constantPoolGen, InstructionList instructionList, CodeExceptionGen[] codeExceptionGenArray) {
        int n2;
        BranchStack branchStack = new BranchStack();
        for (n2 = 0; n2 < codeExceptionGenArray.length; ++n2) {
            InstructionHandle instructionHandle = codeExceptionGenArray[n2].getHandlerPC();
            if (instructionHandle == null) continue;
            branchStack.push(instructionHandle, 1);
        }
        n2 = 0;
        int n3 = 0;
        InstructionHandle instructionHandle = instructionList.getStart();
        while (instructionHandle != null) {
            Object object2;
            Instruction instruction2 = instructionHandle.getInstruction();
            short s = instruction2.getOpcode();
            int n4 = instruction2.produceStack(constantPoolGen) - instruction2.consumeStack(constantPoolGen);
            if ((n2 += n4) > n3) {
                n3 = n2;
            }
            if (instruction2 instanceof BranchInstruction) {
                object2 = (BranchInstruction)instruction2;
                if (instruction2 instanceof Select) {
                    Select select2 = (Select)object2;
                    InstructionHandle[] instructionHandleArray = select2.getTargets();
                    for (int i = 0; i < instructionHandleArray.length; ++i) {
                        branchStack.push(instructionHandleArray[i], n2);
                    }
                    instructionHandle = null;
                } else if (!(object2 instanceof IfInstruction)) {
                    if (s == 168 || s == 201) {
                        branchStack.push(instructionHandle.getNext(), n2 - 1);
                    }
                    instructionHandle = null;
                }
                branchStack.push(((BranchInstruction)object2).getTarget(), n2);
            } else if (s == 191 || s == 169 || s >= 172 && s <= 177) {
                instructionHandle = null;
            }
            if (instructionHandle != null) {
                instructionHandle = instructionHandle.getNext();
            }
            if (instructionHandle != null || (object2 = branchStack.pop()) == null) continue;
            instructionHandle = ((BranchTarget)object2).target;
            n2 = ((BranchTarget)object2).stackDepth;
        }
        return n3;
    }

    public void addObserver(MethodObserver methodObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(methodObserver);
    }

    public void removeObserver(MethodObserver methodObserver) {
        if (this.observers != null) {
            this.observers.remove(methodObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator iterator = this.observers.iterator();
            while (iterator.hasNext()) {
                ((MethodObserver)iterator.next()).notify(this);
            }
        }
    }

    public final String toString() {
        String string2 = Utility.accessToString(this.access_flags);
        String string3 = Type.getMethodSignature(this.type, this.arg_types);
        string3 = Utility.methodSignatureToString(string3, this.name, string2, true, this.getLocalVariableTable(this.cp));
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (this.throws_vec.size() > 0) {
            Iterator iterator = this.throws_vec.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n\t\tthrows " + iterator.next());
            }
        }
        return stringBuffer.toString();
    }

    public MethodGen copy(String string2, ConstantPoolGen constantPoolGen) {
        Method method = ((MethodGen)this.clone()).getMethod();
        MethodGen methodGen = new MethodGen(method, string2, this.cp);
        if (this.cp != constantPoolGen) {
            methodGen.setConstantPool(constantPoolGen);
            methodGen.getInstructionList().replaceConstantPool(this.cp, constantPoolGen);
        }
        return methodGen;
    }

    static final class BranchStack {
        Stack branchTargets = new Stack();
        Hashtable visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(InstructionHandle instructionHandle, int n2) {
            if (this.visited(instructionHandle)) {
                return;
            }
            this.branchTargets.push(this.visit(instructionHandle, n2));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget branchTarget = (BranchTarget)this.branchTargets.pop();
                return branchTarget;
            }
            return null;
        }

        private final BranchTarget visit(InstructionHandle instructionHandle, int n2) {
            BranchTarget branchTarget = new BranchTarget(instructionHandle, n2);
            this.visitedTargets.put(instructionHandle, branchTarget);
            return branchTarget;
        }

        private final boolean visited(InstructionHandle instructionHandle) {
            return this.visitedTargets.get(instructionHandle) != null;
        }
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle instructionHandle, int n2) {
            this.target = instructionHandle;
            this.stackDepth = n2;
        }
    }
}

