/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.ExceptionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.AllocationInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CPInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ExceptionThrower;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LoadClass;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class MULTIANEWARRAY
extends CPInstruction
implements LoadClass,
AllocationInstruction,
ExceptionThrower {
    private short dimensions;

    MULTIANEWARRAY() {
    }

    public MULTIANEWARRAY(int n2, short s) {
        super((short)197, n2);
        if (s < 1) {
            throw new ClassGenException("Invalid dimensions value: " + s);
        }
        this.dimensions = s;
        this.length = (short)4;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
        dataOutputStream.writeByte(this.dimensions);
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        super.initFromFile(byteSequence, bl);
        this.dimensions = byteSequence.readByte();
        this.length = (short)4;
    }

    public final short getDimensions() {
        return this.dimensions;
    }

    @Override
    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index + " " + this.dimensions;
    }

    @Override
    public String toString(ConstantPool constantPool) {
        return super.toString(constantPool) + " " + this.dimensions;
    }

    @Override
    public int consumeStack(ConstantPoolGen constantPoolGen) {
        return this.dimensions;
    }

    @Override
    public Class[] getExceptions() {
        Class[] classArray = new Class[2 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, classArray, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length + 1] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        return classArray;
    }

    @Override
    public ObjectType getLoadClassType(ConstantPoolGen constantPoolGen) {
        Type type2 = this.getType(constantPoolGen);
        if (type2 instanceof ArrayType) {
            type2 = ((ArrayType)type2).getBasicType();
        }
        return type2 instanceof ObjectType ? (ObjectType)type2 : null;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLoadClass(this);
        visitor.visitAllocationInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitMULTIANEWARRAY(this);
    }
}

