/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionTargeter;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NamedAndTyped;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.io.Serializable;

public class LocalVariableGen
implements InstructionTargeter,
NamedAndTyped,
Cloneable,
Serializable {
    private int index;
    private String name;
    private Type type;
    private InstructionHandle start;
    private InstructionHandle end;

    public LocalVariableGen(int n2, String string2, Type type2, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (n2 < 0 || n2 > 65535) {
            throw new ClassGenException("Invalid index index: " + n2);
        }
        this.name = string2;
        this.type = type2;
        this.index = n2;
        this.setStart(instructionHandle);
        this.setEnd(instructionHandle2);
    }

    public LocalVariable getLocalVariable(ConstantPoolGen constantPoolGen) {
        int n2 = this.start.getPosition();
        int n3 = this.end.getPosition() - n2;
        if (n3 > 0) {
            n3 += this.end.getInstruction().getLength();
        }
        int n4 = constantPoolGen.addUtf8(this.name);
        int n5 = constantPoolGen.addUtf8(this.type.getSignature());
        return new LocalVariable(n2, n3, n4, n5, this.index, constantPoolGen.getConstantPool());
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void setName(String string2) {
        this.name = string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(Type type2) {
        this.type = type2;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public void setStart(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.start, instructionHandle, this);
        this.start = instructionHandle;
    }

    public void setEnd(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.end, instructionHandle, this);
        this.end = instructionHandle;
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.start == instructionHandle) {
            bl = true;
            this.setStart(instructionHandle2);
        }
        if (this.end == instructionHandle) {
            bl = true;
            this.setEnd(instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but {" + this.start + ", " + this.end + "}");
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.start == instructionHandle || this.end == instructionHandle;
    }

    public boolean equals(Object object2) {
        if (!(object2 instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen localVariableGen = (LocalVariableGen)object2;
        return localVariableGen.index == this.index && localVariableGen.start == this.start && localVariableGen.end == this.end;
    }

    public String toString() {
        return "LocalVariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }
}

