/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionTargeter;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class InstructionHandle
implements Serializable {
    InstructionHandle next;
    InstructionHandle prev;
    Instruction instruction;
    protected int i_position = -1;
    private HashSet targeters;
    private HashMap attributes;
    private static InstructionHandle ih_list = null;

    public final InstructionHandle getNext() {
        return this.next;
    }

    public final InstructionHandle getPrev() {
        return this.prev;
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction2) {
        if (instruction2 == null) {
            throw new ClassGenException("Assigning null to handle");
        }
        if (this.getClass() != BranchHandle.class && instruction2 instanceof BranchInstruction) {
            throw new ClassGenException("Assigning branch instruction " + instruction2 + " to plain handle");
        }
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = instruction2;
    }

    public Instruction swapInstruction(Instruction instruction2) {
        Instruction instruction3 = this.instruction;
        this.instruction = instruction2;
        return instruction3;
    }

    protected InstructionHandle(Instruction instruction2) {
        this.setInstruction(instruction2);
    }

    static final InstructionHandle getInstructionHandle(Instruction instruction2) {
        if (ih_list == null) {
            return new InstructionHandle(instruction2);
        }
        InstructionHandle instructionHandle = ih_list;
        ih_list = instructionHandle.next;
        instructionHandle.setInstruction(instruction2);
        return instructionHandle;
    }

    protected int updatePosition(int n2, int n3) {
        this.i_position += n2;
        return 0;
    }

    public int getPosition() {
        return this.i_position;
    }

    void setPosition(int n2) {
        this.i_position = n2;
    }

    protected void addHandle() {
        this.next = ih_list;
        ih_list = this;
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.attributes = null;
        this.removeAllTargeters();
        this.addHandle();
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.clear();
        }
    }

    public void removeTargeter(InstructionTargeter instructionTargeter) {
        this.targeters.remove(instructionTargeter);
    }

    public void addTargeter(InstructionTargeter instructionTargeter) {
        if (this.targeters == null) {
            this.targeters = new HashSet();
        }
        this.targeters.add(instructionTargeter);
    }

    public boolean hasTargeters() {
        return this.targeters != null && this.targeters.size() > 0;
    }

    public InstructionTargeter[] getTargeters() {
        if (!this.hasTargeters()) {
            return null;
        }
        InstructionTargeter[] instructionTargeterArray = new InstructionTargeter[this.targeters.size()];
        this.targeters.toArray(instructionTargeterArray);
        return instructionTargeterArray;
    }

    public String toString(boolean bl) {
        return Utility.format(this.i_position, 4, false, ' ') + ": " + this.instruction.toString(bl);
    }

    public String toString() {
        return this.toString(true);
    }

    public void addAttribute(Object object2, Object object3) {
        if (this.attributes == null) {
            this.attributes = new HashMap(3);
        }
        this.attributes.put(object2, object3);
    }

    public void removeAttribute(Object object2) {
        if (this.attributes != null) {
            this.attributes.remove(object2);
        }
    }

    public Object getAttribute(Object object2) {
        if (this.attributes != null) {
            return this.attributes.get(object2);
        }
        return null;
    }

    public Collection getAttributes() {
        return this.attributes.values();
    }

    public void accept(Visitor visitor) {
        this.instruction.accept(visitor);
    }
}

