/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.ALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArithmeticInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BasicType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CHECKCAST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GETFIELD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GETSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GOTO;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GOTO_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFGE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFGT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFLE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFLT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNONNULL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNULL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ACMPEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ACMPNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPGE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPGT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPLE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPLT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ILOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INSTANCEOF;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEINTERFACE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ISTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InvokeInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JSR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JSR_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MULTIANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEW;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUSH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUTFIELD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUTSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.StackInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.io.Serializable;

public class InstructionFactory
implements InstructionConstants,
Serializable {
    protected ClassGen cg;
    protected ConstantPoolGen cp;
    private static MethodObject[] append_mos = new MethodObject[]{new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.OBJECT}, 1), null, null, new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.BOOLEAN}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.CHAR}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.FLOAT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.DOUBLE}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.LONG}, 1)};

    public InstructionFactory(ClassGen classGen, ConstantPoolGen constantPoolGen) {
        this.cg = classGen;
        this.cp = constantPoolGen;
    }

    public InstructionFactory(ClassGen classGen) {
        this(classGen, classGen.getConstantPool());
    }

    public InstructionFactory(ConstantPoolGen constantPoolGen) {
        this(null, constantPoolGen);
    }

    public InvokeInstruction createInvoke(String string2, String string3, Type type2, Type[] typeArray, short s) {
        int n2 = 0;
        String string4 = Type.getMethodSignature(type2, typeArray);
        for (int i = 0; i < typeArray.length; ++i) {
            n2 += typeArray[i].getSize();
        }
        int n3 = s == 185 ? this.cp.addInterfaceMethodref(string2, string3, string4) : this.cp.addMethodref(string2, string3, string4);
        switch (s) {
            case 183: {
                return new INVOKESPECIAL(n3);
            }
            case 182: {
                return new INVOKEVIRTUAL(n3);
            }
            case 184: {
                return new INVOKESTATIC(n3);
            }
            case 185: {
                return new INVOKEINTERFACE(n3, n2 + 1);
            }
        }
        throw new RuntimeException("Oops: Unknown invoke kind:" + s);
    }

    public InstructionList createPrintln(String string2) {
        InstructionList instructionList = new InstructionList();
        int n2 = this.cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
        int n3 = this.cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
        instructionList.append(new GETSTATIC(n2));
        instructionList.append(new PUSH(this.cp, string2));
        instructionList.append(new INVOKEVIRTUAL(n3));
        return instructionList;
    }

    public Instruction createConstant(Object object2) {
        PUSH pUSH;
        if (object2 instanceof Number) {
            pUSH = new PUSH(this.cp, (Number)object2);
        } else if (object2 instanceof String) {
            pUSH = new PUSH(this.cp, (String)object2);
        } else if (object2 instanceof Boolean) {
            pUSH = new PUSH(this.cp, (Boolean)object2);
        } else if (object2 instanceof Character) {
            pUSH = new PUSH(this.cp, (Character)object2);
        } else {
            throw new ClassGenException("Illegal type: " + object2.getClass());
        }
        return pUSH.getInstruction();
    }

    private InvokeInstruction createInvoke(MethodObject methodObject, short s) {
        return this.createInvoke(methodObject.class_name, methodObject.name, methodObject.result_type, methodObject.arg_types, s);
    }

    private static final boolean isString(Type type2) {
        return type2 instanceof ObjectType && ((ObjectType)type2).getClassName().equals("java.lang.String");
    }

    public Instruction createAppend(Type type2) {
        byte by2 = type2.getType();
        if (InstructionFactory.isString(type2)) {
            return this.createInvoke(append_mos[0], (short)182);
        }
        switch (by2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createInvoke(append_mos[by2], (short)182);
            }
            case 13: 
            case 14: {
                return this.createInvoke(append_mos[1], (short)182);
            }
        }
        throw new RuntimeException("Oops: No append for this type? " + type2);
    }

    public FieldInstruction createFieldAccess(String string2, String string3, Type type2, short s) {
        String string4 = type2.getSignature();
        int n2 = this.cp.addFieldref(string2, string3, string4);
        switch (s) {
            case 180: {
                return new GETFIELD(n2);
            }
            case 181: {
                return new PUTFIELD(n2);
            }
            case 178: {
                return new GETSTATIC(n2);
            }
            case 179: {
                return new PUTSTATIC(n2);
            }
        }
        throw new RuntimeException("Oops: Unknown getfield kind:" + s);
    }

    public static Instruction createThis() {
        return new ALOAD(0);
    }

    public static ReturnInstruction createReturn(Type type2) {
        switch (type2.getType()) {
            case 13: 
            case 14: {
                return ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return IRETURN;
            }
            case 6: {
                return FRETURN;
            }
            case 7: {
                return DRETURN;
            }
            case 11: {
                return LRETURN;
            }
            case 12: {
                return RETURN;
            }
        }
        throw new RuntimeException("Invalid type: " + type2);
    }

    private static final ArithmeticInstruction createBinaryIntOp(char c, String string2) {
        switch (c) {
            case '-': {
                return ISUB;
            }
            case '+': {
                return IADD;
            }
            case '%': {
                return IREM;
            }
            case '*': {
                return IMUL;
            }
            case '/': {
                return IDIV;
            }
            case '&': {
                return IAND;
            }
            case '|': {
                return IOR;
            }
            case '^': {
                return IXOR;
            }
            case '<': {
                return ISHL;
            }
            case '>': {
                return string2.equals(">>>") ? IUSHR : ISHR;
            }
        }
        throw new RuntimeException("Invalid operand " + string2);
    }

    private static final ArithmeticInstruction createBinaryLongOp(char c, String string2) {
        switch (c) {
            case '-': {
                return LSUB;
            }
            case '+': {
                return LADD;
            }
            case '%': {
                return LREM;
            }
            case '*': {
                return LMUL;
            }
            case '/': {
                return LDIV;
            }
            case '&': {
                return LAND;
            }
            case '|': {
                return LOR;
            }
            case '^': {
                return LXOR;
            }
            case '<': {
                return LSHL;
            }
            case '>': {
                return string2.equals(">>>") ? LUSHR : LSHR;
            }
        }
        throw new RuntimeException("Invalid operand " + string2);
    }

    private static final ArithmeticInstruction createBinaryFloatOp(char c) {
        switch (c) {
            case '-': {
                return FSUB;
            }
            case '+': {
                return FADD;
            }
            case '*': {
                return FMUL;
            }
            case '/': {
                return FDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + c);
    }

    private static final ArithmeticInstruction createBinaryDoubleOp(char c) {
        switch (c) {
            case '-': {
                return DSUB;
            }
            case '+': {
                return DADD;
            }
            case '*': {
                return DMUL;
            }
            case '/': {
                return DDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + c);
    }

    public static ArithmeticInstruction createBinaryOperation(String string2, Type type2) {
        char c = string2.toCharArray()[0];
        switch (type2.getType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionFactory.createBinaryIntOp(c, string2);
            }
            case 11: {
                return InstructionFactory.createBinaryLongOp(c, string2);
            }
            case 6: {
                return InstructionFactory.createBinaryFloatOp(c);
            }
            case 7: {
                return InstructionFactory.createBinaryDoubleOp(c);
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public static StackInstruction createPop(int n2) {
        return n2 == 2 ? POP2 : POP;
    }

    public static StackInstruction createDup(int n2) {
        return n2 == 2 ? DUP2 : DUP;
    }

    public static StackInstruction createDup_2(int n2) {
        return n2 == 2 ? DUP2_X2 : DUP_X2;
    }

    public static StackInstruction createDup_1(int n2) {
        return n2 == 2 ? DUP2_X1 : DUP_X1;
    }

    public static LocalVariableInstruction createStore(Type type2, int n2) {
        switch (type2.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ISTORE(n2);
            }
            case 6: {
                return new FSTORE(n2);
            }
            case 7: {
                return new DSTORE(n2);
            }
            case 11: {
                return new LSTORE(n2);
            }
            case 13: 
            case 14: {
                return new ASTORE(n2);
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public static LocalVariableInstruction createLoad(Type type2, int n2) {
        switch (type2.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ILOAD(n2);
            }
            case 6: {
                return new FLOAD(n2);
            }
            case 7: {
                return new DLOAD(n2);
            }
            case 11: {
                return new LLOAD(n2);
            }
            case 13: 
            case 14: {
                return new ALOAD(n2);
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public static ArrayInstruction createArrayLoad(Type type2) {
        switch (type2.getType()) {
            case 4: 
            case 8: {
                return BALOAD;
            }
            case 5: {
                return CALOAD;
            }
            case 9: {
                return SALOAD;
            }
            case 10: {
                return IALOAD;
            }
            case 6: {
                return FALOAD;
            }
            case 7: {
                return DALOAD;
            }
            case 11: {
                return LALOAD;
            }
            case 13: 
            case 14: {
                return AALOAD;
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public static ArrayInstruction createArrayStore(Type type2) {
        switch (type2.getType()) {
            case 4: 
            case 8: {
                return BASTORE;
            }
            case 5: {
                return CASTORE;
            }
            case 9: {
                return SASTORE;
            }
            case 10: {
                return IASTORE;
            }
            case 6: {
                return FASTORE;
            }
            case 7: {
                return DASTORE;
            }
            case 11: {
                return LASTORE;
            }
            case 13: 
            case 14: {
                return AASTORE;
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public Instruction createCast(Type type2, Type type3) {
        if (type2 instanceof BasicType && type3 instanceof BasicType) {
            byte by2 = type3.getType();
            int n2 = type2.getType();
            if (by2 == 11 && (n2 == 5 || n2 == 8 || n2 == 9)) {
                n2 = 10;
            }
            String[] stringArray = new String[]{"C", "F", "D", "B", "S", "I", "L"};
            String string2 = "com.ibm.xltxe.rnm1.xtq.bcel.generic." + stringArray[n2 - 5] + "2" + stringArray[by2 - 5];
            Instruction instruction2 = null;
            try {
                instruction2 = (Instruction)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not find instruction: " + string2);
            }
            return instruction2;
        }
        if (type2 instanceof ReferenceType && type3 instanceof ReferenceType) {
            if (type3 instanceof ArrayType) {
                return new CHECKCAST(this.cp.addArrayClass((ArrayType)type3));
            }
            return new CHECKCAST(this.cp.addClass(((ObjectType)type3).getClassName()));
        }
        throw new RuntimeException("Can not cast " + type2 + " to " + type3);
    }

    public GETFIELD createGetField(String string2, String string3, Type type2) {
        return new GETFIELD(this.cp.addFieldref(string2, string3, type2.getSignature()));
    }

    public GETSTATIC createGetStatic(String string2, String string3, Type type2) {
        return new GETSTATIC(this.cp.addFieldref(string2, string3, type2.getSignature()));
    }

    public PUTFIELD createPutField(String string2, String string3, Type type2) {
        return new PUTFIELD(this.cp.addFieldref(string2, string3, type2.getSignature()));
    }

    public PUTSTATIC createPutStatic(String string2, String string3, Type type2) {
        return new PUTSTATIC(this.cp.addFieldref(string2, string3, type2.getSignature()));
    }

    public CHECKCAST createCheckCast(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)referenceType));
        }
        return new CHECKCAST(this.cp.addClass((ObjectType)referenceType));
    }

    public INSTANCEOF createInstanceOf(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            return new INSTANCEOF(this.cp.addArrayClass((ArrayType)referenceType));
        }
        return new INSTANCEOF(this.cp.addClass((ObjectType)referenceType));
    }

    public NEW createNew(ObjectType objectType) {
        return new NEW(this.cp.addClass(objectType));
    }

    public NEW createNew(String string2) {
        return this.createNew(new ObjectType(string2));
    }

    public Instruction createNewArray(Type type2, short s) {
        if (s == 1) {
            if (type2 instanceof ObjectType) {
                return new ANEWARRAY(this.cp.addClass((ObjectType)type2));
            }
            if (type2 instanceof ArrayType) {
                return new ANEWARRAY(this.cp.addArrayClass((ArrayType)type2));
            }
            return new NEWARRAY(((BasicType)type2).getType());
        }
        ArrayType arrayType = type2 instanceof ArrayType ? (ArrayType)type2 : new ArrayType(type2, (int)s);
        return new MULTIANEWARRAY(this.cp.addArrayClass(arrayType), s);
    }

    public static Instruction createNull(Type type2) {
        switch (type2.getType()) {
            case 13: 
            case 14: {
                return ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return ICONST_0;
            }
            case 6: {
                return FCONST_0;
            }
            case 7: {
                return DCONST_0;
            }
            case 11: {
                return LCONST_0;
            }
            case 12: {
                return NOP;
            }
        }
        throw new RuntimeException("Invalid type: " + type2);
    }

    public static BranchInstruction createBranchInstruction(short s, InstructionHandle instructionHandle) {
        switch (s) {
            case 153: {
                return new IFEQ(instructionHandle);
            }
            case 154: {
                return new IFNE(instructionHandle);
            }
            case 155: {
                return new IFLT(instructionHandle);
            }
            case 156: {
                return new IFGE(instructionHandle);
            }
            case 157: {
                return new IFGT(instructionHandle);
            }
            case 158: {
                return new IFLE(instructionHandle);
            }
            case 159: {
                return new IF_ICMPEQ(instructionHandle);
            }
            case 160: {
                return new IF_ICMPNE(instructionHandle);
            }
            case 161: {
                return new IF_ICMPLT(instructionHandle);
            }
            case 162: {
                return new IF_ICMPGE(instructionHandle);
            }
            case 163: {
                return new IF_ICMPGT(instructionHandle);
            }
            case 164: {
                return new IF_ICMPLE(instructionHandle);
            }
            case 165: {
                return new IF_ACMPEQ(instructionHandle);
            }
            case 166: {
                return new IF_ACMPNE(instructionHandle);
            }
            case 167: {
                return new GOTO(instructionHandle);
            }
            case 168: {
                return new JSR(instructionHandle);
            }
            case 198: {
                return new IFNULL(instructionHandle);
            }
            case 199: {
                return new IFNONNULL(instructionHandle);
            }
            case 200: {
                return new GOTO_W(instructionHandle);
            }
            case 201: {
                return new JSR_W(instructionHandle);
            }
        }
        throw new RuntimeException("Invalid opcode: " + s);
    }

    public void setClassGen(ClassGen classGen) {
        this.cg = classGen;
    }

    public ClassGen getClassGen() {
        return this.cg;
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    private static class MethodObject {
        Type[] arg_types;
        Type result_type;
        String[] arg_names;
        String class_name;
        String name;
        int access;

        MethodObject(String string2, String string3, Type type2, Type[] typeArray, int n2) {
            this.class_name = string2;
            this.name = string3;
            this.result_type = type2;
            this.arg_types = typeArray;
            this.access = n2;
        }
    }
}

