/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionComparator;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class Instruction
implements Cloneable,
Serializable {
    protected short length = 1;
    protected short opcode = (short)-1;
    private static InstructionComparator cmp = InstructionComparator.DEFAULT;

    Instruction() {
    }

    public Instruction(short s, short s2) {
        this.length = s2;
        this.opcode = s;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
    }

    public String getName() {
        return Constants.OPCODE_NAMES[this.opcode];
    }

    public String toString(boolean bl) {
        if (bl) {
            return this.getName() + "[" + this.opcode + "](" + this.length + ")";
        }
        return this.getName();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(ConstantPool constantPool) {
        return this.toString(false);
    }

    public Instruction copy() {
        Instruction instruction2 = null;
        if (InstructionConstants.INSTRUCTIONS[this.getOpcode()] != null) {
            instruction2 = this;
        } else {
            try {
                instruction2 = (Instruction)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.err.println(cloneNotSupportedException);
            }
        }
        return instruction2;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
    }

    public static final Instruction readInstruction(ByteSequence byteSequence) throws IOException {
        Class<?> clazz;
        boolean bl = false;
        short s = (short)byteSequence.readUnsignedByte();
        Instruction instruction2 = null;
        if (s == 196) {
            bl = true;
            s = (short)byteSequence.readUnsignedByte();
        }
        if (InstructionConstants.INSTRUCTIONS[s] != null) {
            return InstructionConstants.INSTRUCTIONS[s];
        }
        try {
            clazz = Class.forName(Instruction.className(s));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassGenException("Illegal opcode detected.");
        }
        try {
            instruction2 = (Instruction)clazz.newInstance();
            if (bl && !(instruction2 instanceof LocalVariableInstruction) && !(instruction2 instanceof IINC) && !(instruction2 instanceof RET)) {
                throw new Exception("Illegal opcode after wide: " + s);
            }
            instruction2.setOpcode(s);
            instruction2.initFromFile(byteSequence, bl);
        }
        catch (Exception exception) {
            throw new ClassGenException(exception.toString());
        }
        return instruction2;
    }

    private static final String className(short s) {
        String string2 = Constants.OPCODE_NAMES[s].toUpperCase();
        try {
            int n2 = string2.length();
            char c = string2.charAt(n2 - 2);
            char c2 = string2.charAt(n2 - 1);
            if (c == '_' && c2 >= '0' && c2 <= '5') {
                string2 = string2.substring(0, n2 - 2);
            }
            if (string2.equals("ICONST_M1")) {
                string2 = "ICONST";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
        }
        return "com.ibm.xltxe.rnm1.xtq.bcel.generic." + string2;
    }

    public int consumeStack(ConstantPoolGen constantPoolGen) {
        return Constants.CONSUME_STACK[this.opcode];
    }

    public int produceStack(ConstantPoolGen constantPoolGen) {
        return Constants.PRODUCE_STACK[this.opcode];
    }

    public short getOpcode() {
        return this.opcode;
    }

    public int getLength() {
        return this.length;
    }

    private void setOpcode(short s) {
        this.opcode = s;
    }

    void dispose() {
    }

    public abstract void accept(Visitor var1);

    public static InstructionComparator getComparator() {
        return cmp;
    }

    public static void setComparator(InstructionComparator instructionComparator) {
        cmp = instructionComparator;
    }

    public boolean equals(Object object2) {
        return object2 instanceof Instruction ? cmp.equals(this, (Instruction)object2) : false;
    }
}

