/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPushInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TypedInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;

public class DCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private double value;

    DCONST() {
    }

    public DCONST(double d) {
        super((short)14, (short)1);
        if (d == 0.0) {
            this.opcode = (short)14;
        } else if (d == 1.0) {
            this.opcode = (short)15;
        } else {
            throw new ClassGenException("DCONST can be used only for 0.0 and 1.0: " + d);
        }
        this.value = d;
    }

    @Override
    public Number getValue() {
        return new Double(this.value);
    }

    @Override
    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.DOUBLE;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitPushInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitTypedInstruction(this);
        visitor.visitConstantPushInstruction(this);
        visitor.visitDCONST(this);
    }
}

