/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantCP;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInterfaceMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantLong;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import java.io.Serializable;
import java.util.HashMap;

public class ConstantPoolGen
implements Serializable {
    protected int size = 1024;
    protected Constant[] constants = new Constant[this.size];
    protected int index = 1;
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    private HashMap string_table = new HashMap();
    private HashMap class_table = new HashMap();
    private HashMap utf8_table = new HashMap();
    private HashMap n_a_t_table = new HashMap();
    private HashMap cp_table = new HashMap();

    public ConstantPoolGen(Constant[] constantArray) {
        if (constantArray.length > this.size) {
            this.size = constantArray.length;
            this.constants = new Constant[this.size];
        }
        System.arraycopy(constantArray, 0, this.constants, 0, constantArray.length);
        if (constantArray.length > 0) {
            this.index = constantArray.length;
        }
        for (int i = 1; i < this.index; ++i) {
            Constant constant;
            Constant constant2;
            Constant constant3;
            Constant constant4 = this.constants[i];
            if (constant4 instanceof ConstantString) {
                constant3 = (ConstantString)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantString)constant3).getStringIndex()];
                this.string_table.put(((ConstantUtf8)constant2).getBytes(), new Index(i));
                continue;
            }
            if (constant4 instanceof ConstantClass) {
                constant3 = (ConstantClass)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantClass)constant3).getNameIndex()];
                this.class_table.put(((ConstantUtf8)constant2).getBytes(), new Index(i));
                continue;
            }
            if (constant4 instanceof ConstantNameAndType) {
                constant3 = (ConstantNameAndType)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant3).getNameIndex()];
                constant = (ConstantUtf8)this.constants[((ConstantNameAndType)constant3).getSignatureIndex()];
                this.n_a_t_table.put(((ConstantUtf8)constant2).getBytes() + NAT_DELIM + ((ConstantUtf8)constant).getBytes(), new Index(i));
                continue;
            }
            if (constant4 instanceof ConstantUtf8) {
                constant3 = (ConstantUtf8)constant4;
                this.utf8_table.put(((ConstantUtf8)constant3).getBytes(), new Index(i));
                continue;
            }
            if (!(constant4 instanceof ConstantCP)) continue;
            constant3 = (ConstantCP)constant4;
            constant2 = (ConstantClass)this.constants[((ConstantCP)constant3).getClassIndex()];
            constant = (ConstantNameAndType)this.constants[((ConstantCP)constant3).getNameAndTypeIndex()];
            ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constants[((ConstantClass)constant2).getNameIndex()];
            String string2 = constantUtf8.getBytes().replace('/', '.');
            constantUtf8 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getNameIndex()];
            String string3 = constantUtf8.getBytes();
            constantUtf8 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getSignatureIndex()];
            String string4 = constantUtf8.getBytes();
            String string5 = METHODREF_DELIM;
            if (constant4 instanceof ConstantInterfaceMethodref) {
                string5 = IMETHODREF_DELIM;
            } else if (constant4 instanceof ConstantFieldref) {
                string5 = FIELDREF_DELIM;
            }
            this.cp_table.put(string2 + string5 + string3 + string5 + string4, new Index(i));
        }
    }

    public ConstantPoolGen(ConstantPool constantPool) {
        this(constantPool.getConstantPool());
    }

    public ConstantPoolGen() {
    }

    protected void adjustSize() {
        if (this.index + 3 >= this.size) {
            Constant[] constantArray = this.constants;
            this.size *= 2;
            this.constants = new Constant[this.size];
            System.arraycopy(constantArray, 0, this.constants, 0, this.index);
        }
    }

    public int lookupString(String string2) {
        Index index2 = (Index)this.string_table.get(string2);
        return index2 != null ? index2.index : -1;
    }

    public int addString(String string2) {
        int n2 = this.lookupString(string2);
        if (n2 != -1) {
            return n2;
        }
        int n3 = this.addUtf8(string2);
        this.adjustSize();
        ConstantString constantString = new ConstantString(n3);
        n2 = this.index;
        this.constants[this.index++] = constantString;
        this.string_table.put(string2, new Index(n2));
        return n2;
    }

    public int lookupClass(String string2) {
        Index index2 = (Index)this.class_table.get(string2.replace('.', '/'));
        return index2 != null ? index2.index : -1;
    }

    private int addClass_(String string2) {
        int n2 = this.lookupClass(string2);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        ConstantClass constantClass = new ConstantClass(this.addUtf8(string2));
        n2 = this.index;
        this.constants[this.index++] = constantClass;
        this.class_table.put(string2, new Index(n2));
        return n2;
    }

    public int addClass(String string2) {
        return this.addClass_(string2.replace('.', '/'));
    }

    public int addClass(ObjectType objectType) {
        return this.addClass(objectType.getClassName());
    }

    public int addArrayClass(ArrayType arrayType) {
        return this.addClass_(arrayType.getSignature());
    }

    public int lookupInteger(int n2) {
        for (int i = 1; i < this.index; ++i) {
            ConstantInteger constantInteger;
            if (!(this.constants[i] instanceof ConstantInteger) || (constantInteger = (ConstantInteger)this.constants[i]).getBytes() != n2) continue;
            return i;
        }
        return -1;
    }

    public int addInteger(int n2) {
        int n3 = this.lookupInteger(n2);
        if (n3 != -1) {
            return n3;
        }
        this.adjustSize();
        n3 = this.index;
        this.constants[this.index++] = new ConstantInteger(n2);
        return n3;
    }

    public int lookupFloat(float f2) {
        int n2 = Float.floatToIntBits(f2);
        for (int i = 1; i < this.index; ++i) {
            ConstantFloat constantFloat;
            if (!(this.constants[i] instanceof ConstantFloat) || Float.floatToIntBits((constantFloat = (ConstantFloat)this.constants[i]).getBytes()) != n2) continue;
            return i;
        }
        return -1;
    }

    public int addFloat(float f2) {
        int n2 = this.lookupFloat(f2);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.index;
        this.constants[this.index++] = new ConstantFloat(f2);
        return n2;
    }

    public int lookupUtf8(String string2) {
        Index index2 = (Index)this.utf8_table.get(string2);
        return index2 != null ? index2.index : -1;
    }

    public int addUtf8(String string2) {
        int n2 = this.lookupUtf8(string2);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.index;
        this.constants[this.index++] = new ConstantUtf8(string2);
        this.utf8_table.put(string2, new Index(n2));
        return n2;
    }

    public int lookupLong(long l) {
        for (int i = 1; i < this.index; ++i) {
            ConstantLong constantLong;
            if (!(this.constants[i] instanceof ConstantLong) || (constantLong = (ConstantLong)this.constants[i]).getBytes() != l) continue;
            return i;
        }
        return -1;
    }

    public int addLong(long l) {
        int n2 = this.lookupLong(l);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.index;
        this.constants[this.index] = new ConstantLong(l);
        this.index += 2;
        return n2;
    }

    public int lookupDouble(double d) {
        long l = Double.doubleToLongBits(d);
        for (int i = 1; i < this.index; ++i) {
            ConstantDouble constantDouble;
            if (!(this.constants[i] instanceof ConstantDouble) || Double.doubleToLongBits((constantDouble = (ConstantDouble)this.constants[i]).getBytes()) != l) continue;
            return i;
        }
        return -1;
    }

    public int addDouble(double d) {
        int n2 = this.lookupDouble(d);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.index;
        this.constants[this.index] = new ConstantDouble(d);
        this.index += 2;
        return n2;
    }

    public int lookupNameAndType(String string2, String string3) {
        Index index2 = (Index)this.n_a_t_table.get(string2 + NAT_DELIM + string3);
        return index2 != null ? index2.index : -1;
    }

    public int addNameAndType(String string2, String string3) {
        int n2 = this.lookupNameAndType(string2, string3);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        int n3 = this.addUtf8(string2);
        int n4 = this.addUtf8(string3);
        n2 = this.index;
        this.constants[this.index++] = new ConstantNameAndType(n3, n4);
        this.n_a_t_table.put(string2 + NAT_DELIM + string3, new Index(n2));
        return n2;
    }

    public int lookupMethodref(String string2, String string3, String string4) {
        Index index2 = (Index)this.cp_table.get(string2 + METHODREF_DELIM + string3 + METHODREF_DELIM + string4);
        return index2 != null ? index2.index : -1;
    }

    public int lookupMethodref(MethodGen methodGen) {
        return this.lookupMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addMethodref(String string2, String string3, String string4) {
        int n2 = this.lookupMethodref(string2, string3, string4);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        int n3 = this.addNameAndType(string3, string4);
        int n4 = this.addClass(string2);
        n2 = this.index;
        this.constants[this.index++] = new ConstantMethodref(n4, n3);
        this.cp_table.put(string2 + METHODREF_DELIM + string3 + METHODREF_DELIM + string4, new Index(n2));
        return n2;
    }

    public int addMethodref(MethodGen methodGen) {
        return this.addMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupInterfaceMethodref(String string2, String string3, String string4) {
        Index index2 = (Index)this.cp_table.get(string2 + IMETHODREF_DELIM + string3 + IMETHODREF_DELIM + string4);
        return index2 != null ? index2.index : -1;
    }

    public int lookupInterfaceMethodref(MethodGen methodGen) {
        return this.lookupInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addInterfaceMethodref(String string2, String string3, String string4) {
        int n2 = this.lookupInterfaceMethodref(string2, string3, string4);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        int n3 = this.addClass(string2);
        int n4 = this.addNameAndType(string3, string4);
        n2 = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(n3, n4);
        this.cp_table.put(string2 + IMETHODREF_DELIM + string3 + IMETHODREF_DELIM + string4, new Index(n2));
        return n2;
    }

    public int addInterfaceMethodref(MethodGen methodGen) {
        return this.addInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupFieldref(String string2, String string3, String string4) {
        Index index2 = (Index)this.cp_table.get(string2 + FIELDREF_DELIM + string3 + FIELDREF_DELIM + string4);
        return index2 != null ? index2.index : -1;
    }

    public int addFieldref(String string2, String string3, String string4) {
        int n2 = this.lookupFieldref(string2, string3, string4);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        int n3 = this.addClass(string2);
        int n4 = this.addNameAndType(string3, string4);
        n2 = this.index;
        this.constants[this.index++] = new ConstantFieldref(n3, n4);
        this.cp_table.put(string2 + FIELDREF_DELIM + string3 + FIELDREF_DELIM + string4, new Index(n2));
        return n2;
    }

    public Constant getConstant(int n2) {
        return this.constants[n2];
    }

    public void setConstant(int n2, Constant constant) {
        this.constants[n2] = constant;
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public int getSize() {
        return this.index;
    }

    public void rollback(int n2) {
        this.index = n2;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] constantArray = new Constant[this.index];
        System.arraycopy(this.constants, 0, constantArray, 0, this.index);
        return new ConstantPool(constantArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.index; ++i) {
            stringBuffer.append(i + ")" + this.constants[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public int addConstant(Constant constant, ConstantPoolGen constantPoolGen) {
        Constant[] constantArray = constantPoolGen.getConstantPool().getConstantPool();
        switch (constant.getTag()) {
            case 8: {
                ConstantString constantString = (ConstantString)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantString.getStringIndex()];
                return this.addString(constantUtf8.getBytes());
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                return this.addClass(constantUtf8.getBytes());
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                ConstantUtf8 constantUtf82 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                return this.addNameAndType(constantUtf8.getBytes(), constantUtf82.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)constant).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)constant).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)constant).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)constant).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)constant).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP constantCP = (ConstantCP)constant;
                ConstantClass constantClass = (ConstantClass)constantArray[constantCP.getClassIndex()];
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantArray[constantCP.getNameAndTypeIndex()];
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                String string2 = constantUtf8.getBytes().replace('/', '.');
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                String string3 = constantUtf8.getBytes();
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                String string4 = constantUtf8.getBytes();
                switch (constant.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(string2, string3, string4);
                    }
                    case 10: {
                        return this.addMethodref(string2, string3, string4);
                    }
                    case 9: {
                        return this.addFieldref(string2, string3, string4);
                    }
                }
                throw new RuntimeException("Unknown constant type " + constant);
            }
        }
        throw new RuntimeException("Unknown constant type " + constant);
    }

    private static class Index
    implements Serializable {
        int index;

        Index(int n2) {
            this.index = n2;
        }
    }
}

