/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.AccessFlags;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Field;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.SourceFile;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassObserver;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.util.ArrayList;
import java.util.Iterator;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private String class_name;
    private String super_class_name;
    private String file_name;
    private int class_name_index = -1;
    private int superclass_name_index = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPoolGen cp;
    private ArrayList field_vec = new ArrayList();
    private ArrayList method_vec = new ArrayList();
    private ArrayList attribute_vec = new ArrayList();
    private ArrayList interface_vec = new ArrayList();
    private ArrayList observers;

    public ClassGen(String string2, String string3, String string4, int n2, String[] stringArray, ConstantPoolGen constantPoolGen) {
        this.class_name = string2;
        this.super_class_name = string3;
        this.file_name = string4;
        this.access_flags = n2;
        this.cp = constantPoolGen;
        if (string4 != null) {
            this.addAttribute(new SourceFile(constantPoolGen.addUtf8("SourceFile"), 2, constantPoolGen.addUtf8(string4), constantPoolGen.getConstantPool()));
        }
        this.class_name_index = constantPoolGen.addClass(string2);
        this.superclass_name_index = constantPoolGen.addClass(string3);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addInterface(stringArray[i]);
            }
        }
    }

    public ClassGen(String string2, String string3, String string4, int n2, String[] stringArray) {
        this(string2, string3, string4, n2, stringArray, new ConstantPoolGen());
    }

    public ClassGen(JavaClass javaClass) {
        int n2;
        this.class_name_index = javaClass.getClassNameIndex();
        this.superclass_name_index = javaClass.getSuperclassNameIndex();
        this.class_name = javaClass.getClassName();
        this.super_class_name = javaClass.getSuperclassName();
        this.file_name = javaClass.getSourceFileName();
        this.access_flags = javaClass.getAccessFlags();
        this.cp = new ConstantPoolGen(javaClass.getConstantPool());
        this.major = javaClass.getMajor();
        this.minor = javaClass.getMinor();
        Attribute[] attributeArray = javaClass.getAttributes();
        Method[] methodArray = javaClass.getMethods();
        Field[] fieldArray = javaClass.getFields();
        String[] stringArray = javaClass.getInterfaceNames();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.addInterface(stringArray[n2]);
        }
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            this.addAttribute(attributeArray[n2]);
        }
        for (n2 = 0; n2 < methodArray.length; ++n2) {
            this.addMethod(methodArray[n2]);
        }
        for (n2 = 0; n2 < fieldArray.length; ++n2) {
            this.addField(fieldArray[n2]);
        }
    }

    public JavaClass getJavaClass() {
        int[] nArray = this.getInterfaces();
        Field[] fieldArray = this.getFields();
        Method[] methodArray = this.getMethods();
        Attribute[] attributeArray = this.getAttributes();
        ConstantPool constantPool = this.cp.getFinalConstantPool();
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, constantPool, nArray, fieldArray, methodArray, attributeArray);
    }

    public void addInterface(String string2) {
        this.interface_vec.add(string2);
    }

    public void removeInterface(String string2) {
        this.interface_vec.remove(string2);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n2) {
        this.major = n2;
    }

    public void setMinor(int n2) {
        this.minor = n2;
    }

    public int getMinor() {
        return this.minor;
    }

    public void addAttribute(Attribute attribute2) {
        this.attribute_vec.add(attribute2);
    }

    public void addMethod(Method method) {
        this.method_vec.add(method);
    }

    public void addEmptyConstructor(int n2) {
        InstructionList instructionList = new InstructionList();
        instructionList.append(InstructionConstants.THIS);
        instructionList.append(new INVOKESPECIAL(this.cp.addMethodref(this.super_class_name, "<init>", "()V")));
        instructionList.append(InstructionConstants.RETURN);
        MethodGen methodGen = new MethodGen(n2, Type.VOID, Type.NO_ARGS, null, "<init>", this.class_name, instructionList, this.cp);
        methodGen.setMaxStack(1);
        this.addMethod(methodGen.getMethod());
    }

    public void addField(Field field) {
        this.field_vec.add(field);
    }

    public boolean containsField(Field field) {
        return this.field_vec.contains(field);
    }

    public Field containsField(String string2) {
        for (Field field : this.field_vec) {
            if (!field.getName().equals(string2)) continue;
            return field;
        }
        return null;
    }

    public Method containsMethod(String string2, String string3) {
        for (Method method : this.method_vec) {
            if (!method.getName().equals(string2) || !method.getSignature().equals(string3)) continue;
            return method;
        }
        return null;
    }

    public void removeAttribute(Attribute attribute2) {
        this.attribute_vec.remove(attribute2);
    }

    public void removeMethod(Method method) {
        this.method_vec.remove(method);
    }

    public void replaceMethod(Method method, Method method2) {
        if (method2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n2 = this.method_vec.indexOf(method);
        if (n2 < 0) {
            this.method_vec.add(method2);
        } else {
            this.method_vec.set(n2, method2);
        }
    }

    public void replaceField(Field field, Field field2) {
        if (field2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n2 = this.field_vec.indexOf(field);
        if (n2 < 0) {
            this.field_vec.add(field2);
        } else {
            this.field_vec.set(n2, field2);
        }
    }

    public void removeField(Field field) {
        this.field_vec.remove(field);
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getSuperclassName() {
        return this.super_class_name;
    }

    public String getFileName() {
        return this.file_name;
    }

    public void setClassName(String string2) {
        this.class_name = string2.replace('/', '.');
        this.class_name_index = this.cp.addClass(string2);
    }

    public void setSuperclassName(String string2) {
        this.super_class_name = string2.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(string2);
    }

    public Method[] getMethods() {
        Method[] methodArray = new Method[this.method_vec.size()];
        this.method_vec.toArray(methodArray);
        return methodArray;
    }

    public void setMethods(Method[] methodArray) {
        this.method_vec.clear();
        for (int i = 0; i < methodArray.length; ++i) {
            this.addMethod(methodArray[i]);
        }
    }

    public void setMethodAt(Method method, int n2) {
        this.method_vec.set(n2, method);
    }

    public Method getMethodAt(int n2) {
        return (Method)this.method_vec.get(n2);
    }

    public String[] getInterfaceNames() {
        int n2 = this.interface_vec.size();
        String[] stringArray = new String[n2];
        this.interface_vec.toArray(stringArray);
        return stringArray;
    }

    public int[] getInterfaces() {
        int n2 = this.interface_vec.size();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.cp.addClass((String)this.interface_vec.get(i));
        }
        return nArray;
    }

    public Field[] getFields() {
        Field[] fieldArray = new Field[this.field_vec.size()];
        this.field_vec.toArray(fieldArray);
        return fieldArray;
    }

    public Attribute[] getAttributes() {
        Attribute[] attributeArray = new Attribute[this.attribute_vec.size()];
        this.attribute_vec.toArray(attributeArray);
        return attributeArray;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    public void setClassNameIndex(int n2) {
        this.class_name_index = n2;
        this.class_name = this.cp.getConstantPool().getConstantString(n2, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int n2) {
        this.superclass_name_index = n2;
        this.super_class_name = this.cp.getConstantPool().getConstantString(n2, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public void addObserver(ClassObserver classObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(classObserver);
    }

    public void removeObserver(ClassObserver classObserver) {
        if (this.observers != null) {
            this.observers.remove(classObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator iterator = this.observers.iterator();
            while (iterator.hasNext()) {
                ((ClassObserver)iterator.next()).notify(this);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }
}

