/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IndexedInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TypedInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    protected int index;

    CPInstruction() {
    }

    protected CPInstruction(short s, int n2) {
        super(s, (short)3);
        this.setIndex(n2);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
    }

    @Override
    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index;
    }

    @Override
    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        String string2 = constantPool.constantToString(constant);
        if (constant instanceof ConstantClass) {
            string2 = string2.replace('.', '/');
        }
        return Constants.OPCODE_NAMES[this.opcode] + " " + string2;
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.setIndex(byteSequence.readUnsignedShort());
        this.length = (short)3;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int n2) {
        if (n2 < 0) {
            throw new ClassGenException("Negative index value: " + n2);
        }
        this.index = n2;
    }

    @Override
    public Type getType(ConstantPoolGen constantPoolGen) {
        ConstantPool constantPool = constantPoolGen.getConstantPool();
        String string2 = constantPool.getConstantString(this.index, (byte)7);
        if (!string2.startsWith("[")) {
            string2 = "L" + string2 + ";";
        }
        return Type.getType(string2);
    }
}

