/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.BasicType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.io.Serializable;

public final class ArrayType
extends ReferenceType {
    private int dimensions;
    private Type basic_type;

    public ArrayType(byte by2, int n2) {
        this(BasicType.getType(by2), n2);
    }

    public ArrayType(String string2, int n2) {
        this(new ObjectType(string2), n2);
    }

    public ArrayType(Type type2, int n2) {
        super((byte)13, "<dummy>");
        Serializable serializable;
        if (n2 < 1 || n2 > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + n2);
        }
        switch (type2.getType()) {
            case 13: {
                serializable = (ArrayType)type2;
                this.dimensions = n2 + ((ArrayType)serializable).dimensions;
                this.basic_type = ((ArrayType)serializable).basic_type;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = n2;
                this.basic_type = type2;
            }
        }
        serializable = new StringBuffer();
        for (int i = 0; i < this.dimensions; ++i) {
            ((StringBuffer)serializable).append('[');
        }
        ((StringBuffer)serializable).append(this.basic_type.getSignature());
        this.signature = ((StringBuffer)serializable).toString();
    }

    public Type getBasicType() {
        return this.basic_type;
    }

    public Type getElementType() {
        if (this.dimensions == 1) {
            return this.basic_type;
        }
        return new ArrayType(this.basic_type, this.dimensions - 1);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int hashcode() {
        return this.basic_type.hashCode() ^ this.dimensions;
    }

    public boolean equals(Object object2) {
        if (object2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object2;
            return arrayType.dimensions == this.dimensions && arrayType.basic_type.equals(this.basic_type);
        }
        return false;
    }
}

