/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class Utility {
    private static int consumed_chars;
    private static boolean wide;
    private static final int FREE_CHARS = 48;
    private static int[] CHAR_MAP;
    private static int[] MAP_CHAR;
    private static final char ESCAPE_CHAR = '$';

    public static final String accessToString(int n2) {
        return Utility.accessToString(n2, false);
    }

    public static final String accessToString(int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (n3 < 2048) {
            n3 = Utility.pow2(n4);
            if ((n2 & n3) != 0 && (!bl || n3 != 32 && n3 != 512)) {
                stringBuffer.append(Constants.ACCESS_NAMES[n4] + " ");
            }
            ++n4;
        }
        return stringBuffer.toString().trim();
    }

    public static final String classOrInterface(int n2) {
        return (n2 & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n2, int n3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 20);
        ByteSequence byteSequence = new ByteSequence(byArray);
        try {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                Utility.codeToString(byteSequence, constantPool, bl);
            }
            n4 = 0;
            while (byteSequence.available() > 0) {
                if (n3 < 0 || n4 < n3) {
                    String string2 = Utility.fillup(byteSequence.getIndex() + ":", 6, true, ' ');
                    stringBuffer.append(string2 + Utility.codeToString(byteSequence, constantPool, bl) + '\n');
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            System.out.println(stringBuffer.toString());
            iOException.printStackTrace();
            throw new ClassFormatException("Byte code error: " + iOException);
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n2, int n3) {
        return Utility.codeToString(byArray, constantPool, n2, n3, true);
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool, boolean bl) throws IOException {
        int n2;
        int n3;
        short s = (short)byteSequence.readUnsignedByte();
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer(Constants.OPCODE_NAMES[s]);
        if (s == 170 || s == 171) {
            n3 = byteSequence.getIndex() % 4;
            n5 = n3 == 0 ? 0 : 4 - n3;
            for (n2 = 0; n2 < n5; ++n2) {
                byte by2 = byteSequence.readByte();
                if (by2 == 0) continue;
                System.err.println("Warning: Padding byte != 0 in " + Constants.OPCODE_NAMES[s] + ":" + by2);
            }
            n4 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n6 = byteSequence.readInt();
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.getIndex() - 12 - n5 - 1;
                stringBuffer.append("\tdefault = " + (n4 += n8) + ", low = " + n6 + ", high = " + n7 + "(");
                int[] nArray = new int[n7 - n6 + 1];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArray[n3] = n8 + byteSequence.readInt();
                    stringBuffer.append(nArray[n3]);
                    if (n3 >= nArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                break;
            }
            case 171: {
                int n9 = byteSequence.readInt();
                int n10 = byteSequence.getIndex() - 8 - n5 - 1;
                int[] nArray = new int[n9];
                int[] nArray2 = new int[n9];
                stringBuffer.append("\tdefault = " + (n4 += n10) + ", npairs = " + n9 + " (");
                for (n3 = 0; n3 < n9; ++n3) {
                    nArray[n3] = byteSequence.readInt();
                    nArray2[n3] = n10 + byteSequence.readInt();
                    stringBuffer.append("(" + nArray[n3] + ", " + nArray2[n3] + ")");
                    if (n3 >= n9 - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                stringBuffer.append("\t\t#" + (byteSequence.getIndex() - 1 + byteSequence.readShort()));
                break;
            }
            case 200: 
            case 201: {
                stringBuffer.append("\t\t#" + (byteSequence.getIndex() - 1 + byteSequence.readInt()));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n11;
                if (wide) {
                    n11 = byteSequence.readUnsignedShort();
                    wide = false;
                } else {
                    n11 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("\t\t%" + n11);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("\t(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("\t\t<" + Constants.TYPE_NAMES[byteSequence.readByte()] + ">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n12 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t" + constantPool.constantToString(n12, (byte)9) + (bl ? " (" + n12 + ")" : ""));
                break;
            }
            case 187: 
            case 192: {
                stringBuffer.append("\t");
            }
            case 193: {
                int n13 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t<" + constantPool.constantToString(n13, (byte)7) + ">" + (bl ? " (" + n13 + ")" : ""));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int n14 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t" + constantPool.constantToString(n14, (byte)10) + (bl ? " (" + n14 + ")" : ""));
                break;
            }
            case 185: {
                int n15 = byteSequence.readUnsignedShort();
                n3 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t" + constantPool.constantToString(n15, (byte)11) + (bl ? " (" + n15 + ")\t" : "") + n3 + "\t" + byteSequence.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int n16 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t" + constantPool.constantToString(n16, constantPool.getConstant(n16).getTag()) + (bl ? " (" + n16 + ")" : ""));
                break;
            }
            case 18: {
                int n17 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t\t" + constantPool.constantToString(n17, constantPool.getConstant(n17).getTag()) + (bl ? " (" + n17 + ")" : ""));
                break;
            }
            case 189: {
                int n18 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t<" + Utility.compactClassName(constantPool.getConstantString(n18, (byte)7), false) + ">" + (bl ? " (" + n18 + ")" : ""));
                break;
            }
            case 197: {
                int n19 = byteSequence.readUnsignedShort();
                n2 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t<" + Utility.compactClassName(constantPool.getConstantString(n19, (byte)7), false) + ">\t" + n2 + (bl ? " (" + n19 + ")" : ""));
                break;
            }
            case 132: {
                short s2;
                int n20;
                if (wide) {
                    n20 = byteSequence.readUnsignedShort();
                    s2 = byteSequence.readShort();
                    wide = false;
                } else {
                    n20 = byteSequence.readUnsignedByte();
                    s2 = byteSequence.readByte();
                }
                stringBuffer.append("\t\t%" + n20 + "\t" + s2);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[s] <= 0) break;
                block27: for (n2 = 0; n2 < Constants.TYPE_OF_OPERANDS[s].length; ++n2) {
                    stringBuffer.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[s][n2]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readByte());
                            continue block27;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            continue block27;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            continue block27;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool) throws IOException {
        return Utility.codeToString(byteSequence, constantPool, true);
    }

    public static final String compactClassName(String string2) {
        return Utility.compactClassName(string2, true);
    }

    public static final String compactClassName(String string2, String string3, boolean bl) {
        int n2 = string3.length();
        string2 = string2.replace('/', '.');
        if (bl && string2.startsWith(string3) && string2.substring(n2).indexOf(46) == -1) {
            string2 = string2.substring(n2);
        }
        return string2;
    }

    public static final String compactClassName(String string2, boolean bl) {
        return Utility.compactClassName(string2, "java.lang.", bl);
    }

    private static final boolean is_digit(char c) {
        return c >= '0' && c <= '9';
    }

    private static final boolean is_space(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static final int setBit(int n2, int n3) {
        return n2 | Utility.pow2(n3);
    }

    public static final int clearBit(int n2, int n3) {
        int n4 = Utility.pow2(n3);
        return (n2 & n4) == 0 ? n2 : n2 ^ n4;
    }

    public static final boolean isSet(int n2, int n3) {
        return (n2 & Utility.pow2(n3)) != 0;
    }

    public static final String methodTypeToSignature(String string2, String[] stringArray) throws ClassFormatException {
        String string3;
        StringBuffer stringBuffer = new StringBuffer("(");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = Utility.getSignature(stringArray[i]);
                if (string3.endsWith("V")) {
                    throw new ClassFormatException("Invalid type: " + stringArray[i]);
                }
                stringBuffer.append(string3);
            }
        }
        string3 = Utility.getSignature(string2);
        stringBuffer.append(")" + string3);
        return stringBuffer.toString();
    }

    public static final String[] methodSignatureArgumentTypes(String string2) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(string2, true);
    }

    public static final String[] methodSignatureArgumentTypes(String string2, boolean bl) throws ClassFormatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string2.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string2);
            }
            int n2 = 1;
            while (string2.charAt(n2) != ')') {
                arrayList.add(Utility.signatureToString(string2.substring(n2), bl));
                n2 += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static final String methodSignatureReturnType(String string2) throws ClassFormatException {
        return Utility.methodSignatureReturnType(string2, true);
    }

    public static final String methodSignatureReturnType(String string2, boolean bl) throws ClassFormatException {
        String string3;
        try {
            int n2 = string2.lastIndexOf(41) + 1;
            string3 = Utility.signatureToString(string2.substring(n2), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string2);
        }
        return string3;
    }

    public static final String methodSignatureToString(String string2, String string3, String string4) {
        return Utility.methodSignatureToString(string2, string3, string4, true);
    }

    public static final String methodSignatureToString(String string2, String string3, String string4, boolean bl) {
        return Utility.methodSignatureToString(string2, string3, string4, bl, null);
    }

    public static final String methodSignatureToString(String string2, String string3, String string4, boolean bl, LocalVariableTable localVariableTable) throws ClassFormatException {
        String string5;
        StringBuffer stringBuffer = new StringBuffer("(");
        int n2 = string4.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (string2.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string2);
            }
            int n3 = 1;
            while (string2.charAt(n3) != ')') {
                String string6 = Utility.signatureToString(string2.substring(n3), bl);
                stringBuffer.append(string6);
                if (localVariableTable != null) {
                    LocalVariable localVariable = localVariableTable.getLocalVariable(n2);
                    if (localVariable != null) {
                        stringBuffer.append(" " + localVariable.getName());
                    }
                } else {
                    stringBuffer.append(" arg" + n2);
                }
                n2 = "double".equals(string6) || "long".equals(string6) ? (n2 += 2) : ++n2;
                stringBuffer.append(", ");
                n3 += consumed_chars;
            }
            string5 = Utility.signatureToString(string2.substring(++n3), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string2);
        }
        if (stringBuffer.length() > 1) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append(")");
        return string4 + (string4.length() > 0 ? " " : "") + string5 + " " + string3 + stringBuffer.toString();
    }

    private static final int pow2(int n2) {
        return 1 << n2;
    }

    public static final String replace(String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = string2.indexOf(string3);
            if (n2 != -1) {
                int n3 = 0;
                while ((n2 = string2.indexOf(string3, n3)) != -1) {
                    stringBuffer.append(string2.substring(n3, n2));
                    stringBuffer.append(string4);
                    n3 = n2 + string3.length();
                }
                stringBuffer.append(string2.substring(n3));
                string2 = stringBuffer.toString();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
        }
        return string2;
    }

    public static final String signatureToString(String string2) {
        return Utility.signatureToString(string2, true);
    }

    public static final String signatureToString(String string2, boolean bl) {
        consumed_chars = 1;
        try {
            switch (string2.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int n2 = string2.indexOf(59);
                    if (n2 < 0) {
                        throw new ClassFormatException("Invalid signature: " + string2);
                    }
                    consumed_chars = n2 + 1;
                    return Utility.compactClassName(string2.substring(1, n2), bl);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = 0;
                    while (string2.charAt(n3) == '[') {
                        stringBuffer.append("[]");
                        ++n3;
                    }
                    int n4 = n3;
                    String string3 = Utility.signatureToString(string2.substring(n3), bl);
                    consumed_chars += n4;
                    return string3 + stringBuffer.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: `" + string2 + "'");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid signature: " + stringIndexOutOfBoundsException + ":" + string2);
        }
    }

    public static String getSignature(String string2) {
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string2.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = -1;
        block4: for (n3 = 0; n3 < cArray.length; ++n3) {
            switch (cArray[n3]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!bl) continue block4;
                    bl2 = true;
                    continue block4;
                }
                case '[': {
                    if (!bl) {
                        throw new RuntimeException("Illegal type: " + string2);
                    }
                    n4 = n3;
                    break block4;
                }
                default: {
                    bl = true;
                    if (bl2) continue block4;
                    stringBuffer.append(cArray[n3]);
                }
            }
        }
        n3 = 0;
        if (n4 > 0) {
            n3 = Utility.countBrackets(string2.substring(n4));
        }
        string2 = stringBuffer.toString();
        stringBuffer.setLength(0);
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append('[');
        }
        n2 = 0;
        for (int i = 4; i <= 12 && n2 == 0; ++i) {
            if (!Constants.TYPE_NAMES[i].equals(string2)) continue;
            n2 = 1;
            stringBuffer.append(Constants.SHORT_TYPE_NAMES[i]);
        }
        if (n2 == 0) {
            stringBuffer.append('L' + string2.replace('.', '/') + ';');
        }
        return stringBuffer.toString();
    }

    private static int countBrackets(String string2) {
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        boolean bl = false;
        block4: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '[': {
                    if (bl) {
                        throw new RuntimeException("Illegally nested brackets:" + string2);
                    }
                    bl = true;
                    continue block4;
                }
                case ']': {
                    if (!bl) {
                        throw new RuntimeException("Illegally nested brackets:" + string2);
                    }
                    bl = false;
                    ++n2;
                    continue block4;
                }
            }
        }
        if (bl) {
            throw new RuntimeException("Illegally nested brackets:" + string2);
        }
        return n2;
    }

    public static final byte typeOfMethodSignature(String string2) throws ClassFormatException {
        try {
            if (string2.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string2);
            }
            int n2 = string2.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(string2.substring(n2));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string2);
        }
    }

    public static final byte typeOfSignature(String string2) throws ClassFormatException {
        try {
            switch (string2.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatException("Invalid method signature: " + string2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string2);
        }
    }

    public static short searchOpcode(String string2) {
        string2 = string2.toLowerCase();
        for (short s = 0; s < Constants.OPCODE_NAMES.length; s = (short)(s + 1)) {
            if (!Constants.OPCODE_NAMES[s].equals(string2)) continue;
            return s;
        }
        return -1;
    }

    private static final short byteToShort(byte by2) {
        return by2 < 0 ? (short)(256 + by2) : (short)by2;
    }

    public static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            short s = Utility.byteToShort(byArray[i]);
            String string2 = Integer.toString(s, 16);
            if (s < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static final String format(int n2, int n3, boolean bl, char c) {
        return Utility.fillup(Integer.toString(n2), n3, bl, c);
    }

    public static final String fillup(String string2, int n2, boolean bl, char c) {
        int n3 = n2 - string2.length();
        char[] cArray = new char[n3 < 0 ? 0 : n3];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
        if (bl) {
            return string2 + new String(cArray);
        }
        return new String(cArray) + string2;
    }

    static final boolean equals(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        if (n2 != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final void printArray(PrintStream printStream, Object[] objectArray) {
        printStream.println(Utility.printArray(objectArray, true));
    }

    public static final void printArray(PrintWriter printWriter, Object[] objectArray) {
        printWriter.println(Utility.printArray(objectArray, true));
    }

    public static final String printArray(Object[] objectArray) {
        return Utility.printArray(objectArray, true);
    }

    public static final String printArray(Object[] objectArray, boolean bl) {
        return Utility.printArray(objectArray, bl, false);
    }

    public static final String printArray(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('{');
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) {
                stringBuffer.append((bl2 ? "\"" : "") + objectArray[i].toString() + (bl2 ? "\"" : ""));
            } else {
                stringBuffer.append("null");
            }
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        if (bl) {
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    public static boolean isJavaIdentifierPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public static String encode(byte[] byArray, boolean bl) throws IOException {
        Closeable closeable;
        Closeable closeable2;
        if (bl) {
            closeable2 = new ByteArrayOutputStream();
            closeable = new GZIPOutputStream((OutputStream)closeable2);
            ((GZIPOutputStream)closeable).write(byArray, 0, byArray.length);
            ((DeflaterOutputStream)closeable).close();
            ((ByteArrayOutputStream)closeable2).close();
            byArray = ((ByteArrayOutputStream)closeable2).toByteArray();
        }
        closeable2 = new CharArrayWriter();
        closeable = new JavaWriter((Writer)closeable2);
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            ((JavaWriter)closeable).write(n2);
        }
        return ((CharArrayWriter)closeable2).toString();
    }

    public static byte[] decode(String string2, boolean bl) throws IOException {
        int n2;
        char[] cArray = string2.toCharArray();
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        JavaReader javaReader = new JavaReader(charArrayReader);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = javaReader.read()) >= 0) {
            byteArrayOutputStream.write(n2);
        }
        byteArrayOutputStream.close();
        charArrayReader.close();
        javaReader.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl) {
            int n3;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
            byte[] byArray2 = new byte[byArray.length * 3];
            int n4 = 0;
            while ((n3 = gZIPInputStream.read()) >= 0) {
                byArray2[n4++] = (byte)n3;
            }
            byArray = new byte[n4];
            System.arraycopy(byArray2, 0, byArray, 0, n4);
        }
        return byArray;
    }

    public static final String convertString(String string2) {
        char[] cArray = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block7;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        int n2;
        wide = false;
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int n3 = 0;
        boolean bl = false;
        for (n2 = 65; n2 <= 90; ++n2) {
            Utility.CHAR_MAP[n3] = n2;
            Utility.MAP_CHAR[n2] = n3++;
        }
        for (n2 = 103; n2 <= 122; ++n2) {
            Utility.CHAR_MAP[n3] = n2;
            Utility.MAP_CHAR[n2] = n3++;
        }
        Utility.CHAR_MAP[n3] = 36;
        Utility.MAP_CHAR[36] = n3++;
        Utility.CHAR_MAP[n3] = 95;
        Utility.MAP_CHAR[95] = n3;
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void write(int n2) throws IOException {
            if (Utility.isJavaIdentifierPart((char)n2) && n2 != 36) {
                this.out.write(n2);
            } else {
                this.out.write(36);
                if (n2 >= 0 && n2 < 48) {
                    this.out.write(CHAR_MAP[n2]);
                } else {
                    char[] cArray = Integer.toHexString(n2).toCharArray();
                    if (cArray.length == 1) {
                        this.out.write(48);
                        this.out.write(cArray[0]);
                    } else {
                        this.out.write(cArray[0]);
                        this.out.write(cArray[1]);
                    }
                }
            }
        }

        @Override
        public void write(char[] cArray, int n2, int n3) throws IOException {
            for (int i = 0; i < n3; ++i) {
                this.write(cArray[n2 + i]);
            }
        }

        @Override
        public void write(String string2, int n2, int n3) throws IOException {
            this.write(string2.toCharArray(), n2, n3);
        }
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int n2 = this.in.read();
            if (n2 != 36) {
                return n2;
            }
            int n3 = this.in.read();
            if (n3 < 0) {
                return -1;
            }
            if (n3 >= 48 && n3 <= 57 || n3 >= 97 && n3 <= 102) {
                int n4 = this.in.read();
                if (n4 < 0) {
                    return -1;
                }
                char[] cArray = new char[]{(char)n3, (char)n4};
                int n5 = Integer.parseInt(new String(cArray), 16);
                return n5;
            }
            return MAP_CHAR[n3];
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            for (int i = 0; i < n3; ++i) {
                cArray[n2 + i] = (char)this.read();
            }
            return n3;
        }
    }
}

