/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class PMGClass
extends Attribute {
    private int pmg_class_index;
    private int pmg_index;

    public PMGClass(PMGClass pMGClass) {
        this(pMGClass.getNameIndex(), pMGClass.getLength(), pMGClass.getPMGIndex(), pMGClass.getPMGClassIndex(), pMGClass.getConstantPool());
    }

    PMGClass(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n2, n3, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), constantPool);
    }

    public PMGClass(int n2, int n3, int n4, int n5, ConstantPool constantPool) {
        super((byte)9, n2, n3, constantPool);
        this.pmg_index = n4;
        this.pmg_class_index = n5;
    }

    @Override
    public void accept(Visitor visitor) {
        System.err.println("Visiting non-standard PMGClass object");
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.pmg_index);
        dataOutputStream.writeShort(this.pmg_class_index);
    }

    public final int getPMGClassIndex() {
        return this.pmg_class_index;
    }

    public final void setPMGClassIndex(int n2) {
        this.pmg_class_index = n2;
    }

    public final int getPMGIndex() {
        return this.pmg_index;
    }

    public final void setPMGIndex(int n2) {
        this.pmg_index = n2;
    }

    public final String getPMGName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.pmg_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final String getPMGClassName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.pmg_class_index, (byte)1);
        return constantUtf8.getBytes();
    }

    @Override
    public final String toString() {
        return "PMGClass(" + this.getPMGName() + ", " + this.getPMGClassName() + ")";
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (PMGClass)this.clone();
    }
}

