/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumber;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumberTable
extends Attribute {
    private int line_number_table_length;
    private LineNumber[] line_number_table;

    public LineNumberTable(LineNumberTable lineNumberTable) {
        this(lineNumberTable.getNameIndex(), lineNumberTable.getLength(), lineNumberTable.getLineNumberTable(), lineNumberTable.getConstantPool());
    }

    public LineNumberTable(int n2, int n3, LineNumber[] lineNumberArray, ConstantPool constantPool) {
        super((byte)4, n2, n3, constantPool);
        this.setLineNumberTable(lineNumberArray);
    }

    LineNumberTable(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n2, n3, (LineNumber[])null, constantPool);
        this.line_number_table_length = dataInputStream.readUnsignedShort();
        this.line_number_table = new LineNumber[this.line_number_table_length];
        for (int i = 0; i < this.line_number_table_length; ++i) {
            this.line_number_table[i] = new LineNumber(dataInputStream);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLineNumberTable(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.line_number_table_length);
        for (int i = 0; i < this.line_number_table_length; ++i) {
            this.line_number_table[i].dump(dataOutputStream);
        }
    }

    public final LineNumber[] getLineNumberTable() {
        return this.line_number_table;
    }

    public final void setLineNumberTable(LineNumber[] lineNumberArray) {
        this.line_number_table = lineNumberArray;
        this.line_number_table_length = lineNumberArray == null ? 0 : lineNumberArray.length;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.line_number_table_length; ++i) {
            stringBuffer2.append(this.line_number_table[i].toString());
            if (i < this.line_number_table_length - 1) {
                stringBuffer2.append(", ");
            }
            if (stringBuffer2.length() <= 72) continue;
            stringBuffer2.append('\n');
            stringBuffer.append(stringBuffer2);
            stringBuffer2.setLength(0);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    public int getSourceLine(int n2) {
        int n3 = 0;
        int n4 = this.line_number_table_length - 1;
        if (n4 < 0) {
            return -1;
        }
        int n5 = -1;
        int n6 = -1;
        do {
            int n7;
            int n8;
            if ((n8 = this.line_number_table[n7 = (n3 + n4) / 2].getStartPC()) == n2) {
                return this.line_number_table[n7].getLineNumber();
            }
            if (n2 < n8) {
                n4 = n7 - 1;
            } else {
                n3 = n7 + 1;
            }
            if (n8 >= n2 || n8 <= n6) continue;
            n6 = n8;
            n5 = n7;
        } while (n3 <= n4);
        if (n5 < 0) {
            return -1;
        }
        return this.line_number_table[n5].getLineNumber();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        LineNumberTable lineNumberTable = (LineNumberTable)this.clone();
        lineNumberTable.line_number_table = new LineNumber[this.line_number_table_length];
        for (int i = 0; i < this.line_number_table_length; ++i) {
            lineNumberTable.line_number_table[i] = this.line_number_table[i].copy();
        }
        lineNumberTable.constant_pool = constantPool;
        return lineNumberTable;
    }

    public final int getTableLength() {
        return this.line_number_table_length;
    }
}

