/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Node;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClass
implements Cloneable,
Node {
    private int inner_class_index;
    private int outer_class_index;
    private int inner_name_index;
    private int inner_access_flags;

    public InnerClass(InnerClass innerClass) {
        this(innerClass.getInnerClassIndex(), innerClass.getOuterClassIndex(), innerClass.getInnerNameIndex(), innerClass.getInnerAccessFlags());
    }

    InnerClass(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
    }

    public InnerClass(int n2, int n3, int n4, int n5) {
        this.inner_class_index = n2;
        this.outer_class_index = n3;
        this.inner_name_index = n4;
        this.inner_access_flags = n5;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInnerClass(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.inner_class_index);
        dataOutputStream.writeShort(this.outer_class_index);
        dataOutputStream.writeShort(this.inner_name_index);
        dataOutputStream.writeShort(this.inner_access_flags);
    }

    public final int getInnerAccessFlags() {
        return this.inner_access_flags;
    }

    public final int getInnerClassIndex() {
        return this.inner_class_index;
    }

    public final int getInnerNameIndex() {
        return this.inner_name_index;
    }

    public final int getOuterClassIndex() {
        return this.outer_class_index;
    }

    public final void setInnerAccessFlags(int n2) {
        this.inner_access_flags = n2;
    }

    public final void setInnerClassIndex(int n2) {
        this.inner_class_index = n2;
    }

    public final void setInnerNameIndex(int n2) {
        this.inner_name_index = n2;
    }

    public final void setOuterClassIndex(int n2) {
        this.outer_class_index = n2;
    }

    public final String toString() {
        return "InnerClass(" + this.inner_class_index + ", " + this.outer_class_index + ", " + this.inner_name_index + ", " + this.inner_access_flags + ")";
    }

    public final String toString(ConstantPool constantPool) {
        String string2;
        String string3 = constantPool.getConstantString(this.inner_class_index, (byte)7);
        string3 = Utility.compactClassName(string3);
        if (this.outer_class_index != 0) {
            string2 = constantPool.getConstantString(this.outer_class_index, (byte)7);
            string2 = Utility.compactClassName(string2);
        } else {
            string2 = "<not a member>";
        }
        String string4 = this.inner_name_index != 0 ? ((ConstantUtf8)constantPool.getConstant(this.inner_name_index, (byte)1)).getBytes() : "<anonymous>";
        String string5 = Utility.accessToString(this.inner_access_flags, true);
        string5 = string5.equals("") ? "" : string5 + " ";
        return "InnerClass:" + string5 + string3 + "(\"" + string2 + "\", \"" + string4 + "\")";
    }

    public InnerClass copy() {
        try {
            return (InnerClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

