/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantValue;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.FieldOrMethod;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.io.DataInputStream;
import java.io.IOException;

public final class Field
extends FieldOrMethod {
    public Field(Field field) {
        super(field);
    }

    Field(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatException {
        super(dataInputStream, constantPool);
    }

    public Field(int n2, int n3, int n4, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n2, n3, n4, attributeArray, constantPool);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (this.attributes[i].getTag() != 1) continue;
            return (ConstantValue)this.attributes[i];
        }
        return null;
    }

    public final String toString() {
        String string2 = Utility.accessToString(this.access_flags);
        string2 = string2.equals("") ? "" : string2 + " ";
        String string3 = Utility.signatureToString(this.getSignature());
        String string4 = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string2 + string3 + " " + string4);
        ConstantValue constantValue = this.getConstantValue();
        if (constantValue != null) {
            stringBuffer.append(" = " + constantValue);
        }
        for (int i = 0; i < this.attributes_count; ++i) {
            Attribute attribute2 = this.attributes[i];
            if (attribute2 instanceof ConstantValue) continue;
            stringBuffer.append(" [" + attribute2.toString() + "]");
        }
        return stringBuffer.toString();
    }

    public final Field copy(ConstantPool constantPool) {
        return (Field)this.copy_(constantPool);
    }

    public Type getType() {
        return Type.getReturnType(this.getSignature());
    }
}

