/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantLong;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    public ConstantValue(ConstantValue constantValue) {
        this(constantValue.getNameIndex(), constantValue.getLength(), constantValue.getConstantValueIndex(), constantValue.getConstantPool());
    }

    ConstantValue(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n2, n3, dataInputStream.readUnsignedShort(), constantPool);
    }

    public ConstantValue(int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)1, n2, n3, constantPool);
        this.constantvalue_index = n4;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantValue(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.constantvalue_index);
    }

    public final int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    public final void setConstantValueIndex(int n2) {
        this.constantvalue_index = n2;
    }

    @Override
    public final String toString() {
        String string2;
        Constant constant = this.constant_pool.getConstant(this.constantvalue_index);
        switch (constant.getTag()) {
            case 5: {
                string2 = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 4: {
                string2 = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 6: {
                string2 = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 3: {
                string2 = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 8: {
                int n2 = ((ConstantString)constant).getStringIndex();
                constant = this.constant_pool.getConstant(n2, (byte)1);
                string2 = "\"" + Utility.convertString(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            default: {
                throw new IllegalStateException("Type of ConstValue invalid: " + constant);
            }
        }
        return string2;
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ConstantValue constantValue = (ConstantValue)this.clone();
        constantValue.constant_pool = constantPool;
        return constantValue;
    }
}

