/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantCP;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantLong;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Node;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ConstantPool
implements Cloneable,
Node,
Serializable {
    private int constant_pool_count;
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constantArray) {
        this.setConstantPool(constantArray);
    }

    ConstantPool(DataInputStream dataInputStream) throws IOException, ClassFormatException {
        this.constant_pool_count = dataInputStream.readUnsignedShort();
        this.constant_pool = new Constant[this.constant_pool_count];
        for (int i = 1; i < this.constant_pool_count; ++i) {
            this.constant_pool[i] = Constant.readConstant(dataInputStream);
            byte by2 = this.constant_pool[i].getTag();
            if (by2 != 6 && by2 != 5) continue;
            ++i;
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    public String constantToString(Constant constant) throws ClassFormatException {
        String string2;
        byte by2 = constant.getTag();
        switch (by2) {
            case 7: {
                int n2 = ((ConstantClass)constant).getNameIndex();
                constant = this.getConstant(n2, (byte)1);
                string2 = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            case 8: {
                int n3 = ((ConstantString)constant).getStringIndex();
                constant = this.getConstant(n3, (byte)1);
                string2 = "\"" + ConstantPool.escape(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            case 1: {
                string2 = ((ConstantUtf8)constant).getBytes();
                break;
            }
            case 6: {
                string2 = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 4: {
                string2 = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 5: {
                string2 = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 3: {
                string2 = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 12: {
                string2 = this.constantToString(((ConstantNameAndType)constant).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string2 = this.constantToString(((ConstantCP)constant).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)constant).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + by2);
            }
        }
        return string2;
    }

    private static final String escape(String string2) {
        int n2 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 5);
        char[] cArray = string2.toCharArray();
        block7: for (int i = 0; i < n2; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block7;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String constantToString(int n2, byte by2) throws ClassFormatException {
        Constant constant = this.getConstant(n2, by2);
        return this.constantToString(constant);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.constant_pool_count);
        for (int i = 1; i < this.constant_pool_count; ++i) {
            if (this.constant_pool[i] == null) continue;
            this.constant_pool[i].dump(dataOutputStream);
        }
    }

    public Constant getConstant(int n2) {
        if (n2 >= this.constant_pool.length || n2 < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + n2 + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[n2];
    }

    public Constant getConstant(int n2, byte by2) throws ClassFormatException {
        Constant constant = this.getConstant(n2);
        if (constant == null) {
            throw new ClassFormatException("Constant pool at index " + n2 + " is null.");
        }
        if (constant.getTag() == by2) {
            return constant;
        }
        throw new ClassFormatException("Expected class `" + Constants.CONSTANT_NAMES[by2] + "' at index " + n2 + " and got " + constant);
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int n2, byte by2) throws ClassFormatException {
        int n3;
        Constant constant = this.getConstant(n2, by2);
        switch (by2) {
            case 7: {
                n3 = ((ConstantClass)constant).getNameIndex();
                break;
            }
            case 8: {
                n3 = ((ConstantString)constant).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + by2);
            }
        }
        constant = this.getConstant(n3, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public int getLength() {
        return this.constant_pool_count;
    }

    public void setConstant(int n2, Constant constant) {
        this.constant_pool[n2] = constant;
    }

    public void setConstantPool(Constant[] constantArray) {
        this.constant_pool = constantArray;
        this.constant_pool_count = constantArray == null ? 0 : constantArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.constant_pool_count; ++i) {
            stringBuffer.append(i + ")" + this.constant_pool[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public ConstantPool copy() {
        ConstantPool constantPool = null;
        try {
            constantPool = (ConstantPool)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        constantPool.constant_pool = new Constant[this.constant_pool_count];
        for (int i = 1; i < this.constant_pool_count; ++i) {
            if (this.constant_pool[i] == null) continue;
            constantPool.constant_pool[i] = this.constant_pool[i].copy();
        }
        return constantPool;
    }
}

