/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantObject;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantClass
extends Constant
implements ConstantObject {
    private int name_index;

    public ConstantClass(ConstantClass constantClass) {
        this(constantClass.getNameIndex());
    }

    ConstantClass(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort());
    }

    public ConstantClass(int n2) {
        super((byte)7);
        this.name_index = n2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantClass(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.name_index);
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(int n2) {
        this.name_index = n2;
    }

    @Override
    public Object getConstantValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.name_index, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }

    @Override
    public final String toString() {
        return super.toString() + "(name_index = " + this.name_index + ")";
    }
}

