/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInterfaceMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantLong;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Node;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class Constant
implements Cloneable,
Node,
Serializable {
    protected byte tag;

    Constant(byte by2) {
        this.tag = by2;
    }

    @Override
    public abstract void accept(Visitor var1);

    public abstract void dump(DataOutputStream var1) throws IOException;

    public final byte getTag() {
        return this.tag;
    }

    public String toString() {
        return Constants.CONSTANT_NAMES[this.tag] + "[" + this.tag + "]";
    }

    public Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static final Constant readConstant(DataInputStream dataInputStream) throws IOException, ClassFormatException {
        byte by2 = dataInputStream.readByte();
        switch (by2) {
            case 7: {
                return new ConstantClass(dataInputStream);
            }
            case 9: {
                return new ConstantFieldref(dataInputStream);
            }
            case 10: {
                return new ConstantMethodref(dataInputStream);
            }
            case 11: {
                return new ConstantInterfaceMethodref(dataInputStream);
            }
            case 8: {
                return new ConstantString(dataInputStream);
            }
            case 3: {
                return new ConstantInteger(dataInputStream);
            }
            case 4: {
                return new ConstantFloat(dataInputStream);
            }
            case 5: {
                return new ConstantLong(dataInputStream);
            }
            case 6: {
                return new ConstantDouble(dataInputStream);
            }
            case 12: {
                return new ConstantNameAndType(dataInputStream);
            }
            case 1: {
                return new ConstantUtf8(dataInputStream);
            }
        }
        throw new ClassFormatException("Invalid byte tag in constant pool: " + by2);
    }
}

