/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.CodeException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Code
extends Attribute {
    private int max_stack;
    private int max_locals;
    private int code_length;
    private byte[] code;
    private int exception_table_length;
    private CodeException[] exception_table;
    private int attributes_count;
    private Attribute[] attributes;

    public Code(Code code) {
        this(code.getNameIndex(), code.getLength(), code.getMaxStack(), code.getMaxLocals(), code.getCode(), code.getExceptionTable(), code.getAttributes(), code.getConstantPool());
    }

    Code(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n2, n3, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), null, null, null, constantPool);
        int n4;
        this.code_length = dataInputStream.readInt();
        this.code = new byte[this.code_length];
        dataInputStream.readFully(this.code);
        this.exception_table_length = dataInputStream.readUnsignedShort();
        this.exception_table = new CodeException[this.exception_table_length];
        for (n4 = 0; n4 < this.exception_table_length; ++n4) {
            this.exception_table[n4] = new CodeException(dataInputStream);
        }
        this.attributes_count = dataInputStream.readUnsignedShort();
        this.attributes = new Attribute[this.attributes_count];
        for (n4 = 0; n4 < this.attributes_count; ++n4) {
            this.attributes[n4] = Attribute.readAttribute(dataInputStream, constantPool);
        }
        this.length = n3;
    }

    public Code(int n2, int n3, int n4, int n5, byte[] byArray, CodeException[] codeExceptionArray, Attribute[] attributeArray, ConstantPool constantPool) {
        super((byte)2, n2, n3, constantPool);
        this.max_stack = n4;
        this.max_locals = n5;
        this.setCode(byArray);
        this.setExceptionTable(codeExceptionArray);
        this.setAttributes(attributeArray);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCode(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        int n2;
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.max_locals);
        dataOutputStream.writeInt(this.code_length);
        dataOutputStream.write(this.code, 0, this.code_length);
        dataOutputStream.writeShort(this.exception_table_length);
        for (n2 = 0; n2 < this.exception_table_length; ++n2) {
            this.exception_table[n2].dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes_count);
        for (n2 = 0; n2 < this.attributes_count; ++n2) {
            this.attributes[n2].dump(dataOutputStream);
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (!(this.attributes[i] instanceof LineNumberTable)) continue;
            return (LineNumberTable)this.attributes[i];
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (!(this.attributes[i] instanceof LocalVariableTable)) continue;
            return (LocalVariableTable)this.attributes[i];
        }
        return null;
    }

    public final byte[] getCode() {
        return this.code;
    }

    public final CodeException[] getExceptionTable() {
        return this.exception_table;
    }

    public final int getMaxLocals() {
        return this.max_locals;
    }

    public final int getMaxStack() {
        return this.max_stack;
    }

    private final int getInternalLength() {
        return 8 + this.code_length + 2 + 8 * this.exception_table_length + 2;
    }

    private final int calculateLength() {
        int n2 = 0;
        for (int i = 0; i < this.attributes_count; ++i) {
            n2 += this.attributes[i].length + 6;
        }
        return n2 + this.getInternalLength();
    }

    public final void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
        this.attributes_count = attributeArray == null ? 0 : attributeArray.length;
        this.length = this.calculateLength();
    }

    public final void setCode(byte[] byArray) {
        this.code = byArray;
        this.code_length = byArray == null ? 0 : byArray.length;
    }

    public final void setExceptionTable(CodeException[] codeExceptionArray) {
        this.exception_table = codeExceptionArray;
        this.exception_table_length = codeExceptionArray == null ? 0 : codeExceptionArray.length;
    }

    public final void setMaxLocals(int n2) {
        this.max_locals = n2;
    }

    public final void setMaxStack(int n2) {
        this.max_stack = n2;
    }

    public final String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("Code(max_stack = " + this.max_stack + ", max_locals = " + this.max_locals + ", code_length = " + this.code_length + ")\n" + Utility.codeToString(this.code, this.constant_pool, 0, -1, bl));
        if (this.exception_table_length > 0) {
            stringBuffer.append("\nException handler(s) = \nFrom\tTo\tHandler\tType\n");
            for (n2 = 0; n2 < this.exception_table_length; ++n2) {
                stringBuffer.append(this.exception_table[n2].toString(this.constant_pool, bl) + "\n");
            }
        }
        if (this.attributes_count > 0) {
            stringBuffer.append("\nAttribute(s) = \n");
            for (n2 = 0; n2 < this.attributes_count; ++n2) {
                stringBuffer.append(this.attributes[n2].toString() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final String toString() {
        return this.toString(true);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        int n2;
        Code code = (Code)this.clone();
        code.code = (byte[])this.code.clone();
        code.constant_pool = constantPool;
        code.exception_table = new CodeException[this.exception_table_length];
        for (n2 = 0; n2 < this.exception_table_length; ++n2) {
            code.exception_table[n2] = this.exception_table[n2].copy();
        }
        code.attributes = new Attribute[this.attributes_count];
        for (n2 = 0; n2 < this.attributes_count; ++n2) {
            code.attributes[n2] = this.attributes[n2].copy(constantPool);
        }
        return code;
    }
}

