/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.AttributeReader;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantValue;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Deprecated;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ExceptionTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.InnerClasses;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Node;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.PMGClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Signature;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.SourceFile;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.StackMap;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Synthetic;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Unknown;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public abstract class Attribute
implements Cloneable,
Node,
Serializable {
    protected int name_index;
    protected int length;
    protected byte tag;
    protected ConstantPool constant_pool;
    private static HashMap readers = new HashMap();

    protected Attribute(byte by2, int n2, int n3, ConstantPool constantPool) {
        this.tag = by2;
        this.name_index = n2;
        this.length = n3;
        this.constant_pool = constantPool;
    }

    @Override
    public abstract void accept(Visitor var1);

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeInt(this.length);
    }

    public static void addAttributeReader(String string2, AttributeReader attributeReader) {
        readers.put(string2, attributeReader);
    }

    public static void removeAttributeReader(String string2) {
        readers.remove(string2);
    }

    public static final Attribute readAttribute(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatException {
        int n2 = -1;
        int n3 = dataInputStream.readUnsignedShort();
        ConstantUtf8 constantUtf8 = (ConstantUtf8)constantPool.getConstant(n3, (byte)1);
        String string2 = constantUtf8.getBytes();
        int n4 = dataInputStream.readInt();
        for (int n5 = 0; n5 < 12; n5 = (int)((byte)(n5 + 1))) {
            if (!string2.equals(Constants.ATTRIBUTE_NAMES[n5])) continue;
            n2 = n5;
            break;
        }
        switch (n2) {
            case -1: {
                AttributeReader attributeReader = (AttributeReader)readers.get(string2);
                if (attributeReader != null) {
                    return attributeReader.createAttribute(n3, n4, dataInputStream, constantPool);
                }
                return new Unknown(n3, n4, dataInputStream, constantPool);
            }
            case 1: {
                return new ConstantValue(n3, n4, dataInputStream, constantPool);
            }
            case 0: {
                return new SourceFile(n3, n4, dataInputStream, constantPool);
            }
            case 2: {
                return new Code(n3, n4, dataInputStream, constantPool);
            }
            case 3: {
                return new ExceptionTable(n3, n4, dataInputStream, constantPool);
            }
            case 4: {
                return new LineNumberTable(n3, n4, dataInputStream, constantPool);
            }
            case 5: {
                return new LocalVariableTable(n3, n4, dataInputStream, constantPool);
            }
            case 6: {
                return new InnerClasses(n3, n4, dataInputStream, constantPool);
            }
            case 7: {
                return new Synthetic(n3, n4, dataInputStream, constantPool);
            }
            case 8: {
                return new Deprecated(n3, n4, dataInputStream, constantPool);
            }
            case 9: {
                return new PMGClass(n3, n4, dataInputStream, constantPool);
            }
            case 10: {
                return new Signature(n3, n4, dataInputStream, constantPool);
            }
            case 11: {
                return new StackMap(n3, n4, dataInputStream, constantPool);
            }
        }
        throw new IllegalStateException("Ooops! default case reached.");
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n2) {
        this.length = n2;
    }

    public final void setNameIndex(int n2) {
        this.name_index = n2;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public Object clone() {
        Object object2 = null;
        try {
            object2 = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return object2;
    }

    public abstract Attribute copy(ConstantPool var1);

    public String toString() {
        return Constants.ATTRIBUTE_NAMES[this.tag];
    }
}

