/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CharacterMap;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Output;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ResultDocument;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Template;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Text;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.UnsupportedElement;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.ParseException;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPath;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLT1ParseTables;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLT2ParseTables;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParseQNameUtils;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParseTables;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTBaseMsg;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.AttributeList;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.URI;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.common.utils.XMLChar;
import com.ibm.xltxe.rnm1.xtq.scontext.MergedCharacterMapsManager;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;
import com.ibm.xltxe.rnm1.xtq.utils.Reporter;
import com.ibm.xml.jaxp.util.JAXPFactoryHelper;
import com.ibm.xml.xml4j.api.s1.xs.PSVIProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XSLTParser
extends ASTBuildingContext
implements Constants,
ContentHandler,
LexicalHandler {
    private static final String XSL = "xsl";
    private Locator _locator = null;
    private XMLReader _reader = null;
    private boolean _debug = false;
    private XSLTParseTables _parseTables;
    private QName _useAttributeSets;
    private Hashtable _variableScope;
    private XTQProgram _currentXTQProgram;
    private XTQProgram _topLevelXTQProgram;
    private Output _output;
    private Template _template;
    private boolean _rootNamespaceDef;
    private Expr _root;
    private String _target;
    private ExpressionFactoryImpl _expressionFactory;
    private XStaticContext _staticContext;
    private final boolean _isXSLT20;
    private boolean _xml10Only;
    private boolean _isSecureProcessing;
    private XSLTParseQNameUtils parseUtilsInstance;
    private Reporter _reporter;
    private HashSet _extensionNamespaces = null;
    private Expr.ImportPrecedence _currentImportPrecedence;
    private String _PImedia = null;
    private String _PItitle = null;
    private String _PIcharset = null;
    private int _templateIndex = 0;
    private String exprString;
    private Stack _parentStack = null;
    private Stack _entityInfoStack = null;
    private int _elementDepthInEntity = 0;
    private HashMap _prefixMapping = null;
    private PSVIProvider _psviProvider = null;

    public XSLTParser() {
        this(false, new XStaticContext());
        this._xml10Only = false;
    }

    public XSLTParser(boolean bl, XStaticContext xStaticContext) {
        this._expressionFactory = new ExpressionFactoryImpl(xStaticContext);
        this._reporter = new Reporter();
        this._isXSLT20 = bl;
        this._xml10Only = false;
    }

    public XSLTParser(boolean bl, ExpressionFactoryImpl expressionFactoryImpl) {
        this._expressionFactory = expressionFactoryImpl;
        this._reporter = new Reporter();
        this._isXSLT20 = bl;
        this._xml10Only = false;
    }

    public void init() {
        this.initLanguageSetting();
        this.parseUtilsInstance = XSLTParseQNameUtils.newInstance();
        this._variableScope = new Hashtable();
        this._template = null;
        this._staticContext = this._expressionFactory.getContext();
        this._currentXTQProgram = null;
        this._output = null;
        this._root = null;
        this._rootNamespaceDef = false;
        if (this._isXSLT20) {
            this._parseTables = XSLT2ParseTables.getInstance();
        } else {
            this._parseTables = XSLT1ParseTables.getInstance();
            this._staticContext.setBuiltInNamespaceForFunction();
        }
        this._useAttributeSets = this.getQName("http://www.w3.org/1999/XSL/Transform", XSL, "use-attribute-sets");
    }

    protected void initLanguageSetting() {
        if (this._isXSLT20) {
            this.getExpressionFactory().setLanguage("XSLT2");
        } else {
            this.getExpressionFactory().setLanguage("XSLT1");
        }
    }

    public void reset() {
        this.parseUtilsInstance.reset();
        this._variableScope.clear();
        this._template = null;
        this._currentXTQProgram = null;
        this._output = null;
        this._root = null;
        this._rootNamespaceDef = false;
        this._expressionFactory.reset();
        this.initLanguageSetting();
        this._reporter.reset();
    }

    public Expr.ImportPrecedence getCurrentImportPrecedence() {
        return this._currentImportPrecedence;
    }

    public void setCurrentImportPrecedence(Expr.ImportPrecedence importPrecedence) {
        this._currentImportPrecedence = importPrecedence;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public void setXML10Only(boolean bl) {
        this._xml10Only = bl;
    }

    public boolean isXSLT20() {
        return this._isXSLT20;
    }

    @Override
    public ExpressionFactoryImpl getExpressionFactory() {
        return this._expressionFactory;
    }

    @Override
    public XStaticContext getStaticContext() {
        return this._staticContext;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this._reader = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this._reader;
    }

    public void setOutput(Output output) {
        if (this._output != null) {
            Expr.ImportPrecedence importPrecedence = this._output.getImportPrecedence();
            Expr.ImportPrecedence importPrecedence2 = output.getImportPrecedence();
            if (importPrecedence2.hasSamePrecedenceAs(importPrecedence) || importPrecedence2.hasHigherPrecedenceThan(importPrecedence)) {
                String string2 = this._output.getCdata();
                output.mergeCdata(string2);
                this._output.disable();
                this._output = output;
            } else {
                output.disable();
            }
        } else {
            this._output = output;
        }
    }

    public Output getOutput() {
        return this._output;
    }

    public Properties getOutputProperties() {
        Properties properties = this.getTopLevelXTQProgram().getOutputProperties();
        return properties;
    }

    public void setCurrentXTQProgram(XTQProgram xTQProgram) {
        this._currentXTQProgram = xTQProgram;
    }

    public XTQProgram getCurrentXTQProgram() {
        return this._currentXTQProgram;
    }

    public XTQProgram getTopLevelXTQProgram() {
        return this._topLevelXTQProgram;
    }

    public void setTopLevelXTQProgram(XTQProgram xTQProgram) {
        this._topLevelXTQProgram = xTQProgram;
    }

    public QName getQNameSafe(String string2) {
        return this.parseUtilsInstance.getQNameSafe(string2, this._staticContext);
    }

    public QName getQName(String string2) {
        return this.parseUtilsInstance.getQName(this, string2, true, false, this._staticContext);
    }

    public QName getQNameIgnoreDefaultNs(String string2) {
        return this.parseUtilsInstance.getQName(this, string2, true, true, this._staticContext);
    }

    public ArrayList<QName> getQNameListIgnoreDefaultNs(String string2) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        StringTokenizer stringTokenizer = Util.whitespaceTokenize(string2);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            arrayList.add(this.parseUtilsInstance.getQName(this, string3, true, true, this._staticContext));
        }
        return arrayList;
    }

    public QName getQName(String string2, boolean bl) {
        return this.parseUtilsInstance.getQName(this, string2, bl, false, this._staticContext);
    }

    public QName getQName(String string2, boolean bl, boolean bl2) {
        return this.parseUtilsInstance.getQName(this, string2, bl, bl2, this._staticContext);
    }

    public QName getQName(String string2, String string3, String string4) {
        return this.parseUtilsInstance.getQName(string2, string3, string4);
    }

    public QName getQName(String string2, String string3) {
        return this.parseUtilsInstance.getQName(this, string2 + string3, true, false, this._staticContext);
    }

    public QName getQName(QName qName, QName qName2) {
        return this.parseUtilsInstance.getQName(this, qName.toString() + qName2.toString(), true, false, this._staticContext);
    }

    public QName getUseAttributeSets() {
        return this._useAttributeSets;
    }

    public XTQProgram makeStylesheet(Expr expr) {
        try {
            XTQProgram xTQProgram;
            if (expr instanceof XTQProgram) {
                xTQProgram = (XTQProgram)expr;
                xTQProgram.setParser(this);
                int n2 = xTQProgram.jjtGetNumChildren();
                for (int i = 0; i < n2; ++i) {
                    Expr expr2 = (Expr)xTQProgram.jjtGetChild(i);
                    if (expr2.getId() != 108) continue;
                    this.checkForNullNS(expr2);
                }
            } else {
                xTQProgram = new XTQProgram();
                xTQProgram.setLineInfo(expr.getLineInfo());
                xTQProgram.setParser(this);
                xTQProgram.setSimplified();
                xTQProgram.jjtAppendChild(this, expr);
                String string2 = expr.getProgramVersion();
                if (null == string2) {
                    ASTMsg aSTMsg = new ASTMsg("SIMPLIFIED_MODULE_VER_ERR");
                    this.reportError(2, aSTMsg);
                }
                xTQProgram.setProgramVersion(string2);
                if (expr.lookupNamespace("") == null) {
                    expr.addPrefixMapping("", "");
                }
            }
            return xTQProgram;
        }
        catch (ClassCastException classCastException) {
            ASTMsg aSTMsg = new ASTMsg("NOT_STYLESHEET_ERR", expr);
            this._reporter.report(2, aSTMsg);
            return null;
        }
    }

    public void createAST(XTQProgram xTQProgram) {
        if (xTQProgram != null) {
            xTQProgram.callParseContents(this);
            int n2 = xTQProgram.jjtGetNumChildren();
            for (int i = 0; i < n2; ++i) {
                Node node2 = xTQProgram.jjtGetChild(i);
                if (!(node2 instanceof Text)) continue;
                Text text2 = (Text)node2;
                int n3 = text2.getLineNumber();
                int n4 = text2.getColumnNumber();
                ASTMsg aSTMsg = new ASTMsg("ILLEGAL_TEXT_NODE_ERR", n3, n4, (Object)null);
                this.reportError(3, aSTMsg);
            }
            this.reportDuplicateErrors();
            this.globalUseCharacterMapsErrors(xTQProgram);
        }
    }

    private void globalUseCharacterMapsErrors(XTQProgram xTQProgram) {
        int n2;
        int n3;
        Object object2;
        Object object3;
        Object object4;
        String string2;
        String[] stringArray;
        XStaticContext xStaticContext = this.getStaticContext();
        MergedCharacterMapsManager mergedCharacterMapsManager = xStaticContext.getCharacterMapsManager();
        if (mergedCharacterMapsManager != null && (stringArray = mergedCharacterMapsManager.getReferences()) != null && stringArray.length > 0) {
            Object[] objectArray = mergedCharacterMapsManager.getReferencingNodes();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                String string4;
                string2 = stringArray[i];
                object4 = mergedCharacterMapsManager.findCharMap(string2);
                object3 = (Expr)objectArray[i];
                object2 = "";
                if (object3 instanceof Output) {
                    if (object4 != null) {
                        ((MergedCharacterMapsManager.CharacterMapRecord)object4).mightBeUsedByOutputOrResultDocument();
                        continue;
                    }
                    object2 = "xsl:output";
                } else if (object3 instanceof ResultDocument) {
                    if (object4 != null) {
                        ((MergedCharacterMapsManager.CharacterMapRecord)object4).mightBeUsedByOutputOrResultDocument();
                        continue;
                    }
                    object2 = "xsl:result-document";
                } else if (object3 instanceof CharacterMap) {
                    if (object4 != null) continue;
                    object2 = "xsl:character-map";
                }
                n3 = string2.indexOf(125);
                if (0 <= n3) {
                    string4 = string2.substring(n3 + 1);
                    string3 = string2.substring(1, n3);
                } else {
                    string4 = string2;
                    string3 = "";
                }
                Object[] objectArray2 = new String[]{object2, string4, string3};
                ASTMsg aSTMsg = new ASTMsg("USE_CHARACTER_MAPS_NO_NAME_MATCH", objectArray2, (SimpleNode)object3);
                this.reportError(3, aSTMsg);
            }
        }
        stringArray = mergedCharacterMapsManager.getCharacterMapNames();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            MergedCharacterMapsManager.CharacterMapRecord characterMapRecord = mergedCharacterMapsManager.findCharMap(stringArray[n2]);
            if (!characterMapRecord.isDuplicate()) continue;
            string2 = characterMapRecord.getURI();
            object4 = characterMapRecord.getLocalName();
            object3 = (MergedCharacterMapsManager.CharacterMapRecord[])characterMapRecord.getExpr();
            object2 = string2 == null || string2.length() == 0 ? new ASTMsg("CHARACTER_MAP_NAME_DUPLICATES1", object4, (SimpleNode)object3) : new ASTMsg("CHARACTER_MAP_NAME_DUPLICATES2", object4, string2, (SimpleNode)object3);
            this.reportError(3, (ASTBaseMsg)object2);
        }
        mergedCharacterMapsManager.process();
        block5: for (n2 = 0; n2 < stringArray.length; ++n2) {
            MergedCharacterMapsManager.CharacterMapRecord characterMapRecord = mergedCharacterMapsManager.findCharMap(stringArray[n2]);
            int n4 = mergedCharacterMapsManager.getStatus(stringArray[n2]);
            switch (n4) {
                case 3: {
                    object3 = mergedCharacterMapsManager.getCircularList(stringArray[n2]);
                    object2 = new StringBuffer();
                    for (n3 = 0; n3 < ((MergedCharacterMapsManager.CharacterMapRecord[])object3).length; ++n3) {
                        if (0 < n3) {
                            ((StringBuffer)object2).append(", ");
                        }
                        ((StringBuffer)object2).append(object3[n3].getLexicalQName());
                    }
                    object4 = ((StringBuffer)object2).toString();
                    object3 = (Expr)characterMapRecord.getExpr();
                    object2 = new ASTMsg("USE_CHARACTER_MAPS_CIRCULAR", object4, (SimpleNode)object3);
                    this.reportError(3, (ASTBaseMsg)object2);
                    continue block5;
                }
            }
        }
    }

    protected void reportDuplicateErrors() {
        Hashtable hashtable = this._staticContext.getStylesheetFunctions();
        if (null != hashtable) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                FunctionDecl functionDecl = (FunctionDecl)enumeration.nextElement();
                FunctionDecl functionDecl2 = functionDecl.getDuplicate();
                if (functionDecl2 == null) continue;
                String string2 = functionDecl.getQName().toString();
                this.generateDuplicateError(string2, functionDecl2);
            }
        }
    }

    protected void generateDuplicateError(String string2, Expr expr) {
        ASTMsg aSTMsg = new ASTMsg("FUNCTION_REDEF_ERR", (Object)string2, (SimpleNode)expr);
        this.reportError(3, aSTMsg);
    }

    public Expr parse(XMLReader xMLReader, InputSource inputSource, Expr expr) {
        try {
            xMLReader.setContentHandler(this);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            if (xMLReader instanceof PSVIProvider) {
                this.setPsviProvider((PSVIProvider)((Object)xMLReader));
            }
            xMLReader.parse(inputSource);
            return this.getStylesheet(this._root);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ASTMsg aSTMsg = new ASTMsg("ERR_UNABLE_TO_RETRIEVE_RESOURCE", (Object)inputSource.getSystemId(), (SimpleNode)expr);
            this.reportError(2, aSTMsg);
        }
        catch (IOException iOException) {
            if (this._debug) {
                iOException.printStackTrace();
            }
            this.reportError(2, new ASTMsg(iOException));
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (this._debug) {
                sAXException.printStackTrace();
                if (exception != null) {
                    exception.printStackTrace();
                }
            }
            if (sAXException instanceof SAXParseException) {
                ASTMsg aSTMsg = new ASTMsg("PARSE_ERR", ((SAXParseException)sAXException).getSystemId(), ((SAXParseException)sAXException).getMessage(), ((SAXParseException)sAXException).getLineNumber(), ((SAXParseException)sAXException).getColumnNumber());
                this.reportError(2, aSTMsg);
            }
            this.reportError(2, new ASTMsg(sAXException));
        }
        return null;
    }

    public Expr parse(InputSource inputSource, Expr expr) {
        try {
            SAXParserFactory sAXParserFactory = JAXPFactoryHelper.newSAXParserFactory();
            try {
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (Exception exception) {
                sAXParserFactory.setNamespaceAware(true);
            }
            if (this._isSecureProcessing) {
                sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            this.getStaticContext().configureParserFactory(sAXParserFactory);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            return this.parse(xMLReader, inputSource, expr);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ASTMsg aSTMsg = new ASTMsg("ERR_SYSTEM", "SAX parser is not configured correctly.");
            this.reportError(2, aSTMsg);
        }
        catch (SAXParseException sAXParseException) {
            this.reportError(2, new ASTMsg("PARSE_ERR", sAXParseException.getSystemId(), sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()));
        }
        catch (SAXException sAXException) {
            this.reportError(2, new ASTMsg(sAXException.getMessage()));
        }
        return null;
    }

    public Expr getDocumentRoot() {
        return this._root;
    }

    public void setPIParameters(String string2, String string3, String string4) {
        this._PImedia = string2;
        this._PItitle = string3;
        this._PIcharset = string4;
    }

    private Expr getStylesheet(Expr expr) {
        if (this._target == null) {
            if (!this._rootNamespaceDef) {
                ASTMsg aSTMsg = new ASTMsg("MISSING_XSLT_URI_ERR");
                this._reporter.report(2, aSTMsg);
            }
            return expr;
        }
        if (this._target.charAt(0) == '#') {
            Expr expr2 = this.findStylesheet(expr, this._target.substring(1));
            if (expr2 == null) {
                ASTMsg aSTMsg = new ASTMsg("MISSING_XSLT_TARGET_ERR", (Object)this._target, (SimpleNode)expr);
                this._reporter.report(2, aSTMsg);
            }
            return expr2;
        }
        return this.loadExternalStylesheet(this._target, expr);
    }

    private Expr findStylesheet(Expr expr, String string2) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof XTQProgram) {
            String string3 = expr.getAttribute("xml:id");
            if (string3.equals(string2)) {
                return expr;
            }
            string3 = expr.getAttribute("id");
            String string4 = expr.getAttributeType("id");
            if (string3.equals(string2) && string4.equals("ID")) {
                return expr;
            }
        }
        int n2 = expr.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            Expr expr3 = this.findStylesheet(expr2, string2);
            if (expr3 == null) continue;
            return expr3;
        }
        return null;
    }

    private Expr loadExternalStylesheet(String string2, Expr expr) {
        String string3 = null;
        try {
            string3 = SystemIDResolver.getAbsoluteURI(string2, expr.getBaseURI());
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new WrappedRuntimeException(malformedURIException);
        }
        InputSource inputSource = new InputSource(string3);
        Expr expr2 = this.parse(inputSource, expr);
        return expr2;
    }

    public boolean elementSupported(String string2, String string3) {
        return this._parseTables.getInstrClass(this.getQName(string2, XSL, string3)) != null;
    }

    public Iterator getInstructionItr() {
        return this._parseTables.getInstrQNames();
    }

    public Template getTemplate() {
        return this._template;
    }

    public void setTemplate(Template template) {
        this._template = template;
    }

    public int getTemplateIndex() {
        return this._templateIndex++;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Expr makeInstance(String string2, String string3, String string4, Attributes attributes2, Expr expr) {
        Expr expr2 = null;
        QName qName = this.getQName(string2, string3, string4);
        String string5 = (String)this._parseTables.getInstrClass(qName);
        if (string5 != null) {
            try {
                Class<?> clazz = Class.forName(string5);
                expr2 = (Expr)clazz.newInstance();
                expr2.setNodeQName(qName);
                this.setLineInfo(expr2);
                expr2.jjtSetParent(expr);
                if (expr2 instanceof XTQProgram) {
                    if (this._topLevelXTQProgram == null) {
                        this._topLevelXTQProgram = (XTQProgram)expr2;
                    }
                    XTQProgram xTQProgram = (XTQProgram)expr2;
                    xTQProgram.setParser(this);
                }
                expr2.setName(string2, string3, string4);
                expr2.setAttributes(new AttributeList(attributes2, this._psviProvider));
                expr2.setPrefixMapping(this._prefixMapping);
                this.setStandardAttributes(string2, expr2, attributes2, expr);
                this.checkAttributes(expr2, attributes2, qName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ASTMsg aSTMsg = new ASTMsg("ERR_SYSTEM", "The class " + expr2 + " can not be found: " + classNotFoundException.getMessage());
                this.reportError(3, aSTMsg);
            }
            catch (IllegalAccessException illegalAccessException) {
                ASTMsg aSTMsg = new ASTMsg("ERR_SYSTEM", "The class " + expr2 + " can not be accessed: " + illegalAccessException.getMessage());
                this.reportError(3, aSTMsg);
            }
            catch (InstantiationException instantiationException) {
                ASTMsg aSTMsg = new ASTMsg("ERR_SYSTEM", "The class " + expr2 + " can not be instantiated: " + instantiationException.getMessage());
                this.reportError(3, aSTMsg);
            }
        } else if (string2 != null) {
            expr2 = new UnsupportedElement(string2, string3, string4);
            expr2.setNodeQName(qName);
            this.setLineInfo(expr2);
            expr2.jjtSetParent(expr);
            expr2.setAttributes(new AttributeList(attributes2));
            expr2.setPrefixMapping(this._prefixMapping);
            this.setStandardAttributes(string2, expr2, attributes2, expr);
            if (string2.equals("http://www.w3.org/1999/XSL/Transform")) {
                UnsupportedElement unsupportedElement = (UnsupportedElement)expr2;
                ASTMsg aSTMsg = new ASTMsg("UNSUPPORTED_XSL_ERR", expr2.getLineNumber(), expr2.getColumnNumber(), string4);
                unsupportedElement.setErrorMessage(aSTMsg);
                try {
                    double d;
                    String string6 = unsupportedElement.getProgramVersion();
                    double d2 = d = string6 != null ? Double.valueOf(string6) : 1.0;
                    if (!(d <= 2.0)) {
                        // empty if block
                    }
                }
                catch (Exception exception) {
                    ASTMsg aSTMsg2 = new ASTMsg("ERR_SYSTEM", (Object)exception.getMessage(), (SimpleNode)unsupportedElement);
                    this.reportError(2, aSTMsg2);
                }
            } else if (string2.equals("http://xml.apache.org/xalan/xsltc")) {
                UnsupportedElement unsupportedElement = (UnsupportedElement)expr2;
                unsupportedElement.setIsExtension();
                ASTMsg aSTMsg = new ASTMsg("UNSUPPORTED_EXT_ERR", expr2.getLineNumber(), expr2.getColumnNumber(), string4);
                unsupportedElement.setErrorMessage(aSTMsg);
            } else {
                XTQProgram xTQProgram = this._topLevelXTQProgram;
                if (xTQProgram != null && expr2.isExtension(string2) && xTQProgram != expr) {
                    UnsupportedElement unsupportedElement = (UnsupportedElement)expr2;
                    unsupportedElement.setIsExtension();
                    ASTMsg aSTMsg = new ASTMsg("UNSUPPORTED_EXT_ERR", expr2.getLineNumber(), expr2.getColumnNumber(), string3 + ":" + string4);
                    unsupportedElement.setErrorMessage(aSTMsg);
                } else {
                    LineInfo lineInfo = expr2.getLineInfo();
                    expr2 = new DirElemConstructor(108);
                    expr2.jjtSetParent(expr);
                    expr2.setAttributes(new AttributeList(attributes2));
                    expr2.setPrefixMapping(this._prefixMapping);
                    this.setStandardAttributes(string2, expr2, attributes2, expr);
                    expr2.setLineInfo(lineInfo);
                    this.checkAttributes(expr2, attributes2, qName);
                }
            }
        }
        if (expr2 != null && expr2 instanceof DirElemConstructor) {
            ((DirElemConstructor)expr2).setQName(qName);
        }
        return expr2;
    }

    private void checkAttributes(Expr expr, Attributes attributes2, QName qName) {
        String[] stringArray = this._parseTables.getRequiredAttrs(qName);
        String[] stringArray2 = this._parseTables.getOptAttrs(qName);
        String string2 = expr.getProgramVersion();
        double d = 0.0;
        if (null != string2) {
            try {
                d = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                ASTMsg aSTMsg = new ASTMsg("XSL_VERSION_ERR", string2);
                this.reportError(2, aSTMsg);
            }
        }
        this.checkForStandardAttrsOnLRE(expr, qName, attributes2);
        ArrayList<String> arrayList = null;
        if (stringArray != null) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        if (d <= 2.0 && (stringArray != null || stringArray2 != null)) {
            int n2 = attributes2.getLength();
            for (int i = 0; i < n2; ++i) {
                Object object2;
                String string3 = attributes2.getQName(i);
                if (this._isXSLT20 ? string3.startsWith("xml") || string3.indexOf(58) > 0 && !attributes2.getURI(i).equals("http://www.w3.org/1999/XSL/Transform") : string3.startsWith("xml") || string3.indexOf(58) > 0) continue;
                boolean bl = false;
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!string3.equalsIgnoreCase(stringArray[j])) continue;
                        bl = true;
                        arrayList.remove(stringArray[j]);
                        break;
                    }
                }
                if (stringArray2 != null && !bl) {
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (!string3.equalsIgnoreCase(stringArray2[j])) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    if (!this._isXSLT20 && string2.equals("2.0")) {
                        this._parseTables = XSLT2ParseTables.getInstance();
                    }
                    object2 = this._parseTables.getStdAttrs();
                    for (int j = 0; j < ((HashMap)object2).size(); ++j) {
                        if (!((HashMap)object2).containsKey(string3)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                object2 = new ASTMsg("ILLEGAL_ATTRIBUTE_ERR", (Object)string3, (SimpleNode)expr);
                this.reportError(5, (ASTBaseMsg)object2);
            }
            if (!arrayList.isEmpty()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ASTMsg aSTMsg = new ASTMsg("REQUIRED_ATTR_ERR", (Object)((String)arrayList.get(i)), (SimpleNode)expr);
                    this.reportError(3, aSTMsg);
                }
            }
        }
    }

    public boolean checkAttributeValue(Expr expr, String string2, String string3, String string4, int n2) {
        int n3 = this._parseTables.getAttributeTypeIndex(string3);
        boolean bl = false;
        switch (n3) {
            case 0: {
                bl = this.checkFixedAttributeValues(expr, string2, string3, string4, n2);
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                if (XMLChar.isValidToken(string4)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "'token'", string4, expr);
                this.reportError(n2, aSTMsg);
                bl = false;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case 5: {
                if (this.isValidQName(string4)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "QName", string4, expr);
                this.reportError(n2, aSTMsg);
                bl = false;
                break;
            }
            case 6: {
                String string5 = this.invalidQNames(string4, null);
                if (string5 == null) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_LIST_VALUE_ERR", "QNames", string5, expr);
                this.reportError(n2, aSTMsg);
                bl = false;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
            case 8: {
                switch (string4.length()) {
                    case 0: {
                        bl = false;
                        break;
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = string4.codePointCount(0, 2) == 1;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                if (bl) break;
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "character", string4, expr);
                this.reportError(n2, aSTMsg);
                break;
            }
            case 9: {
                bl = true;
                break;
            }
            case 10: {
                bl = true;
                break;
            }
            case 11: {
                if (XMLChar.isValidNCName(string4)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "NCName", string4, expr);
                this.reportError(n2, aSTMsg);
                bl = false;
                break;
            }
            case 12: {
                if (XMLChar.isValidNmtoken(string4)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "NMTOKEN", string4, expr);
                this.reportError(n2, aSTMsg);
                bl = false;
                break;
            }
            case 13: {
                bl = true;
                break;
            }
            case 14: {
                bl = true;
                break;
            }
            case 15: {
                bl = true;
                break;
            }
            case 16: {
                bl = true;
                break;
            }
            case 17: {
                bl = true;
                break;
            }
            case 18: {
                bl = true;
                break;
            }
            case 19: {
                bl = true;
                break;
            }
            case 20: {
                if (XMLChar.isValidQNameButNotNCName(string4)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "qname-but-not-ncname", string4, expr);
                this.reportError(n2, aSTMsg);
                bl = false;
            }
        }
        return bl;
    }

    private boolean checkFixedAttributeValues(Expr expr, String string2, String string3, String string4, int n2) {
        String[] stringArray = this._parseTables.getFixedAttributeValues(string3);
        String string5 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (string4.equals(stringArray[i])) {
                return true;
            }
            string5 = string5 + "'" + stringArray[i] + "'";
            if (i >= stringArray.length - 1) continue;
            string5 = string5 + " | ";
        }
        Object[] objectArray = new String[]{string2, string3, string4, string5};
        ASTMsg aSTMsg = new ASTMsg("INVALID_FIXED_ATTR_VALUE_ERR", objectArray, (SimpleNode)expr);
        this.reportError(n2, aSTMsg);
        return false;
    }

    boolean isExtension(QName qName) {
        String string2 = qName.getNamespaceURI();
        return string2 != null && !string2.equals("") && !string2.equals("http://www.w3.org/1999/XSL/Transform");
    }

    public ArrayList getAllowedChildren(Expr expr) {
        QName qName = expr.getNodeQName();
        if (expr.getId() == 108) {
            qName = ((DirElemConstructor)expr).getQName();
            return this._parseTables.getAllowedChildrenList(this.parseUtilsInstance.getQName("http://www.w3.org/1999/XSL/Transform", XSL, "element"));
        }
        return this._parseTables.getAllowedChildrenList(qName);
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] checkAllowedChildren(Expr var1_1) {
        var2_2 = var1_1.jjtGetNumChildren();
        var3_3 = new boolean[var2_2];
        var4_4 = var1_1.isForwardsCompatibilityMode();
        var5_5 = this.getAllowedChildren(var1_1);
        var6_6 = var1_1.getNodeQName();
        var7_7 = var1_1.getId();
        if (var7_7 == 108) {
            var6_6 = ((DirElemConstructor)var1_1).getQName();
        }
        block8: for (var8_8 = 0; var8_8 < var2_2; ++var8_8) {
            block20: {
                var9_9 = (Expr)var1_1.jjtGetChild(var8_8);
                var10_10 = var9_9.getId();
                var11_11 = var9_9.getNodeQName();
                if (var10_10 != 108) break block20;
                var11_11 = ((DirElemConstructor)var9_9).getQName();
                if (var9_9.hasAttribute("http://www.w3.org/1999/XSL/Transform", "use-when")) {
                    var12_12 = var9_9.getAttribute("http://www.w3.org/1999/XSL/Transform", "use-when");
                    Expr.parseExpression(this, var9_9, var12_12);
                    if (var12_12 != null && var12_12 != "") {
                        var12_12 = "boolean(" + var12_12 + ")";
                        var9_9.setUseWhen(var12_12);
                        switch (1.$SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult[this.getStaticContext().evaluateUseWhen(this, var9_9).ordinal()]) {
                            case 1: {
                                var1_1.jjtRemoveChild(var8_8);
                                var9_9 = null;
                                --var8_8;
                                --var2_2;
                                continue block8;
                            }
                            case 2: {
                                var3_3[var8_8] = true;
                                continue block8;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                ** GOTO lbl-1000
            }
            switch (1.$SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult[var9_9.parseUseWhen(this).ordinal()]) {
                case 1: {
                    var1_1.jjtRemoveChild(var8_8);
                    var9_9 = null;
                    --var8_8;
                    --var2_2;
                    continue block8;
                }
                case 2: {
                    var3_3[var8_8] = true;
                    continue block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (var4_4 && var10_10 == 16 && null != var11_11 && "http://www.w3.org/1999/XSL/Transform".equals(var11_11.getNamespaceURI())) {
                        if (var7_7 == 3) {
                            var1_1.jjtRemoveChild(var8_8);
                            var9_9 = null;
                            --var8_8;
                            --var2_2;
                            continue block8;
                        }
                        if (this._parseTables.isSequenceConstructor(var7_7)) {
                            if (this.hasFallback(var9_9)) {
                                this.keepFallback(var9_9);
                            } else {
                                this.reportError(var1_1, var9_9);
                            }
                        }
                    }
                    if ((var5_5 == null || var5_5.contains(new Integer(var10_10))) && (var5_5 != null || var2_2 <= 0)) continue block8;
                    if (var4_4 && null != var11_11 && "http://www.w3.org/1999/XSL/Transform".equals(var11_11.getNamespaceURI())) {
                        if (var7_7 == 3) {
                            var1_1.jjtRemoveChild(var8_8);
                            var9_9 = null;
                            --var8_8;
                            --var2_2;
                            continue block8;
                        }
                        if (this._parseTables.isSequenceConstructor(var7_7) && this.hasFallback(var9_9)) {
                            this.keepFallback(var9_9);
                            continue block8;
                        }
                    }
                    this.reportError(var1_1, var9_9);
                }
            }
        }
        return var3_3;
    }

    private boolean hasFallback(Expr expr) {
        int n2 = expr.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            int n3 = expr2.getId();
            if (n3 != 200) continue;
            return true;
        }
        return false;
    }

    private void keepFallback(Expr expr) {
        int n2 = expr.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            int n3 = expr2.getId();
            if (n3 == 200) continue;
            expr.jjtRemoveChild(i);
            expr2 = null;
            --i;
            --n2;
        }
    }

    private void reportError(Expr expr, Expr expr2) {
        QName qName = expr.getNodeQName();
        if (expr.getId() == 108) {
            qName = ((DirElemConstructor)expr).getQName();
        }
        int n2 = expr2.getId();
        QName qName2 = expr2.getNodeQName();
        String[] stringArray = new String[2];
        if (n2 == 108) {
            qName2 = ((DirElemConstructor)expr2).getQName();
        }
        if (qName2 == null) {
            return;
        }
        stringArray[0] = qName.getPrefix().equals("") ? "<" : "<" + qName.getPrefix() + ":";
        stringArray[0] = stringArray[0] + qName.getLocalPart() + ">";
        stringArray[1] = qName2.getPrefix().equals("") ? "<" : "<" + qName2.getPrefix() + ":";
        stringArray[1] = stringArray[1] + qName2.getLocalPart() + ">";
        ASTMsg aSTMsg = new ASTMsg("INVALID_CHILD_ERR", stringArray[0], stringArray[1], expr);
        this.reportError(3, aSTMsg);
    }

    public void checkNodesOrder(Expr expr) {
        if (expr.getChildren() == null) {
            return;
        }
        int n2 = expr.getId();
        boolean bl = expr.isForwardsCompatibilityMode();
        Iterator iterator = expr.getChildren().iterator();
        switch (n2) {
            case 3: {
                Object object2;
                boolean bl2 = false;
                boolean bl3 = false;
                Object object3 = null;
                while (iterator.hasNext()) {
                    object2 = (Expr)iterator.next();
                    int n3 = ((SimpleNode)object2).getId();
                    if (n3 == 228 && ((Text)object2).isIgnore()) continue;
                    if (n3 == 221 && ((Expr)object2).getRealParent() == expr) {
                        if (!bl3) continue;
                        object3 = object2;
                        break;
                    }
                    bl3 = true;
                }
                if (object3 == null) break;
                object2 = new ASTMsg("ERR_ORDER_IMPORT", (SimpleNode)object3);
                this.reportError(3, (ASTBaseMsg)object2);
                break;
            }
            case 201: 
            case 202: 
            case 209: {
                Object object4;
                boolean bl4 = false;
                boolean bl5 = false;
                while (iterator.hasNext()) {
                    object4 = (Expr)iterator.next();
                    int n4 = ((SimpleNode)object4).getId();
                    if (n4 == 228 && ((Text)object4).isIgnore()) continue;
                    if (n4 != 211) {
                        bl4 = true;
                    } else if (bl4) {
                        bl5 = true;
                    }
                    if (!bl5 || !bl || !this.hasFallback((Expr)object4)) continue;
                    this.keepFallback((Expr)object4);
                    bl5 = false;
                }
                if (!bl5) break;
                object4 = new ASTMsg("SORT_POSITION_ERR", expr.getNodeQName());
                this.reportError(3, (ASTBaseMsg)object4);
                break;
            }
            case 197: {
                Object object5;
                int n5 = 0;
                int n6 = 0;
                while (iterator.hasNext()) {
                    object5 = (Expr)iterator.next();
                    int n7 = ((SimpleNode)object5).getId();
                    if (n7 == 228 && ((Text)object5).isIgnore()) continue;
                    if (n7 == 215) {
                        if (n6 > 0) {
                            ASTMsg aSTMsg = new ASTMsg("WHEN_ELEMENT_ERR");
                            this.reportError(3, aSTMsg);
                        }
                        ++n5;
                        continue;
                    }
                    ++n6;
                }
                if (n5 == 0) {
                    object5 = new ASTMsg("MISSING_WHEN_ERR");
                    this.reportError(3, (ASTBaseMsg)object5);
                }
                if (n6 <= true) break;
                object5 = new ASTMsg("MULTIPLE_OTHERWISE_ERR");
                this.reportError(3, (ASTBaseMsg)object5);
                break;
            }
            case 32: 
            case 227: {
                boolean bl6 = false;
                boolean bl7 = false;
                Expr expr2 = null;
                while (iterator.hasNext()) {
                    expr2 = (Expr)iterator.next();
                    int n8 = expr2.getId();
                    if (n8 == 228 && ((Text)expr2).isIgnore()) continue;
                    if (n8 != 34) {
                        bl6 = true;
                    } else if (bl6) {
                        bl7 = true;
                    }
                    if (!bl7 || !bl || !this.hasFallback(expr2)) continue;
                    this.keepFallback(expr2);
                    bl7 = false;
                }
                if (!bl7) break;
                String string2 = n2 == 32 ? "xsl:function" : "xsl:template";
                ASTMsg aSTMsg = new ASTMsg("PARAM_POSITION_ERR", string2);
                this.reportError(3, aSTMsg);
                break;
            }
        }
    }

    public Expr parseExpression(ASTBuildingContext aSTBuildingContext, Expr expr, String string2) {
        Expr expr2 = null;
        try {
            this._expressionFactory.setExprContext(expr);
            expr2 = this._expressionFactory.createExpr(aSTBuildingContext, string2);
            if (expr2.getId() == 40 && expr2.jjtGetNumChildren() == 1) {
                expr2 = (Expr)expr2.jjtGetChild(0);
            }
            expr2.jjtSetParent(expr);
        }
        catch (XPath20Exception xPath20Exception) {
            if (this._debug) {
                xPath20Exception.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)string2, (SimpleNode)expr));
        }
        return expr2;
    }

    public TypeExpr parseSequenceTypeExpression(Expr expr, String string2) {
        TypeExpr typeExpr = null;
        try {
            this._expressionFactory.setExprContext(expr);
            this._expressionFactory.setContext(this._staticContext);
            XPath xPath = new XPath((ASTBuildingContext)this, new StringReader(string2));
            try {
                QName qName;
                String string3;
                TypeExpr typeExpr2 = xPath.SequenceTypeStandalone();
                if (string2.indexOf(58) == -1 && !(string3 = expr.getDefaultNS()).equals("") && (qName = typeExpr2.getTypeName()) != null) {
                    QName qName2 = this._expressionFactory.createQName(string3, qName.getLocalPart(), qName.getPrefix());
                    typeExpr2.setTypeName(qName2);
                }
                typeExpr2.jjtSetParent(null);
                typeExpr = typeExpr2;
            }
            catch (ParseException parseException) {
                throw new XPath20Exception(parseException);
            }
            if (typeExpr.getId() == 40 && typeExpr.jjtGetNumChildren() == 1) {
                typeExpr = (TypeExpr)typeExpr.jjtGetChild(0);
            }
            typeExpr.jjtSetParent(expr);
        }
        catch (XPath20Exception xPath20Exception) {
            if (this._debug) {
                xPath20Exception.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)string2, (SimpleNode)expr));
        }
        return typeExpr;
    }

    public Expr parseExpression(Expr expr, String string2, String string3) {
        String string4 = expr.getAttribute(string2);
        if (string4.length() == 0 && string3 != null) {
            string4 = string3;
        }
        return this.parseExpression(this, expr, string4);
    }

    public String getExprString() {
        return this.exprString;
    }

    public Expr parseExpression(String string2) {
        Expr expr = null;
        this.exprString = string2;
        try {
            expr = this._expressionFactory.createExpr(this, string2);
            if (expr.getId() == 40 && expr.jjtGetNumChildren() == 1) {
                expr = (Expr)expr.jjtGetChild(0);
            }
        }
        catch (XPath20Exception xPath20Exception) {
            if (this._debug) {
                xPath20Exception.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", string2));
        }
        return expr;
    }

    public Expr parsePattern(Expr expr, String string2) {
        Expr expr2 = null;
        try {
            this._expressionFactory.setExprContext(expr);
            expr2 = this._expressionFactory.createPattern(this, this._staticContext, string2);
            if (null != expr2) {
                expr2.jjtSetParent(expr);
            }
        }
        catch (XPath20Exception xPath20Exception) {
            if (this._debug) {
                xPath20Exception.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)string2, (SimpleNode)expr));
        }
        return expr2;
    }

    public Expr parsePattern(Expr expr, String string2, String string3) {
        String string4 = expr.getAttribute(string2);
        if (string4 != null && string4.startsWith("//")) {
            String string5;
            int n2 = string4.indexOf("key(");
            if (n2 == -1) {
                n2 = string4.indexOf("id(");
            }
            String string6 = string5 = n2 == -1 ? string4.substring(n2 + 1) : string4.substring(n2);
            if (string5.indexOf("key(") > -1 || string5.indexOf("id(") > -1) {
                ASTMsg aSTMsg = new ASTMsg("ERR_TOP_PATTERN", string4);
                this.reportError(3, aSTMsg);
            }
        }
        if (string4.length() == 0 && string3 != null) {
            string4 = string3;
        }
        return this.parsePattern(expr, string4);
    }

    public boolean errorsFound() {
        return this._reporter.errorsFound();
    }

    public void printErrors() {
        this._reporter.printErrors();
    }

    public void printWarnings() {
        this._reporter.printWarnings();
    }

    @Override
    public void reportError(int n2, ASTBaseMsg aSTBaseMsg) {
        this._reporter.report(n2, aSTBaseMsg);
    }

    public void reportError(int n2, ASTBaseMsg aSTBaseMsg, Throwable throwable) {
        this._reporter.report(n2, aSTBaseMsg, throwable);
    }

    @Override
    public void reportError(int n2, String string2) {
        int n3 = this._locator.getLineNumber();
        int n4 = this._locator.getColumnNumber();
        ASTMsg aSTMsg = new ASTMsg(string2, n3, n4, (Object)null);
        this.reportError(n2, aSTMsg);
    }

    public void reportError(int n2, String string2, Throwable throwable) {
        this._reporter.report(n2, string2, throwable);
    }

    public Vector getErrors() {
        return this._reporter.getErrors();
    }

    public Vector getWarnings() {
        return this._reporter.getWarnings();
    }

    @Override
    public void startDocument() {
        this._root = null;
        this._target = null;
        this._prefixMapping = null;
        this._parentStack = new Stack();
        if (this._locator != null) {
            this._entityInfoStack = new Stack();
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String string2, String string3) {
        if (this._prefixMapping == null) {
            this._prefixMapping = new HashMap();
        }
        this._prefixMapping.put(string2, string3);
    }

    @Override
    public void endPrefixMapping(String string2) {
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        Expr expr;
        int n2 = string4.lastIndexOf(58);
        String string5 = n2 == -1 ? "" : string4.substring(0, n2);
        Expr expr2 = this._root == null ? null : (Expr)this._parentStack.peek();
        if (string2 == null) {
            string2 = "";
        }
        if ((expr = this.makeInstance(string2, string5, string3, attributes2, expr2)) == null) {
            ASTMsg aSTMsg = new ASTMsg("ELEMENT_PARSE_ERR", string5 + ':' + string3);
            throw new SAXException(aSTMsg.toString());
        }
        if (this._root == null) {
            this._rootNamespaceDef = this._prefixMapping != null && this._prefixMapping.containsValue("http://www.w3.org/1999/XSL/Transform");
            this._root = expr;
        } else {
            expr2.jjtAppendChild(this, expr);
            expr.jjtSetParent(expr2);
        }
        this._prefixMapping = null;
        this._parentStack.push(expr);
        ++this._elementDepthInEntity;
        expr.setIsTopLevelElementInEntity(this._elementDepthInEntity == 1);
    }

    @Override
    public void endElement(String string2, String string3, String string4) {
        this._parentStack.pop();
        --this._elementDepthInEntity;
    }

    private void setStandardAttributes(String string2, Expr expr, Attributes attributes2, Expr expr2) {
        int n2 = attributes2.getLength();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < n2; ++i) {
            ASTMsg aSTMsg;
            String[] stringArray;
            String string5;
            String string6 = attributes2.getURI(i);
            if (string6 == null) {
                string6 = "";
            }
            if ((string5 = attributes2.getLocalName(i)) == null) {
                string5 = "";
            }
            if (string6.equals("http://www.w3.org/XML/1998/namespace") && string5.equals("base")) {
                expr.setBaseURI(attributes2.getValue(i));
                bl3 = true;
                continue;
            }
            if ((!string6.equals("") || string2 == null || !string2.equals("http://www.w3.org/1999/XSL/Transform")) && !string6.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            if (string5.equals("version")) {
                expr.setProgramVersion(attributes2.getValue(i));
                bl = true;
                continue;
            }
            if (string5.equals("xpath-default-namespace")) {
                expr.setDefaultElementTypeNamespace(attributes2.getValue(i));
                bl2 = true;
                continue;
            }
            if (string5.equals("exclude-result-prefixes")) {
                string3 = attributes2.getValue(i);
                if (this.invalidNCNames(string3, stringArray = new String[]{"#default"}) == null || string3.equals("#all")) continue;
                aSTMsg = new ASTMsg("INVALID_NCNAME_ERR", (Object)string3, this);
                this.reportError(3, aSTMsg);
                continue;
            }
            if (!string5.equals("extension-element-prefixes") || this.invalidNCNames(string4 = attributes2.getValue(i), stringArray = new String[]{"#default"}) == null) continue;
            aSTMsg = new ASTMsg("INVALID_NCNAME_ERR", (Object)string4, this);
            this.reportError(3, aSTMsg);
        }
        if (!bl && null != expr2 && expr.getId() != 3) {
            expr.setProgramVersion(expr2.getProgramVersion());
        }
        if (!bl2) {
            if (null == expr2 || expr.getId() == 3) {
                expr.setDefaultElementTypeNamespace("");
            } else {
                expr.setDefaultElementTypeNamespace(expr2.getDefaultNS());
            }
        }
        if (expr.getId() == 3) {
            expr.setExcludeResultPrefixes(this, string3, null);
            expr.setExtensionElemPrefixes(this, string4, null);
        } else {
            expr.setExcludeResultPrefixes(this, string3, expr2);
            expr.setExtensionElemPrefixes(this, string4, expr2);
        }
        expr.excludePrefixes(this);
        if (!bl3 && !this._entityInfoStack.empty() && this._locator != null) {
            expr.setBaseURI(this._locator.getSystemId());
            bl3 = true;
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        Text text2;
        String string2 = new String(cArray, n2, n3);
        Expr expr = (Expr)this._parentStack.peek();
        if (string2.length() == 0) {
            return;
        }
        if (expr instanceof Text) {
            Text text3 = (Text)expr;
            text3.setText(string2);
            this.updateLineInfo(text3);
            return;
        }
        if (Util.trimWhitespace(string2).length() != 0 && expr instanceof XTQProgram) {
            if (this._isXSLT20) {
                this.reportError(2, "STYLESHEET_HAS_TEXT_NODE");
            } else {
                this.reportError(3, "ILLEGAL_TEXT_NODE_ERR");
            }
        }
        if (expr instanceof XTQProgram) {
            return;
        }
        Expr expr2 = expr.lastChild();
        if (expr2 != null && expr2 instanceof Text && !(text2 = (Text)expr2).isTextElement() && n3 >= 1) {
            text2.setText(string2);
            this.updateLineInfo(text2);
            return;
        }
        text2 = new Text(string2, expr.getProgramVersion());
        this.setLineInfo(text2);
        expr.jjtAppendChild(this, text2);
    }

    private String getTokenValue(String string2) {
        int n2 = string2.indexOf(34);
        int n3 = string2.lastIndexOf(34);
        if (n2 < 0) {
            int n4 = string2.indexOf(39);
            int n5 = string2.lastIndexOf(39);
            if (n4 < 0) {
                return string2;
            }
            return string2.substring(n4 + 1, n5);
        }
        return string2.substring(n2 + 1, n3);
    }

    @Override
    public void processingInstruction(String string2, String string3) {
        if (this._target == null && string2.equals("xml-stylesheet")) {
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            StringTokenizer stringTokenizer = Util.whitespaceTokenize(string3);
            while (stringTokenizer.hasMoreElements()) {
                String string8 = (String)stringTokenizer.nextElement();
                if (string8.startsWith("href")) {
                    string4 = this.getTokenValue(string8);
                    continue;
                }
                if (string8.startsWith("media")) {
                    string5 = this.getTokenValue(string8);
                    continue;
                }
                if (string8.startsWith("title")) {
                    string6 = this.getTokenValue(string8);
                    continue;
                }
                if (!string8.startsWith("charset")) continue;
                string7 = this.getTokenValue(string8);
            }
            if (!(this._PImedia != null && !this._PImedia.equals(string5) || this._PItitle != null && !this._PImedia.equals(string6) || this._PIcharset != null && !this._PImedia.equals(string7))) {
                this._target = string4;
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
    }

    @Override
    public void skippedEntity(String string2) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public boolean isReservedNamespace(String string2) {
        return this._parseTables.hasReservedNamespace(string2);
    }

    public Properties getMergedXslOuputProperties(String string2) {
        XTQProgram xTQProgram = this.getTopLevelXTQProgram();
        Properties properties = xTQProgram.getEffectiveMergedXslOutputProperties(string2);
        return properties;
    }

    public void AppendExpandedQName(StringBuffer stringBuffer, String string2) {
        int n2 = string2.lastIndexOf(58);
        if (n2 != -1) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            String string5 = null;
            string5 = this._staticContext.getNamespaceURI(string3);
            if (string5 == null || string5.length() == 0) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append('{');
                stringBuffer.append(string5);
                stringBuffer.append('}');
                stringBuffer.append(string4);
            }
        } else {
            String string6 = string2;
            String string7 = this._staticContext.getNamespaceURI("");
            if (!"".equals(string7)) {
                stringBuffer.append('{');
                stringBuffer.append(string7);
                stringBuffer.append('}');
            }
            stringBuffer.append(string6);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n2 = stringArray.length;
        int n3 = 0;
        boolean bl = false;
        File file = null;
        String string2 = "2.0";
        while (n2 > 0) {
            if (stringArray[n3].equals("-dumptree")) {
                bl = true;
                ++n3;
                --n2;
                continue;
            }
            if ("-file".equalsIgnoreCase(stringArray[n3])) {
                --n2;
                file = new File(stringArray[++n3]);
                ++n3;
                --n2;
                continue;
            }
            if ("-xsltversion".equalsIgnoreCase(stringArray[n3])) {
                --n2;
                string2 = stringArray[++n3];
                ++n3;
                --n2;
                continue;
            }
            if (stringArray[n3].endsWith(".xslt") || stringArray[n3].endsWith(".xsl")) {
                System.out.println("Running test for: " + stringArray[n3]);
                file = new File(stringArray[n3]);
                ++n3;
                --n2;
                continue;
            }
            if ("-catalog".equalsIgnoreCase(stringArray[n3])) {
                System.err.println("-catalog not yet implemented");
                System.exit(-1);
                continue;
            }
            System.out.println("XSLTParser [-dumptree] -file {filename}");
        }
        XTQProgram xTQProgram = XSLTParser.makeAST(file, string2);
        if (null != xTQProgram) {
            xTQProgram.dump("|", System.out);
        } else {
            System.err.println("Could not process XSLT file!");
        }
    }

    private static XTQProgram makeAST(File file, String string2) {
        InputSource inputSource = new InputSource(file.getAbsolutePath());
        return XSLTParser.makeAST(inputSource, string2);
    }

    private static XTQProgram makeAST(InputSource inputSource, String string2) {
        XSLTParser xSLTParser = new XSLTParser(string2.equals("2.0"), new XStaticContext());
        xSLTParser.init();
        return xSLTParser.makeAST(inputSource);
    }

    public XTQProgram makeAST(InputSource inputSource) {
        XMLReader xMLReader = this.getXMLReader();
        Expr expr = xMLReader == null ? this.parse(inputSource, null) : this.parse(xMLReader, inputSource, null);
        if (!this.errorsFound() && expr != null) {
            XTQProgram xTQProgram = this.makeStylesheet(expr);
            xTQProgram.giveHighestImportPrecedence();
            this.setTopLevelXTQProgram(xTQProgram);
            xTQProgram.setSystemId(inputSource.getSystemId());
            xTQProgram.setParentXTQProgram(null);
            this.setCurrentXTQProgram(xTQProgram);
            this.setCurrentImportPrecedence(xTQProgram.getImportPrecedence());
            this.createAST(xTQProgram);
            xTQProgram.getImportPrecedence().computePrecedenceOnImportTree();
            return xTQProgram;
        }
        this.printWarnings();
        this.printErrors();
        return null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._reporter.setErrorHandler(errorHandler);
    }

    public boolean getSecureProcessing() {
        return this._isSecureProcessing;
    }

    public void setSecureProcessing(boolean bl) {
        this._isSecureProcessing = bl;
    }

    public boolean isValidQName(String string2) {
        boolean bl = !this._xml10Only ? XML11Char.isXML11ValidQName(string2) : XMLChar.isValidQName(string2);
        return bl;
    }

    public boolean isValidNCName(String string2) {
        boolean bl = !this._xml10Only ? XML11Char.isXML11ValidNCName(string2) : XMLChar.isValidNCName(string2);
        return bl;
    }

    public String invalidQNames(String string2, String[] stringArray) {
        String string3 = this.invalidNames(true, string2, stringArray);
        return string3;
    }

    public String invalidNCNames(String string2, String[] stringArray) {
        String string3 = this.invalidNames(false, string2, stringArray);
        return string3;
    }

    private String invalidNames(boolean bl, String string2, String[] stringArray) {
        String string3 = null;
        if (string2 != null && !string2.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if ((!bl || this.isValidQName(string4)) && (bl || this.isValidNCName(string4))) continue;
                boolean bl2 = false;
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].equals(string4)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) continue;
                if (string3 == null) {
                    string3 = string4;
                    continue;
                }
                string3 = string3 + ' ';
                string3 = string3 + string4;
            }
        }
        return string3;
    }

    public void checkForStandardAttrsOnLRE(Expr expr, QName qName, Attributes attributes2) {
        if (expr.getId() == 108) {
            int n2;
            HashMap hashMap = this._parseTables.getStdAttrs();
            String[] stringArray = this._parseTables.getRequiredAttrsForLRE();
            int n3 = stringArray != null ? stringArray.length : 0;
            boolean[] blArray = new boolean[n3];
            String[] stringArray2 = this._parseTables.getOptAttrsForLRE();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n4 = attributes2.getLength();
            for (n2 = 0; n2 < n4; ++n2) {
                string2 = attributes2.getQName(n2);
                string3 = attributes2.getLocalName(n2);
                string4 = attributes2.getURI(n2);
                if (!this.isXSLT20()) continue;
                if (string4 != null && string4.equals("http://www.w3.org/1999/XSL/Transform")) {
                    boolean bl = false;
                    if (hashMap != null && hashMap.containsKey(string3)) {
                        bl = true;
                    } else {
                        int n5;
                        if (stringArray != null) {
                            for (n5 = 0; n5 < stringArray.length && !bl; ++n5) {
                                if (!stringArray[n5].equals(string3)) continue;
                                bl = true;
                                if (blArray[n5]) continue;
                                blArray[n5] = true;
                                --n3;
                            }
                        }
                        if (!bl && stringArray2 != null) {
                            for (n5 = 0; n5 < stringArray2.length && !bl; ++n5) {
                                if (!stringArray2[n5].equals(string3)) continue;
                                bl = true;
                            }
                        }
                    }
                    if (bl) continue;
                    ASTMsg aSTMsg = new ASTMsg("ATTR_ERR", (Object)string2, (SimpleNode)expr);
                    this.reportError(3, aSTMsg);
                    continue;
                }
                if (!string2.startsWith("xml") && string2.indexOf(58) > 0 && attributes2.getURI(n2).equals("http://www.w3.org/1999/XSL/Transform")) continue;
            }
            if (n3 != 0) {
                for (n2 = 0; n2 < blArray.length; ++n2) {
                    if (blArray[n2]) continue;
                    ASTMsg aSTMsg = new ASTMsg("REQUIRED_ATTR_ERR", (Object)("xsl:" + stringArray[n2]), (SimpleNode)expr);
                    this.reportError(3, aSTMsg);
                }
            }
        }
    }

    public void checkForNullNS(Expr expr) {
        QName qName;
        String string2;
        String string3;
        if (expr.getId() == 108 && ((string3 = expr.lookupNamespace(string2 = (qName = ((DirElemConstructor)expr).getQName()).getPrefix())) == null || string3 == "")) {
            ASTMsg aSTMsg = new ASTMsg("NULL_NS_TOPLEVEL_CHILD", (Object)qName, (SimpleNode)expr);
            this.reportError(3, aSTMsg);
        }
    }

    public void checkAttributeLength(Expr expr, String string2, String string3) {
        if (expr.getId() == 206 && string2.equals("grouping-separator") && !string3.startsWith("{") && string3.codePointCount(0, string3.length()) > 1) {
            ASTMsg aSTMsg = new ASTMsg("NUMBER_GROUPSEPARATOR_ERR", string2);
            this.reportError(3, aSTMsg);
        }
    }

    @Override
    public Reporter getReporter() {
        return this._reporter;
    }

    public boolean isExtensionNamespace(String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (this._extensionNamespaces == null) {
            this._extensionNamespaces = new HashSet();
            this._extensionNamespaces.add("http://www.ibm.com/xmlns/prod/xltxe-j");
            this._extensionNamespaces.add("http://xml.apache.org/xalan");
            this._extensionNamespaces.add("http://xml.apache.org/xslt");
        }
        return this._extensionNamespaces.contains(string2);
    }

    public void hasDuplicateVarDeclaration(VariableBase variableBase) {
        QName qName = variableBase.getQName();
        if ((variableBase.getId() == 29 || variableBase.getId() == 34) && variableBase.isDuplicate()) {
            ASTMsg aSTMsg = new ASTMsg("VAR_REDEF_ERR", qName);
            this.reportError(3, aSTMsg);
        }
    }

    @Override
    public void startDTD(String string2, String string3, String string4) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String string2) throws SAXException {
        if (this._entityInfoStack != null) {
            this._entityInfoStack.push(new Integer(this._elementDepthInEntity));
        }
    }

    @Override
    public void endEntity(String string2) throws SAXException {
        this._elementDepthInEntity = (Integer)this._entityInfoStack.pop();
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
    }

    public void setExpressionFactory(ExpressionFactoryImpl expressionFactoryImpl) {
        this._expressionFactory = expressionFactoryImpl;
    }

    public PSVIProvider getPsviProvider() {
        return this._psviProvider;
    }

    public void setPsviProvider(PSVIProvider pSVIProvider) {
        this._psviProvider = pSVIProvider;
    }

    protected void setLineInfo(Expr expr) {
        if (this._locator != null) {
            expr.setLineInfo(LineInfo.createLineInfo(this._locator));
        }
    }

    protected void updateLineInfo(Expr expr) {
    }

    protected Expr getCurrentElement() {
        return (Expr)this._parentStack.peek();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult;

        static {
            $SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult = new int[XStaticContext.UseWhenResult.values().length];
            try {
                1.$SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult[XStaticContext.UseWhenResult.FALSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult[XStaticContext.UseWhenResult.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

