/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.IntVector;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TraceXSLTParser
extends XSLTParser {
    private static final char[] systemEOL = System.getProperty("line.separator").toCharArray();
    private static final char[] windowsEOL = new char[]{'\r', '\n'};
    private static final char[] unixEOL = new char[]{'\n'};
    private static final int SHIFT = 1;
    private static final int UNDEFINED = -1;
    private Locator m_locator;
    private Vector<Node> m_nodes;
    private StringBuffer m_documentChars;
    private IntVector m_lineOffsetTable;

    public TraceXSLTParser() {
    }

    public TraceXSLTParser(boolean bl, XStaticContext xStaticContext) {
        super(bl, xStaticContext);
    }

    public TraceXSLTParser(boolean bl, ExpressionFactoryImpl expressionFactoryImpl) {
        super(bl, expressionFactoryImpl);
    }

    @Override
    public Expr parse(XMLReader xMLReader, InputSource inputSource, Expr expr) {
        try {
            Object object2;
            Object object3;
            Reader reader = inputSource.getCharacterStream();
            if (reader == null) {
                object3 = inputSource.getByteStream();
                if (object3 == null) {
                    object2 = inputSource.getSystemId();
                    File file = new File((String)object2);
                    if (file.exists()) {
                        reader = new FileReader(file);
                    } else {
                        URI uRI = new URI((String)object2);
                        object3 = uRI.toURL().openStream();
                        reader = new InputStreamReader((InputStream)object3);
                    }
                } else {
                    reader = new InputStreamReader((InputStream)object3);
                }
            }
            this.setup();
            reader = new BufferedReader(reader, this.m_documentChars);
            object3 = new InputSource(reader);
            ((InputSource)object3).setSystemId(inputSource.getSystemId());
            ((InputSource)object3).setPublicId(inputSource.getPublicId());
            object2 = super.parse(xMLReader, (InputSource)object3, expr);
            return object2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ASTMsg aSTMsg = new ASTMsg("ERR_UNABLE_TO_RETRIEVE_RESOURCE", (Object)inputSource.getSystemId(), (SimpleNode)expr);
            this.reportError(2, aSTMsg, (Throwable)fileNotFoundException);
        }
        catch (URISyntaxException uRISyntaxException) {
            ASTMsg aSTMsg = new ASTMsg("ERR_UNABLE_TO_RETRIEVE_RESOURCE", (Object)inputSource.getSystemId(), (SimpleNode)expr);
            this.reportError(2, aSTMsg, (Throwable)uRISyntaxException);
        }
        catch (IOException iOException) {
            ASTMsg aSTMsg = new ASTMsg("ERR_UNABLE_TO_RETRIEVE_RESOURCE", (Object)inputSource.getSystemId(), (SimpleNode)expr);
            this.reportError(2, aSTMsg, (Throwable)iOException);
        }
        return null;
    }

    private void setup() {
        this.m_nodes = new Vector();
        this.m_documentChars = new StringBuffer(1000);
        this.m_lineOffsetTable = new IntVector();
        this.m_lineOffsetTable.addElement(0);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
        super.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() {
        super.startDocument();
    }

    @Override
    public void endDocument() {
        super.endDocument();
    }

    @Override
    public void startPrefixMapping(String string2, String string3) {
        super.startPrefixMapping(string2, string3);
    }

    @Override
    public void endPrefixMapping(String string2) {
        super.endPrefixMapping(string2);
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        int n2 = this.m_locator.getLineNumber();
        int n3 = this.m_locator.getColumnNumber();
        this.newNode(n2, n3, 1);
        super.startElement(string2, string3, string4, attributes2);
    }

    @Override
    public void endElement(String string2, String string3, String string4) {
        int n2;
        Expr expr = this.getCurrentElement();
        int n3 = this.m_locator.getLineNumber();
        Node node2 = this.newNode(n3, n2 = this.m_locator.getColumnNumber(), 1);
        if (node2 != null) {
            this.setEndTagLineInfo(expr);
        }
        super.endElement(string2, string3, string4);
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        int n4 = this.m_locator.getLineNumber();
        int n5 = this.m_locator.getColumnNumber();
        this.newNode(n4, n5, 2);
        super.characters(cArray, n2, n3);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
        int n4 = this.m_locator.getLineNumber();
        int n5 = this.m_locator.getColumnNumber();
        int n6 = this.numCharsToEOL(n4 - 1) + (n5 - 1);
        if (0 <= n6 && n6 < this.m_documentChars.length()) {
            char c = this.m_documentChars.charAt(n6);
            while (c != '>' && c != '\r' && c != '\n' && n6 < this.m_documentChars.length() - 1) {
                ++n5;
                c = this.m_documentChars.charAt(++n6);
            }
            if (c == '>') {
                ++n6;
                ++n5;
            }
        }
        this.newNode(n4, n5, 2);
        super.ignorableWhitespace(cArray, n2, n3);
    }

    @Override
    public void processingInstruction(String string2, String string3) {
        int n2 = this.m_locator.getLineNumber();
        int n3 = this.m_locator.getColumnNumber();
        int n4 = this.numCharsToEOL(n2 - 1) + (n3 - 1);
        if (0 <= n4 && n4 < this.m_documentChars.length()) {
            char c = this.m_documentChars.charAt(n4);
            while (c != '>' && c != '\r' && c != '\n' && n4 < this.m_documentChars.length()) {
                ++n3;
                c = this.m_documentChars.charAt(++n4);
            }
            if (c == '>') {
                ++n4;
                ++n3;
            }
        }
        this.newNode(n2, n3, 2);
        super.processingInstruction(string2, string3);
    }

    @Override
    public void skippedEntity(String string2) {
        super.skippedEntity(string2);
    }

    @Override
    protected void setLineInfo(Expr expr) {
        expr.setLineInfo(this.createLineInfo());
    }

    @Override
    protected void updateLineInfo(Expr expr) {
        LineInfo lineInfo = expr.getLineInfo();
        if (lineInfo == null) {
            lineInfo = this.createLineInfo();
        } else {
            Node node2 = this.m_nodes.lastElement();
            if (node2 != null) {
                lineInfo = new LineInfo(lineInfo.getSystemID(), lineInfo.getPublicID(), lineInfo.getStartLine(), lineInfo.getStartColumn(), node2.m_line2, node2.m_lineOffset2, lineInfo.getStartOffset(), node2.m_absOffset2);
            }
        }
        expr.setLineInfo(lineInfo);
    }

    private void setEndTagLineInfo(Expr expr) {
        expr.setEndTagLineInfo(this.createLineInfo());
    }

    private LineInfo createLineInfo() {
        LineInfo lineInfo = null;
        Node node2 = this.m_nodes.lastElement();
        if (node2 != null) {
            lineInfo = new LineInfo(this.m_locator.getSystemId(), this.m_locator.getPublicId(), node2.m_line1, node2.m_lineOffset1, node2.m_line2, node2.m_lineOffset2, node2.m_absOffset1, node2.m_absOffset2);
        }
        return lineInfo;
    }

    private void updateLineOffsets() {
        int n2;
        int n3 = this.m_documentChars.length();
        int n4 = this.m_lineOffsetTable.elementAt(this.m_lineOffsetTable.size() - 1);
        int n5 = n2 = n4 == 0 ? n4 : n4 + 1;
        while (n2 < n3) {
            block12: {
                int n6;
                block11: {
                    block10: {
                        if (n2 + systemEOL.length - 1 < n3) {
                            for (n6 = 0; n6 < systemEOL.length; ++n6) {
                                if (n3 > n2 + n6 && this.m_documentChars.charAt(n2 + n6) == systemEOL[n6]) {
                                    continue;
                                }
                                break block10;
                            }
                            this.m_lineOffsetTable.addElement(n2 += systemEOL.length - 1);
                            ++n2;
                            continue;
                        }
                    }
                    if (n2 + windowsEOL.length - 1 < n3) {
                        for (n6 = 0; n6 < windowsEOL.length; ++n6) {
                            if (n3 > n2 + n6 && this.m_documentChars.charAt(n2 + n6) == windowsEOL[n6]) {
                                continue;
                            }
                            break block11;
                        }
                        this.m_lineOffsetTable.addElement(n2 += windowsEOL.length - 1);
                        ++n2;
                        continue;
                    }
                }
                if (n2 + unixEOL.length - 1 < n3) {
                    for (n6 = 0; n6 < unixEOL.length; ++n6) {
                        if (n3 > n2 + n6 && this.m_documentChars.charAt(n2 + n6) == unixEOL[n6]) {
                            continue;
                        }
                        break block12;
                    }
                    this.m_lineOffsetTable.addElement(n2 += unixEOL.length - 1);
                    ++n2;
                    continue;
                }
            }
            ++n2;
        }
    }

    private final int numCharsToEOL(int n2) {
        int n3 = n2 < 0 || this.m_lineOffsetTable.size() <= n2 ? -1 : this.m_lineOffsetTable.elementAt(n2);
        return n3;
    }

    private Node newNode(int n2, int n3, int n4) {
        int n5 = this.m_nodes.size() - 1;
        if (0 <= n5) {
            Node node2 = this.m_nodes.elementAt(n5);
            if (node2.m_line2 < n2 || node2.m_lineOffset2 < n3) {
                Node node3 = new Node(n2, n3, n4);
                node3.m_line1 = node2.m_line2;
                node3.m_lineOffset1 = node2.m_lineOffset2;
                node3.setAbsOffset1(node2.m_absOffset2);
                this.m_nodes.add(node3);
                return node3;
            }
            return null;
        }
        Node node4 = new Node(n2, n3, n4);
        node4.m_line1 = node4.m_line2;
        int n6 = 1;
        for (int i = n3 - 2; 1 < i; --i) {
            char c;
            int n7 = this.numCharsToEOL(node4.m_line1 - 1) + (i - 1);
            if (0 > n7 || n7 >= this.m_documentChars.length() || (c = this.m_documentChars.charAt(n7)) != '<' && c != '>') continue;
            n6 = i - 1;
            break;
        }
        node4.m_lineOffset1 = n6;
        node4.m_lineOffset1 = node4.m_lineOffset1 + 0;
        node4.setAbsOffset1(this.numCharsToEOL(node4.m_line1 - 1) + (n6 - 1));
        this.m_nodes.add(node4);
        return node4;
    }

    private class BufferedReader
    extends Reader {
        private Reader m_reader;
        private StringBuffer m_buffer;

        public BufferedReader(Reader reader, StringBuffer stringBuffer) {
            this.m_reader = reader;
            this.m_buffer = stringBuffer;
        }

        @Override
        public void close() throws IOException {
            this.m_reader.close();
        }

        @Override
        public int read() throws IOException {
            int n2 = this.m_reader.read();
            if (n2 != -1) {
                this.m_buffer.append((char)n2);
                TraceXSLTParser.this.updateLineOffsets();
            }
            return n2;
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            int n4 = this.m_reader.read(cArray, n2, n3);
            if (n4 > 0) {
                this.m_buffer.append(cArray, n2, n4);
                TraceXSLTParser.this.updateLineOffsets();
            }
            return n4;
        }

        @Override
        public int read(char[] cArray) throws IOException {
            int n2 = this.m_reader.read(cArray);
            if (n2 > 0) {
                this.m_buffer.append(cArray, 0, n2);
                TraceXSLTParser.this.updateLineOffsets();
            }
            return n2;
        }

        @Override
        public int read(CharBuffer charBuffer) throws IOException {
            int n2 = charBuffer.arrayOffset();
            int n3 = this.m_reader.read(charBuffer);
            if (n3 > 0) {
                this.m_buffer.append(charBuffer, n2, n3);
                TraceXSLTParser.this.updateLineOffsets();
            }
            return n3;
        }

        @Override
        public boolean ready() throws IOException {
            return this.m_reader.ready();
        }

        @Override
        public long skip(long l) throws IOException {
            char[] cArray = new char[(int)l];
            int n2 = this.m_reader.read(cArray);
            if (n2 > 0) {
                this.m_buffer.append(cArray, 0, n2);
                TraceXSLTParser.this.updateLineOffsets();
            }
            return n2;
        }
    }

    private class Node {
        private static final int TYPE_START_ELEM = 1;
        private static final int TYPE_OTHER = 2;
        private final int m_type;
        private int m_line1;
        private int m_lineOffset1;
        private int m_absOffset1;
        private final int m_line2;
        private final int m_lineOffset2;
        private final int m_absOffset2;

        private Node(int n2, int n3, int n4) {
            char c;
            this.m_line2 = n2;
            this.m_lineOffset2 = n3;
            this.m_type = n4;
            int n5 = TraceXSLTParser.this.numCharsToEOL(n2 - 1) + (n3 - 1);
            if (n4 == 1 && 0 <= n5 && n5 < TraceXSLTParser.this.m_documentChars.length() && (c = TraceXSLTParser.this.m_documentChars.charAt(n5)) == '>') {
                ++n5;
            }
            this.m_absOffset2 = n5;
        }

        public void setAbsOffset1(int n2) {
            char c;
            if (this.m_type == 1 && 0 <= n2 && n2 < TraceXSLTParser.this.m_documentChars.length() && (c = TraceXSLTParser.this.m_documentChars.charAt(n2)) != '<' && ++n2 < TraceXSLTParser.this.m_documentChars.length() && (c = TraceXSLTParser.this.m_documentChars.charAt(n2)) != '<') {
                ++n2;
            }
            this.m_absOffset1 = n2;
        }
    }
}

