/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPath;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class Xq2xml {
    private static int MAXCHAR = 65535;

    public static void convert(String string2, PrintWriter printWriter, SimpleNode simpleNode) {
        printWriter.println();
        printWriter.print(string2 + "<" + XPathTreeConstants.jjtNodeName[simpleNode.getId()] + ">");
        if (simpleNode.getValue() != null) {
            printWriter.print("<data>");
            Xq2xml.printEscaped(printWriter, simpleNode.getValue());
            printWriter.print("</data>");
        }
        if (simpleNode.jjtGetNumChildren() > 0) {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (simpleNode2 == null) continue;
                Xq2xml.convert(string2 + " ", printWriter, simpleNode2);
            }
            printWriter.println();
            printWriter.print(string2);
        }
        printWriter.print("</" + XPathTreeConstants.jjtNodeName[simpleNode.getId()] + ">");
    }

    public static String convert(String string2) throws UnsupportedEncodingException {
        StringReader stringReader = new StringReader(string2);
        StringWriter stringWriter = new StringWriter();
        Xq2xml.convert(stringReader, stringWriter);
        stringWriter.flush();
        String string3 = stringWriter.getBuffer().toString();
        return string3;
    }

    public static String convert(File file) throws IOException, UnsupportedEncodingException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "utf-8");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(63488);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "utf-8");
        Xq2xml.convert(inputStreamReader, outputStreamWriter);
        try {
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string2 = new String(byteArrayOutputStream.toByteArray());
        return string2;
    }

    public static void convert(Reader reader, Writer writer) {
        try {
            XPath xPath = new XPath(null, reader);
            SimpleNode simpleNode = xPath.XPath2();
            if (null == simpleNode) {
                Xq2xml.printErrorString(writer, "no data");
            } else {
                PrintWriter printWriter = new PrintWriter(writer);
                Xq2xml.convert("", printWriter, simpleNode);
            }
        }
        catch (Exception exception) {
            Xq2xml.printErrorString(writer, exception.getMessage());
        }
        catch (Error error2) {
            Xq2xml.printErrorString(writer, error2.getMessage());
        }
    }

    public static void convert(InputStream inputStream, OutputStream outputStream) throws UnsupportedEncodingException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "utf-8");
        Xq2xml.convert(inputStreamReader, outputStreamWriter);
    }

    private static void writeUTF16Surrogate(PrintWriter printWriter, char c, char[] cArray, int n2, int n3) {
        int n4 = Xq2xml.getURF16SurrogateValue(c, cArray, n2, n3);
        printWriter.print('&');
        printWriter.print('#');
        printWriter.print(Integer.toString(n4));
        printWriter.print(';');
    }

    private static int getURF16SurrogateValue(char c, char[] cArray, int n2, int n3) {
        int n4;
        if (n2 + 1 >= n3) {
            throw new XPathError("ERR_SYSTEM", "Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        if (56320 > (n4 = cArray[++n2]) || n4 >= 57344) {
            throw new XPathError("ERR_SYSTEM", "Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        n4 = (c - 55296 << 10) + n4 - 56320 + 65536;
        return n4;
    }

    private static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    private static boolean canConvert(char c) {
        boolean bl;
        boolean bl2 = bl = c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
        if (!bl) {
            throw new XPathError("ERR_INVALID_CHAR", null);
        }
        return c <= MAXCHAR;
    }

    private static void printEscaped(PrintWriter printWriter, String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '<') {
                printWriter.print("&lt;");
                continue;
            }
            if (c == '>') {
                printWriter.print("&gt;");
                continue;
            }
            if (c == '&') {
                printWriter.print("&amp;");
                continue;
            }
            if (Xq2xml.isUTF16Surrogate(c)) {
                char[] cArray = string2.toCharArray();
                int n2 = string2.length();
                Xq2xml.writeUTF16Surrogate(printWriter, c, cArray, i, n2 - 1);
                continue;
            }
            if (!Xq2xml.canConvert(c)) {
                printWriter.print("&#");
                printWriter.print(Integer.toString(c));
                printWriter.print(";");
                continue;
            }
            printWriter.print(c);
        }
    }

    private static void printErrorString(PrintWriter printWriter, String string2) {
        printWriter.print("<error><data>");
        Xq2xml.printEscaped(printWriter, string2);
        printWriter.print("</data></error>");
    }

    private static void printErrorString(Writer writer, String string2) {
        PrintWriter printWriter = new PrintWriter(writer);
        Xq2xml.printErrorString(printWriter, string2);
        printWriter.flush();
    }

    private static String getErrorString(String string2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(63488);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        Xq2xml.printErrorString(printWriter, string2);
        printWriter.flush();
        String string3 = new String(byteArrayOutputStream.toByteArray());
        return string3;
    }
}

